/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.runtime;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.FrameSlotTypeException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.impl.FrameWithoutBoxing;
import com.oracle.truffle.api.nodes.BytecodeOSRNode;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.graalvm.compiler.truffle.runtime.BytecodeOSRRootNode;
import org.graalvm.compiler.truffle.runtime.GraalRuntimeAccessor;
import org.graalvm.compiler.truffle.runtime.OptimizedCallTarget;

public final class BytecodeOSRMetadata {
    public static final BytecodeOSRMetadata DISABLED = new BytecodeOSRMetadata(null, Integer.MAX_VALUE);
    public static final int OSR_POLL_INTERVAL = 1024;
    private final BytecodeOSRNode osrNode;
    @CompilerDirectives.CompilationFinal
    private volatile LazyState lazyState;
    private final int osrThreshold;
    private int backEdgeCount;

    LazyState getLazyState() {
        LazyState currentLazyState = this.lazyState;
        if (currentLazyState == null) {
            return this.getLazyStateBoundary();
        }
        return currentLazyState;
    }

    @CompilerDirectives.TruffleBoundary
    private LazyState getLazyStateBoundary() {
        return (LazyState)((Node)this.osrNode).atomic(() -> {
            LazyState lockedLazyState = this.lazyState;
            if (lockedLazyState == null) {
                lockedLazyState = this.lazyState = new LazyState();
            }
            return lockedLazyState;
        });
    }

    private void updateFrameSlots(FrameWithoutBoxing frame, OsrEntryDescription osrEntry) {
        CompilerAsserts.neverPartOfCompilation();
        LazyState state = this.getLazyState();
        ((Node)this.osrNode).atomic(() -> {
            if (!Assumption.isValidAssumption((Assumption)state.frameVersion)) {
                FrameDescriptor frameDescriptor;
                state.frameDescriptor = frameDescriptor = frame.getFrameDescriptor();
                state.frameVersion = frameDescriptor.getVersion();
                state.frameSlots = frameDescriptor.getSlots().toArray(new FrameSlot[0]);
            }
            if (osrEntry != null) {
                byte[] tags = frame.getTags();
                osrEntry.frameTags = Arrays.copyOf(tags, state.frameSlots.length);
                osrEntry.indexedFrameTags = new byte[state.frameDescriptor.getNumberOfSlots()];
                for (int i = 0; i < osrEntry.indexedFrameTags.length; ++i) {
                    osrEntry.indexedFrameTags[i] = frame.getTag(i);
                }
            }
        });
    }

    BytecodeOSRMetadata(BytecodeOSRNode osrNode, int osrThreshold) {
        this.osrNode = osrNode;
        this.osrThreshold = osrThreshold;
        this.backEdgeCount = 0;
    }

    Object tryOSR(int target, Object interpreterState, Runnable beforeTransfer, VirtualFrame parentFrame) {
        LazyState state = this.getLazyState();
        assert (state.frameDescriptor == null || state.frameDescriptor == parentFrame.getFrameDescriptor());
        OptimizedCallTarget callTarget = state.compilationMap.get(target);
        if (callTarget == null) {
            callTarget = (OptimizedCallTarget)((Node)this.osrNode).atomic(() -> {
                OptimizedCallTarget lockedTarget = state.compilationMap.get(target);
                if (lockedTarget == null) {
                    OsrEntryDescription entryDescription = new OsrEntryDescription();
                    lockedTarget = this.createOSRTarget(target, interpreterState, parentFrame.getFrameDescriptor(), entryDescription);
                    state.push(target, lockedTarget, entryDescription);
                    this.requestOSRCompilation(target, lockedTarget, (FrameWithoutBoxing)parentFrame);
                }
                return lockedTarget;
            });
        }
        if (callTarget.isCompiling()) {
            return null;
        }
        if (callTarget.isValid()) {
            if (beforeTransfer != null) {
                beforeTransfer.run();
            }
            return callTarget.callOSR(this.osrNode.storeParentFrameInArguments(parentFrame));
        }
        if (callTarget.isCompilationFailed()) {
            this.markCompilationFailed();
        } else {
            this.requestOSRCompilation(target, callTarget, (FrameWithoutBoxing)parentFrame);
        }
        return null;
    }

    public boolean incrementAndPoll() {
        int newBackEdgeCount;
        return (newBackEdgeCount = ++this.backEdgeCount) >= this.osrThreshold && (newBackEdgeCount & 0x3FF) == 0;
    }

    private OptimizedCallTarget createOSRTarget(int target, Object interpreterState, FrameDescriptor frameDescriptor, Object frameEntryState) {
        TruffleLanguage language = GraalRuntimeAccessor.NODES.getLanguage(((Node)this.osrNode).getRootNode());
        return (OptimizedCallTarget)new BytecodeOSRRootNode(language, frameDescriptor, this.osrNode, target, interpreterState, frameEntryState).getCallTarget();
    }

    private void requestOSRCompilation(int target, OptimizedCallTarget callTarget, FrameWithoutBoxing frame) {
        this.osrNode.prepareOSR(target);
        this.updateFrameSlots(frame, BytecodeOSRMetadata.getEntryCacheFromCallTarget(callTarget));
        callTarget.compile(true);
        if (callTarget.isCompilationFailed()) {
            this.markCompilationFailed();
        }
    }

    private static OsrEntryDescription getEntryCacheFromCallTarget(OptimizedCallTarget callTarget) {
        assert (callTarget.getRootNode() instanceof BytecodeOSRRootNode);
        return (OsrEntryDescription)((BytecodeOSRRootNode)callTarget.getRootNode()).getEntryTagsCache();
    }

    public void transferFrame(FrameWithoutBoxing source, FrameWithoutBoxing target, int bytecodeTarget, Object targetMetadata) {
        LazyState state = this.getLazyState();
        CompilerAsserts.partialEvaluationConstant((Object)state);
        BytecodeOSRMetadata.validateDescriptors(source, target, state);
        if (targetMetadata == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new IllegalArgumentException("Transferring frame for OSR from an uninitialized bytecode target.");
        }
        if (!(targetMetadata instanceof OsrEntryDescription)) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new IllegalArgumentException("Wrong usage of targetMetadata during OSR frame transfer.");
        }
        assert (targetMetadata == state.get(bytecodeTarget));
        OsrEntryDescription description = (OsrEntryDescription)targetMetadata;
        CompilerAsserts.partialEvaluationConstant((Object)description);
        if (!state.frameVersion.isValid()) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.updateFrameSlots(source, description);
        }
        BytecodeOSRMetadata.transferLoop(state.frameSlots.length, source, target, description.frameTags, state.frameSlots, FrameSlotTransfer.legacySlotTransfer);
        BytecodeOSRMetadata.transferLoop(description.indexedFrameTags.length, source, target, description.indexedFrameTags, null, FrameSlotTransfer.indexedTransfer);
        BytecodeOSRMetadata.transferAuxiliarySlots(source, target, state);
    }

    public void restoreFrame(FrameWithoutBoxing source, FrameWithoutBoxing target) {
        int length;
        LazyState state = this.getLazyState();
        CompilerAsserts.partialEvaluationConstant((Object)state);
        BytecodeOSRMetadata.validateDescriptors(source, target, state);
        if (!state.frameVersion.isValid()) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.updateFrameSlots(source, null);
        }
        if ((length = state.frameSlots.length) != source.getTags().length) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            length = source.getTags().length;
        }
        BytecodeOSRMetadata.transferLoop(length, source, target, null, state.frameSlots, FrameSlotTransfer.legacySlotTransfer);
        BytecodeOSRMetadata.transferLoop(state.frameDescriptor.getNumberOfSlots(), source, target, null, null, FrameSlotTransfer.indexedTransfer);
        BytecodeOSRMetadata.transferAuxiliarySlots(source, target, state);
    }

    private static void validateDescriptors(FrameWithoutBoxing source, FrameWithoutBoxing target, LazyState state) {
        if (source.getFrameDescriptor() != state.frameDescriptor) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new IllegalArgumentException("Source frame descriptor is different from the descriptor used for compilation.");
        }
        if (target.getFrameDescriptor() != state.frameDescriptor) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new IllegalArgumentException("Target frame descriptor is different from the descriptor used for compilation.");
        }
    }

    @ExplodeLoop
    private static void transferLoop(int length, FrameWithoutBoxing source, FrameWithoutBoxing target, byte[] expectedTags, FrameSlot[] frameSlotArray, FrameSlotTransfer transfer) {
        int i = 0;
        while (i < length) {
            boolean incompatibleTags;
            byte actualTag = transfer.getTag(source, i, frameSlotArray);
            byte expectedTag = expectedTags == null ? actualTag : expectedTags[i];
            boolean bl = incompatibleTags = expectedTag != actualTag;
            if (incompatibleTags) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                expectedTags[i] = actualTag;
                continue;
            }
            transfer.transfer(source, target, i, expectedTag, frameSlotArray);
            ++i;
        }
    }

    @ExplodeLoop
    private static void transferAuxiliarySlots(FrameWithoutBoxing source, FrameWithoutBoxing target, LazyState state) {
        for (int auxSlot = 0; auxSlot < state.frameDescriptor.getNumberOfAuxiliarySlots(); ++auxSlot) {
            target.setAuxiliarySlot(auxSlot, source.getAuxiliarySlot(auxSlot));
        }
    }

    private static void transferIndexedFrameSlot(FrameWithoutBoxing source, FrameWithoutBoxing target, int slot, byte expectedTag) {
        try {
            switch (expectedTag) {
                case 5: {
                    target.setBoolean(slot, source.getBoolean(slot));
                    break;
                }
                case 6: {
                    target.setByte(slot, source.getByte(slot));
                    break;
                }
                case 3: {
                    target.setDouble(slot, source.getDouble(slot));
                    break;
                }
                case 4: {
                    target.setFloat(slot, source.getFloat(slot));
                    break;
                }
                case 2: {
                    target.setInt(slot, source.getInt(slot));
                    break;
                }
                case 1: {
                    target.setLong(slot, source.getLong(slot));
                    break;
                }
                case 0: {
                    target.setObject(slot, source.getObject(slot));
                    break;
                }
                case 8: {
                    target.setObjectStatic(slot, source.getObjectStatic(slot));
                    target.setLongStatic(slot, source.getLongStatic(slot));
                    break;
                }
                case 7: {
                    target.clear(slot);
                }
            }
        }
        catch (FrameSlotTypeException e) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new AssertionError((Object)"Cannot transfer source frame.");
        }
    }

    private static void transferFrameSlot(FrameWithoutBoxing source, FrameWithoutBoxing target, FrameSlot slot, byte expectedTag) {
        assert (expectedTag != 8);
        try {
            switch (expectedTag) {
                case 5: {
                    target.setBoolean(slot, source.getBoolean(slot));
                    break;
                }
                case 6: {
                    target.setByte(slot, source.getByte(slot));
                    break;
                }
                case 3: {
                    target.setDouble(slot, source.getDouble(slot));
                    break;
                }
                case 4: {
                    target.setFloat(slot, source.getFloat(slot));
                    break;
                }
                case 2: {
                    target.setInt(slot, source.getInt(slot));
                    break;
                }
                case 1: {
                    target.setLong(slot, source.getLong(slot));
                    break;
                }
                case 0: {
                    target.setObject(slot, source.getObject(slot));
                    break;
                }
                case 7: {
                    target.clear(slot);
                }
            }
        }
        catch (FrameSlotTypeException e) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new AssertionError((Object)"Cannot transfer source frame.");
        }
    }

    void nodeReplaced(Node oldNode, Node newNode, CharSequence reason) {
        LazyState state = this.lazyState;
        if (state != null) {
            ((Node)this.osrNode).atomic(() -> {
                for (OptimizedCallTarget callTarget : state.compilationMap.values()) {
                    if (callTarget.isCompilationFailed()) {
                        this.markCompilationFailed();
                    }
                    callTarget.nodeReplaced(oldNode, newNode, reason);
                }
            });
        }
    }

    private void markCompilationFailed() {
        ((Node)this.osrNode).atomic(() -> {
            this.osrNode.setOSRMetadata((Object)DISABLED);
            LazyState state = this.lazyState;
            if (state != null) {
                state.doClear();
            }
        });
    }

    public Map<Integer, OptimizedCallTarget> getOSRCompilations() {
        return this.getLazyState().compilationMap;
    }

    public int getBackEdgeCount() {
        return this.backEdgeCount;
    }

    private static abstract class FinalCompilationListMap {
        @CompilerDirectives.CompilationFinal
        volatile Cell head = null;

        private FinalCompilationListMap() {
        }

        @ExplodeLoop
        public final OsrEntryDescription get(int target) {
            Cell cur = this.head;
            while (cur != null) {
                if (cur.target == target) {
                    return cur.entry;
                }
                cur = cur.next;
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void put(int target, OsrEntryDescription value) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            FinalCompilationListMap finalCompilationListMap = this;
            synchronized (finalCompilationListMap) {
                assert (this.get(target) == null);
                this.head = new Cell(target, value, this.head);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void clear() {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            FinalCompilationListMap finalCompilationListMap = this;
            synchronized (finalCompilationListMap) {
                this.head = null;
            }
        }

        private static final class Cell {
            final Cell next;
            final int target;
            final OsrEntryDescription entry;

            Cell(int target, OsrEntryDescription entry, Cell next) {
                this.next = next;
                this.target = target;
                this.entry = entry;
            }
        }
    }

    static final class OsrEntryDescription {
        @CompilerDirectives.CompilationFinal(dimensions=1)
        private byte[] frameTags;
        @CompilerDirectives.CompilationFinal(dimensions=1)
        private byte[] indexedFrameTags;

        OsrEntryDescription() {
        }
    }

    private static abstract class FrameSlotTransfer {
        private static final FrameSlotTransfer indexedTransfer = new FrameSlotTransfer(){

            @Override
            public void transfer(FrameWithoutBoxing source, FrameWithoutBoxing target, int slot, byte expectedTag, FrameSlot[] frameSlotArray) {
                BytecodeOSRMetadata.transferIndexedFrameSlot(source, target, slot, expectedTag);
            }

            @Override
            public byte getTag(FrameWithoutBoxing frame, int slot, FrameSlot[] frameSlotArray) {
                return frame.getTag(slot);
            }
        };
        private static final FrameSlotTransfer legacySlotTransfer = new FrameSlotTransfer(){

            @Override
            public void transfer(FrameWithoutBoxing source, FrameWithoutBoxing target, int slot, byte expectedTag, FrameSlot[] frameSlotArray) {
                FrameSlot frameSlot = frameSlotArray[slot];
                BytecodeOSRMetadata.transferFrameSlot(source, target, frameSlot, expectedTag);
            }

            @Override
            public byte getTag(FrameWithoutBoxing frame, int slot, FrameSlot[] frameSlotArray) {
                FrameSlot frameSlot = frameSlotArray[slot];
                return frame.getTag(frameSlot);
            }
        };

        private FrameSlotTransfer() {
        }

        public abstract void transfer(FrameWithoutBoxing var1, FrameWithoutBoxing var2, int var3, byte var4, FrameSlot[] var5);

        public abstract byte getTag(FrameWithoutBoxing var1, int var2, FrameSlot[] var3);
    }

    static final class LazyState
    extends FinalCompilationListMap {
        private final Map<Integer, OptimizedCallTarget> compilationMap = new ConcurrentHashMap<Integer, OptimizedCallTarget>();
        @CompilerDirectives.CompilationFinal
        private FrameDescriptor frameDescriptor = null;
        @CompilerDirectives.CompilationFinal
        private Assumption frameVersion = null;
        @CompilerDirectives.CompilationFinal(dimensions=1)
        private FrameSlot[] frameSlots = null;

        LazyState() {
        }

        private void push(int target, OptimizedCallTarget callTarget, OsrEntryDescription entry) {
            this.compilationMap.put(target, callTarget);
            this.put(target, entry);
        }

        private void doClear() {
            this.compilationMap.clear();
            this.clear();
        }
    }
}

