/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.runtime;

import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.graalvm.compiler.truffle.common.TruffleDebugContext;
import org.graalvm.compiler.truffle.runtime.GraalTruffleRuntime;
import org.graalvm.compiler.truffle.runtime.OptimizedCallTarget;
import org.graalvm.graphio.GraphOutput;
import org.graalvm.graphio.GraphStructure;

class PolymorphicSpecializeDump {
    PolymorphicSpecializeDump() {
    }

    public static void dumpPolymorphicSpecialize(OptimizedCallTarget callTarget, List<Node> toDump) {
        assert (toDump.size() > 0);
        try (TruffleDebugContext debugContext = PolymorphicSpecializeDump.openDebugContext(callTarget);){
            Collections.reverse(toDump);
            PolymorphicSpecializeGraph graph = new PolymorphicSpecializeGraph(toDump);
            GraphOutput<PolymorphicSpecializeGraph, ?> output = debugContext.buildOutput(GraphOutput.newBuilder(new PolymorphicSpecializeGraphStructure()));
            output.beginGroup(graph, "Polymorphic Specialize [" + callTarget + "]", "Polymorphic Specialize", null, 0, null);
            output.print(graph, null, 0, toDump.get(toDump.size() - 1).toString(), new Object[0]);
            output.endGroup();
            output.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static TruffleDebugContext openDebugContext(OptimizedCallTarget callTarget) {
        return GraalTruffleRuntime.getRuntime().getTruffleCompiler(callTarget).openDebugContext(GraalTruffleRuntime.getOptionsForCompiler(callTarget), null);
    }

    static class PolymorphicSpecializeGraphStructure
    implements GraphStructure<PolymorphicSpecializeGraph, PolymorphicSpecializeGraph.DumpNode, PolymorphicSpecializeGraph.DumpNodeClass, PolymorphicSpecializeGraph.DumpEdge> {
        PolymorphicSpecializeGraphStructure() {
        }

        @Override
        public PolymorphicSpecializeGraph graph(PolymorphicSpecializeGraph currentGraph, Object obj) {
            return obj instanceof PolymorphicSpecializeGraph ? (PolymorphicSpecializeGraph)obj : null;
        }

        @Override
        public Iterable<? extends PolymorphicSpecializeGraph.DumpNode> nodes(PolymorphicSpecializeGraph graph) {
            return graph.nodes;
        }

        @Override
        public int nodesCount(PolymorphicSpecializeGraph graph) {
            return graph.nodes.size();
        }

        @Override
        public int nodeId(PolymorphicSpecializeGraph.DumpNode node) {
            return node.id;
        }

        @Override
        public boolean nodeHasPredecessor(PolymorphicSpecializeGraph.DumpNode node) {
            return false;
        }

        @Override
        public void nodeProperties(PolymorphicSpecializeGraph graph, PolymorphicSpecializeGraph.DumpNode node, Map<String, ? super Object> properties) {
            properties.put("label", node.node.toString());
            properties.put("ROOT?", (Object)(node.node instanceof RootNode));
            properties.put("LEAF?", (Object)(node.edge == null ? 1 : 0));
            properties.put("RootNode", node.node.getRootNode());
            properties.putAll(node.node.getDebugProperties());
            properties.put("SourceSection", node.node.getSourceSection());
            if (Introspection.isIntrospectable((Node)node.node)) {
                List specializations = Introspection.getSpecializations((Node)node.node);
                for (Introspection.SpecializationInfo specialization : specializations) {
                    properties.put(specialization.getMethodName() + ".isActive", (Object)specialization.isActive());
                    properties.put(specialization.getMethodName() + ".isExcluded", (Object)specialization.isExcluded());
                    properties.put(specialization.getMethodName() + ".instances", (Object)specialization.getInstances());
                }
            }
        }

        @Override
        public PolymorphicSpecializeGraph.DumpNode node(Object obj) {
            return obj instanceof PolymorphicSpecializeGraph.DumpNode ? (PolymorphicSpecializeGraph.DumpNode)obj : null;
        }

        @Override
        public PolymorphicSpecializeGraph.DumpNodeClass nodeClass(Object obj) {
            return obj instanceof PolymorphicSpecializeGraph.DumpNodeClass ? (PolymorphicSpecializeGraph.DumpNodeClass)obj : null;
        }

        @Override
        public PolymorphicSpecializeGraph.DumpNodeClass classForNode(PolymorphicSpecializeGraph.DumpNode node) {
            return node.nodeClass;
        }

        @Override
        public String nameTemplate(PolymorphicSpecializeGraph.DumpNodeClass nodeClass) {
            return "{p#label}";
        }

        @Override
        public Object nodeClassType(PolymorphicSpecializeGraph.DumpNodeClass nodeClass) {
            return nodeClass.getClass();
        }

        @Override
        public PolymorphicSpecializeGraph.DumpEdge portInputs(PolymorphicSpecializeGraph.DumpNodeClass nodeClass) {
            return null;
        }

        @Override
        public PolymorphicSpecializeGraph.DumpEdge portOutputs(PolymorphicSpecializeGraph.DumpNodeClass nodeClass) {
            return nodeClass.node.edge;
        }

        @Override
        public int portSize(PolymorphicSpecializeGraph.DumpEdge port) {
            return port == null ? 0 : 1;
        }

        @Override
        public boolean edgeDirect(PolymorphicSpecializeGraph.DumpEdge port, int index) {
            return port != null;
        }

        @Override
        public String edgeName(PolymorphicSpecializeGraph.DumpEdge port, int index) {
            return "";
        }

        @Override
        public Object edgeType(PolymorphicSpecializeGraph.DumpEdge port, int index) {
            return PolymorphicSpecializeGraph.DumpEdgeEnum.CHILD;
        }

        @Override
        public Collection<? extends PolymorphicSpecializeGraph.DumpNode> edgeNodes(PolymorphicSpecializeGraph graph, PolymorphicSpecializeGraph.DumpNode node, PolymorphicSpecializeGraph.DumpEdge port, int index) {
            return Collections.singleton(node.edge.node);
        }
    }

    static class PolymorphicSpecializeGraph {
        int idCounter = 0;
        final List<DumpNode> nodes = new ArrayList<DumpNode>();

        DumpNode makeNode(Node node) {
            DumpNode n = new DumpNode(node);
            n.setNewClass();
            this.nodes.add(n);
            return n;
        }

        PolymorphicSpecializeGraph(List<Node> nodeChain) {
            DumpNode last = null;
            for (int i = 0; i < nodeChain.size(); ++i) {
                if (i == 0) {
                    last = this.makeNode(nodeChain.get(i));
                    for (DumpNode dumpNode : this.nodes) {
                        dumpNode.edge = new DumpEdge(last);
                    }
                    continue;
                }
                assert (last != null);
                DumpNode n = this.makeNode(nodeChain.get(i));
                last.edge = new DumpEdge(n);
                last = n;
            }
        }

        static enum DumpEdgeEnum {
            CHILD;

        }

        class DumpEdge {
            final DumpNode node;

            DumpEdge(DumpNode node) {
                this.node = node;
            }
        }

        static class DumpNodeClass {
            final DumpNode node;

            DumpNodeClass(DumpNode node) {
                this.node = node;
            }
        }

        class DumpNode {
            final Node node;
            final int id;
            DumpEdge edge;
            DumpNodeClass nodeClass;

            DumpNode(Node node) {
                this.id = PolymorphicSpecializeGraph.this.idCounter++;
                this.node = node;
            }

            void setNewClass() {
                this.nodeClass = new DumpNodeClass(this);
            }
        }
    }
}

