/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.runtime;

import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.Equivalence;
import org.graalvm.compiler.truffle.runtime.TruffleInlining;

final class TruffleNodeSources {
    private final EconomicMap<Node, TruffleInlining.TruffleSourceLanguagePosition> sourcePositionCache = EconomicMap.create((Equivalence)Equivalence.IDENTITY_WITH_SYSTEM_HASHCODE);
    private int nodeIdCounter;

    TruffleNodeSources() {
    }

    TruffleInlining.TruffleSourceLanguagePosition getSourceLocation(Node truffleNode) {
        TruffleInlining.TruffleSourceLanguagePosition position = (TruffleInlining.TruffleSourceLanguagePosition)this.sourcePositionCache.get((Object)truffleNode);
        if (position != null) {
            return position;
        }
        SourceSection section = null;
        if (truffleNode instanceof DirectCallNode) {
            section = ((DirectCallNode)truffleNode).getCurrentRootNode().getSourceSection();
        }
        if (section == null) {
            section = truffleNode.getSourceSection();
        }
        if (section == null) {
            for (Node cur = truffleNode.getParent(); cur != null && (section = cur.getSourceSection()) == null; cur = cur.getParent()) {
            }
        }
        position = new TruffleInlining.TruffleSourceLanguagePosition(section, truffleNode.getClass(), this.nodeIdCounter++);
        this.sourcePositionCache.put((Object)truffleNode, (Object)position);
        return position;
    }
}

