/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.virtual.phases.ea;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeSourcePosition;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.FloatingNode;
import org.graalvm.compiler.nodes.java.MonitorIdNode;
import org.graalvm.compiler.nodes.virtual.AllocatedObjectNode;
import org.graalvm.compiler.nodes.virtual.CommitAllocationNode;
import org.graalvm.compiler.nodes.virtual.LockState;
import org.graalvm.compiler.nodes.virtual.VirtualObjectNode;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.virtual.phases.ea.EffectList;
import org.graalvm.compiler.virtual.phases.ea.EffectsBlockState;
import org.graalvm.compiler.virtual.phases.ea.GraphEffectList;
import org.graalvm.compiler.virtual.phases.ea.ObjectState;
import org.graalvm.compiler.virtual.phases.ea.PartialEscapeClosure;
import org.graalvm.compiler.virtual.phases.ea.VirtualUtil;

public abstract class PartialEscapeBlockState<T extends PartialEscapeBlockState<T>>
extends EffectsBlockState<T> {
    private static final ObjectState[] EMPTY_ARRAY = new ObjectState[0];
    private ObjectState[] objectStates;
    private RefCount arrayRefCount;
    private final OptionValues options;
    private final DebugContext debug;

    public boolean contains(VirtualObjectNode value) {
        for (ObjectState state : this.objectStates) {
            if (state == null || !state.isVirtual() || state.getEntries() == null) continue;
            for (ValueNode entry : state.getEntries()) {
                if (entry != value) continue;
                return true;
            }
        }
        return false;
    }

    protected PartialEscapeBlockState(OptionValues options, DebugContext debug) {
        this.objectStates = EMPTY_ARRAY;
        this.arrayRefCount = new RefCount();
        this.options = options;
        this.debug = debug;
    }

    protected PartialEscapeBlockState(PartialEscapeBlockState<T> other) {
        super(other);
        this.adoptAddObjectStates(other);
        this.options = other.options;
        this.debug = other.debug;
    }

    public ObjectState getObjectState(int object) {
        ObjectState state = this.objectStates[object];
        assert (state != null);
        return state;
    }

    public ObjectState getObjectStateOptional(int object) {
        return object >= this.objectStates.length ? null : this.objectStates[object];
    }

    public boolean hasObjectState(int object) {
        return object >= 0 && object < this.objectStates.length && this.objectStates[object] != null;
    }

    public ObjectState getObjectState(VirtualObjectNode object) {
        ObjectState state = this.objectStates[object.getObjectId()];
        assert (state != null);
        return state;
    }

    public ObjectState getObjectStateOptional(VirtualObjectNode object) {
        int id = object.getObjectId();
        return id >= this.objectStates.length ? null : this.objectStates[id];
    }

    private ObjectState[] getObjectStateArrayForModification() {
        if (this.arrayRefCount.refCount > 1) {
            this.objectStates = (ObjectState[])this.objectStates.clone();
            --this.arrayRefCount.refCount;
            this.arrayRefCount = new RefCount();
        }
        return this.objectStates;
    }

    private ObjectState getObjectStateForModification(int object) {
        ObjectState[] array = this.getObjectStateArrayForModification();
        ObjectState objectState = array[object];
        if (objectState.copyOnWrite) {
            array[object] = objectState = objectState.cloneState();
        }
        return objectState;
    }

    public void setEntry(int object, int entryIndex, ValueNode value) {
        if (this.objectStates[object].getEntry(entryIndex) != value) {
            this.getObjectStateForModification(object).setEntry(entryIndex, value);
        }
    }

    public void escape(int object, ValueNode materialized) {
        this.getObjectStateForModification(object).escape(materialized);
    }

    public void addLock(int object, MonitorIdNode monitorId) {
        this.getObjectStateForModification(object).addLock(monitorId);
    }

    public MonitorIdNode removeLock(int object) {
        return this.getObjectStateForModification(object).removeLock();
    }

    public void setEnsureVirtualized(int object, boolean ensureVirtualized) {
        if (this.objectStates[object].getEnsureVirtualized() != ensureVirtualized) {
            this.getObjectStateForModification(object).setEnsureVirtualized(ensureVirtualized);
        }
    }

    public void updateMaterializedValue(int object, ValueNode value) {
        if (this.objectStates[object].getMaterializedValue() != value) {
            this.getObjectStateForModification(object).updateMaterializedValue(value);
        }
    }

    public void materializeBefore(final FixedNode fixed, VirtualObjectNode virtual, GraphEffectList materializeEffects) {
        PartialEscapeClosure.COUNTER_MATERIALIZATIONS.increment(fixed.getDebug());
        final ArrayList<AllocatedObjectNode> objects = new ArrayList<AllocatedObjectNode>(2);
        final ArrayList<ValueNode> values = new ArrayList<ValueNode>(8);
        final ArrayList<List<MonitorIdNode>> locks = new ArrayList<List<MonitorIdNode>>();
        final ArrayList<ValueNode> otherAllocations = new ArrayList<ValueNode>(2);
        final ArrayList<Boolean> ensureVirtual = new ArrayList<Boolean>(2);
        this.materializeWithCommit(fixed, virtual, objects, locks, values, ensureVirtual, otherAllocations);
        materializeEffects.addVirtualizationDelta(-(objects.size() + otherAllocations.size()));
        materializeEffects.add("materializeBefore", new EffectList.Effect(){

            @Override
            public void apply(StructuredGraph graph, ArrayList<Node> obsoleteNodes) {
                for (ValueNode alloc : otherAllocations) {
                    ValueNode otherAllocation = graph.addOrUniqueWithInputs(alloc);
                    if (otherAllocation instanceof FixedWithNextNode) {
                        graph.addBeforeFixed(fixed, (FixedWithNextNode)otherAllocation);
                        continue;
                    }
                    assert (otherAllocation instanceof FloatingNode);
                }
                if (!objects.isEmpty()) {
                    CommitAllocationNode commit;
                    if (fixed.predecessor() instanceof CommitAllocationNode) {
                        commit = (CommitAllocationNode)fixed.predecessor();
                    } else {
                        try (Iterator context = graph.withNodeSourcePosition(NodeSourcePosition.placeholder(graph.method()));){
                            commit = graph.add(new CommitAllocationNode());
                            graph.addBeforeFixed(fixed, commit);
                        }
                    }
                    for (AllocatedObjectNode obj : objects) {
                        graph.addWithoutUnique(obj);
                        commit.getVirtualObjects().add(obj.getVirtualObject());
                        obj.setCommit(commit);
                    }
                    for (ValueNode value : values) {
                        commit.getValues().add(graph.addOrUniqueWithInputs(value));
                    }
                    for (List monitorIds : locks) {
                        commit.addLocks(monitorIds);
                    }
                    commit.getEnsureVirtual().addAll(ensureVirtual);
                    assert (commit.usages().filter(AllocatedObjectNode.class).count() == commit.getUsageCount());
                    List<AllocatedObjectNode> materializedValues = commit.usages().filter(AllocatedObjectNode.class).snapshot();
                    for (int i = 0; i < commit.getValues().size(); ++i) {
                        if (!materializedValues.contains(commit.getValues().get(i))) continue;
                        commit.getValues().set(i, ((AllocatedObjectNode)commit.getValues().get(i)).getVirtualObject());
                    }
                }
            }
        });
    }

    private void materializeWithCommit(FixedNode fixed, VirtualObjectNode virtual, List<AllocatedObjectNode> objects, List<List<MonitorIdNode>> locks, List<ValueNode> values, List<Boolean> ensureVirtual, List<ValueNode> otherAllocations) {
        ObjectState obj = this.getObjectState(virtual);
        ValueNode[] entries = obj.getEntries();
        ValueNode representation = virtual.getMaterializedRepresentation(fixed, entries, obj.getLocks());
        this.escape(virtual.getObjectId(), representation);
        obj = this.getObjectState(virtual);
        PartialEscapeClosure.updateStatesForMaterialized(this, virtual, obj.getMaterializedValue());
        if (representation instanceof AllocatedObjectNode) {
            objects.add((AllocatedObjectNode)representation);
            locks.add(LockState.asList(obj.getLocks()));
            ensureVirtual.add(obj.getEnsureVirtualized());
            int pos = values.size();
            while (values.size() < pos + entries.length) {
                values.add(null);
            }
            for (int i = 0; i < entries.length; ++i) {
                if (entries[i] instanceof VirtualObjectNode) {
                    VirtualObjectNode entryVirtual = (VirtualObjectNode)entries[i];
                    ObjectState entryObj = this.getObjectState(entryVirtual);
                    if (entryObj.isVirtual()) {
                        this.materializeWithCommit(fixed, entryVirtual, objects, locks, values, ensureVirtual, otherAllocations);
                        entryObj = this.getObjectState(entryVirtual);
                    }
                    values.set(pos + i, entryObj.getMaterializedValue());
                    continue;
                }
                values.set(pos + i, entries[i]);
            }
            this.objectMaterialized(virtual, (AllocatedObjectNode)representation, values.subList(pos, pos + entries.length));
        } else {
            VirtualUtil.trace(this.options, this.debug, "materialized %s as %s", virtual, representation);
            otherAllocations.add(representation);
            assert (obj.getLocks() == null);
        }
    }

    protected void objectMaterialized(VirtualObjectNode virtual, AllocatedObjectNode representation, List<ValueNode> values) {
        VirtualUtil.trace(this.options, this.debug, "materialized %s as %s with values %s", virtual, representation, values);
    }

    public void addObject(int virtual, ObjectState state) {
        this.ensureSize((int)virtual)[virtual] = state;
    }

    private ObjectState[] ensureSize(int objectId) {
        if (this.objectStates.length <= objectId) {
            this.objectStates = Arrays.copyOf(this.objectStates, Math.max(objectId * 2, 4));
            --this.arrayRefCount.refCount;
            this.arrayRefCount = new RefCount();
            return this.objectStates;
        }
        return this.getObjectStateArrayForModification();
    }

    public int getStateCount() {
        return this.objectStates.length;
    }

    @Override
    public String toString() {
        return super.toString() + ", Object States: " + Arrays.toString(this.objectStates);
    }

    @Override
    public boolean equivalentTo(T other) {
        int length = Math.max(this.objectStates.length, ((PartialEscapeBlockState)other).getStateCount());
        for (int i = 0; i < length; ++i) {
            ObjectState right;
            ObjectState left = this.getObjectStateOptional(i);
            if (left == (right = ((PartialEscapeBlockState)other).getObjectStateOptional(i))) continue;
            if (left == null || right == null) {
                return false;
            }
            if (left.equals(right)) continue;
            return false;
        }
        return true;
    }

    public void resetObjectStates(int size) {
        this.objectStates = new ObjectState[size];
    }

    public static boolean identicalObjectStates(PartialEscapeBlockState<?>[] states) {
        for (int i = 1; i < states.length; ++i) {
            if (states[0].objectStates == states[i].objectStates) continue;
            return false;
        }
        return true;
    }

    public static boolean identicalObjectStates(PartialEscapeBlockState<?>[] states, int object) {
        for (int i = 1; i < states.length; ++i) {
            if (states[0].objectStates[object] == states[i].objectStates[object]) continue;
            return false;
        }
        return true;
    }

    public void adoptAddObjectStates(PartialEscapeBlockState<?> other) {
        if (this.objectStates != null) {
            --this.arrayRefCount.refCount;
        }
        this.objectStates = other.objectStates;
        this.arrayRefCount = other.arrayRefCount;
        if (this.arrayRefCount.refCount == 1) {
            for (ObjectState state : this.objectStates) {
                if (state == null) continue;
                state.share();
            }
        }
        ++this.arrayRefCount.refCount;
    }

    public static final class Final
    extends PartialEscapeBlockState<Final> {
        public Final(OptionValues options, DebugContext debug) {
            super(options, debug);
        }

        public Final(Final other) {
            super(other);
        }
    }

    private static class RefCount {
        private int refCount = 1;

        private RefCount() {
        }
    }
}

