/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.libgraal.jni.annotation;

final class Utilities {
    private Utilities() {
    }

    static void encodeType(Class<?> type, StringBuilder buf) {
        Object desc;
        if (type == Boolean.TYPE) {
            desc = "Z";
        } else if (type == Byte.TYPE) {
            desc = "B";
        } else if (type == Character.TYPE) {
            desc = "C";
        } else if (type == Short.TYPE) {
            desc = "S";
        } else if (type == Integer.TYPE) {
            desc = "I";
        } else if (type == Long.TYPE) {
            desc = "J";
        } else if (type == Float.TYPE) {
            desc = "F";
        } else if (type == Double.TYPE) {
            desc = "D";
        } else if (type == Void.TYPE) {
            desc = "V";
        } else {
            if (type.isArray()) {
                buf.append('[');
                Utilities.encodeType(type.getComponentType(), buf);
                return;
            }
            desc = "L" + type.getName().replace('.', '/') + ";";
        }
        buf.append((String)desc);
    }
}

