/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.core.gen;

import org.graalvm.compiler.debug.LogStream;
import org.graalvm.compiler.nodes.StateSplit;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.ValueNodeUtil;

public class InstructionPrinter {
    private final LogStream out;

    public InstructionPrinter(LogStream out) {
        this.out = out;
    }

    public LogStream out() {
        return this.out;
    }

    public void printInstructionListingHeader() {
        InstructionLineColumn.BCI.printLabel(this.out);
        InstructionLineColumn.USE.printLabel(this.out);
        InstructionLineColumn.VALUE.printLabel(this.out);
        InstructionLineColumn.INSTRUCTION.printLabel(this.out);
        InstructionLineColumn.END.printLabel(this.out);
        this.out.println();
    }

    public void printInstructionListing(ValueNode instruction) {
        int indentation = this.out.indentationLevel();
        this.out.fillTo(InstructionLineColumn.BCI.position + indentation, ' ').print(0).fillTo(InstructionLineColumn.USE.position + indentation, ' ').print("0").fillTo(InstructionLineColumn.VALUE.position + indentation, ' ').print(ValueNodeUtil.valueString(instruction)).fillTo(InstructionLineColumn.INSTRUCTION.position + indentation, ' ');
        this.printInstruction(instruction);
        if (instruction instanceof StateSplit) {
            this.out.print("  [state: " + ((StateSplit)((Object)instruction)).stateAfter() + "]");
        }
        this.out.println();
    }

    public void printInstruction(ValueNode node) {
        this.out.print(node.toString());
    }

    public static enum InstructionLineColumn {
        BCI(2, "bci"),
        USE(7, "use"),
        VALUE(12, "tid"),
        INSTRUCTION(19, "instr"),
        END(60, "");

        final int position;
        final String label;

        private InstructionLineColumn(int position, String label) {
            this.position = position;
            this.label = label;
        }

        public void printLabel(LogStream out) {
            out.fillTo(this.position + out.indentationLevel(), '_');
            out.print(this.label);
        }

        public void advance(LogStream out) {
            out.fillTo(this.position + out.indentationLevel(), ' ');
        }
    }
}

