/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.core.phases.fuzzing;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.phases.BasePhase;
import org.graalvm.compiler.phases.PhaseSuite;
import org.graalvm.compiler.phases.tiers.Suites;

public final class PhasePlanSerializer {
    private static <C> String phaseToString(BasePhase<? super C> phase, int level, String tier) {
        Formatter buf = new Formatter();
        String indent = level == 0 ? "" : new String(new char[level]).replace('\u0000', ' ');
        buf.format("%s%s in %s with hashCode=%s", indent, phase.getClass().getName(), tier, phase.hashCode());
        if (phase instanceof PhaseSuite) {
            List subPhases = ((PhaseSuite)phase).getPhases();
            for (BasePhase subPhase : subPhases) {
                buf.format("%n%s", PhasePlanSerializer.phaseToString(subPhase, level + 1, tier));
            }
        }
        return buf.toString();
    }

    private static <C> void savePhaseSuite(PhaseSuite<C> phaseSuite, DataOutputStream out, String tier) throws IOException {
        List<BasePhase<C>> phases = phaseSuite.getPhases();
        out.writeInt(phases.size());
        for (BasePhase<C> phase : phases) {
            out.writeUTF(PhasePlanSerializer.phaseToString(phase, 0, tier));
        }
    }

    private static <C> PhaseSuite<C> loadPhaseSuite(DataInputStream in, Map<String, BasePhase<? super C>> lookup) throws IOException {
        PhaseSuite<? super C> phaseSuite = new PhaseSuite<C>();
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            String key = in.readUTF();
            BasePhase<? super C> phase = lookup.get(key);
            if (phase == null) {
                GraalError.shouldNotReachHere("No phase could be found matching " + key);
            }
            phaseSuite.appendPhase(phase);
        }
        return phaseSuite;
    }

    private static <C> void collect(Map<String, BasePhase<? super C>> lookup, PhaseSuite<C> phaseSuite, String tier) {
        for (BasePhase<C> phase : phaseSuite.getPhases()) {
            String key = PhasePlanSerializer.phaseToString(phase, 0, tier);
            lookup.put(key, phase);
        }
    }

    public static void savePhasePlan(String fileName, Suites phasePlan) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try (DataOutputStream dos = new DataOutputStream(baos);){
                PhasePlanSerializer.savePhasePlan(dos, phasePlan);
            }
            Files.write(Paths.get(fileName, new String[0]), baos.toByteArray(), new OpenOption[0]);
        }
        catch (IOException e) {
            GraalError.shouldNotReachHere(e, "Error saving phase plan to " + fileName);
        }
    }

    public static void savePhasePlan(DataOutputStream dos, Suites phasePlan) throws IOException {
        PhasePlanSerializer.savePhaseSuite(phasePlan.getHighTier(), dos, "high tier");
        PhasePlanSerializer.savePhaseSuite(phasePlan.getMidTier(), dos, "mid tier");
        PhasePlanSerializer.savePhaseSuite(phasePlan.getLowTier(), dos, "low tier");
    }

    public static <C> Suites loadPhasePlan(String fileName, Suites originalSuites) {
        Suites suites;
        DataInputStream in = new DataInputStream(new FileInputStream(fileName));
        try {
            suites = PhasePlanSerializer.loadPhasePlan(in, originalSuites);
        }
        catch (Throwable throwable) {
            try {
                try {
                    in.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new GraalError(e, "Error loading phase plan from %s", fileName);
            }
        }
        in.close();
        return suites;
    }

    public static <C> Suites loadPhasePlan(DataInputStream in, Suites originalSuites) throws IOException {
        HashMap<String, BasePhase<? super C>> lookup = new HashMap<String, BasePhase<? super C>>();
        PhasePlanSerializer.collect(lookup, originalSuites.getHighTier(), "high tier");
        PhasePlanSerializer.collect(lookup, originalSuites.getMidTier(), "mid tier");
        PhasePlanSerializer.collect(lookup, originalSuites.getLowTier(), "low tier");
        PhaseSuite<? super C> highTier = PhasePlanSerializer.loadPhaseSuite(in, lookup);
        PhaseSuite<? super C> midTier = PhasePlanSerializer.loadPhaseSuite(in, lookup);
        PhaseSuite<? super C> lowTier = PhasePlanSerializer.loadPhaseSuite(in, lookup);
        return new Suites(highTier, midTier, lowTier);
    }
}

