/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.aarch64;

import jdk.vm.ci.aarch64.AArch64;
import jdk.vm.ci.aarch64.AArch64Kind;
import jdk.vm.ci.code.CodeUtil;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.asm.Label;
import org.graalvm.compiler.asm.aarch64.AArch64ASIMDAssembler;
import org.graalvm.compiler.asm.aarch64.AArch64Address;
import org.graalvm.compiler.asm.aarch64.AArch64Assembler;
import org.graalvm.compiler.asm.aarch64.AArch64MacroAssembler;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.StubPort;
import org.graalvm.compiler.lir.StubPorts;
import org.graalvm.compiler.lir.aarch64.AArch64LIRInstruction;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;

@StubPorts(value={@StubPort(path="src/hotspot/cpu/aarch64/stubGenerator_aarch64.cpp", lineStart=2562, lineEnd=2592, commit="f91943c19fc0b060684a437d2c768461d54c088e", sha1="350e5592f4df298c7ee648581bb1e8342edf9a05"), @StubPort(path="src/hotspot/cpu/aarch64/macroAssembler_aarch64_aes.cpp", lineStart=112, lineEnd=283, commit="2fe0ce01485d7b84dc109d3d4f24bdd908c0e7cf", sha1="0809579798e28fe7d2439e9ac5d5f8e23f1fcd21")})
public final class AArch64AESEncryptOp
extends AArch64LIRInstruction {
    public static final LIRInstructionClass<AArch64AESEncryptOp> TYPE = LIRInstructionClass.create(AArch64AESEncryptOp.class);
    private final int lengthOffset;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
    private Value fromValue;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
    private Value toValue;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
    private Value keyValue;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    private Value[] temps;

    public AArch64AESEncryptOp(Value fromValue, Value toValue, Value keyValue, int lengthOffset) {
        super((LIRInstructionClass<? extends AArch64LIRInstruction>)TYPE);
        this.fromValue = fromValue;
        this.toValue = toValue;
        this.keyValue = keyValue;
        this.lengthOffset = lengthOffset;
        this.temps = new Value[]{AArch64.v0.asValue(), AArch64.v17.asValue(), AArch64.v18.asValue(), AArch64.v19.asValue(), AArch64.v20.asValue(), AArch64.v21.asValue(), AArch64.v22.asValue(), AArch64.v23.asValue(), AArch64.v24.asValue(), AArch64.v25.asValue(), AArch64.v26.asValue(), AArch64.v27.asValue(), AArch64.v28.asValue(), AArch64.v29.asValue(), AArch64.v30.asValue(), AArch64.v31.asValue()};
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
        assert (this.fromValue.getPlatformKind().equals(AArch64Kind.QWORD)) : this.fromValue;
        assert (this.toValue.getPlatformKind().equals(AArch64Kind.QWORD)) : this.toValue;
        assert (this.keyValue.getPlatformKind().equals(AArch64Kind.QWORD)) : this.keyValue;
        Register from = ValueUtil.asRegister((Value)this.fromValue);
        Register to = ValueUtil.asRegister((Value)this.toValue);
        Register key = ValueUtil.asRegister((Value)this.keyValue);
        try (AArch64MacroAssembler.ScratchRegister sr = masm.getScratchRegister();){
            Register keylen = sr.getRegister();
            masm.ldr(32, keylen, AArch64Address.createImmediateAddress(32, AArch64Address.AddressingMode.IMMEDIATE_SIGNED_UNSCALED, key, this.lengthOffset));
            AArch64AESEncryptOp.aesencLoadkeys(masm, key, keylen);
            AArch64AESEncryptOp.aesecbEncrypt(masm, from, to, keylen, AArch64.v0, 1);
        }
    }

    static Register asFloatRegister(Register base, int offset) {
        return AArch64.simdRegisters.get(base.encoding + offset);
    }

    static void aesencLoadkeys(AArch64MacroAssembler masm, Register key, Register keylen) {
        Label loadkeys44 = new Label();
        Label loadkeys52 = new Label();
        masm.compare(32, keylen, 52);
        masm.branchConditionally(AArch64Assembler.ConditionFlag.LO, loadkeys44);
        masm.branchConditionally(AArch64Assembler.ConditionFlag.EQ, loadkeys52);
        AArch64Address ld1Addr = AArch64Address.createStructureImmediatePostIndexAddress(AArch64ASIMDAssembler.ASIMDInstruction.LD1_MULTIPLE_2R, AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, key, 32);
        masm.neon.ld1MultipleVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, AArch64.v17, AArch64.v18, ld1Addr);
        masm.neon.rev32VV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, AArch64.v17, AArch64.v17);
        masm.neon.rev32VV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, AArch64.v18, AArch64.v18);
        masm.bind(loadkeys52);
        ld1Addr = AArch64Address.createStructureImmediatePostIndexAddress(AArch64ASIMDAssembler.ASIMDInstruction.LD1_MULTIPLE_2R, AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, key, 32);
        masm.neon.ld1MultipleVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, AArch64.v19, AArch64.v20, ld1Addr);
        masm.neon.rev32VV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, AArch64.v19, AArch64.v19);
        masm.neon.rev32VV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, AArch64.v20, AArch64.v20);
        masm.bind(loadkeys44);
        ld1Addr = AArch64Address.createStructureImmediatePostIndexAddress(AArch64ASIMDAssembler.ASIMDInstruction.LD1_MULTIPLE_4R, AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, key, 64);
        masm.neon.ld1MultipleVVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, AArch64.v21, AArch64.v22, AArch64.v23, AArch64.v24, ld1Addr);
        masm.neon.rev32VV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, AArch64.v21, AArch64.v21);
        masm.neon.rev32VV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, AArch64.v22, AArch64.v22);
        masm.neon.rev32VV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, AArch64.v23, AArch64.v23);
        masm.neon.rev32VV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, AArch64.v24, AArch64.v24);
        ld1Addr = AArch64Address.createStructureImmediatePostIndexAddress(AArch64ASIMDAssembler.ASIMDInstruction.LD1_MULTIPLE_4R, AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, key, 64);
        masm.neon.ld1MultipleVVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, AArch64.v25, AArch64.v26, AArch64.v27, AArch64.v28, ld1Addr);
        masm.neon.rev32VV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, AArch64.v25, AArch64.v25);
        masm.neon.rev32VV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, AArch64.v26, AArch64.v26);
        masm.neon.rev32VV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, AArch64.v27, AArch64.v27);
        masm.neon.rev32VV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, AArch64.v28, AArch64.v28);
        ld1Addr = AArch64Address.createStructureImmediatePostIndexAddress(AArch64ASIMDAssembler.ASIMDInstruction.LD1_MULTIPLE_3R, AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, key, 48);
        masm.neon.ld1MultipleVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, AArch64.v29, AArch64.v30, AArch64.v31, ld1Addr);
        masm.neon.rev32VV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, AArch64.v29, AArch64.v29);
        masm.neon.rev32VV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, AArch64.v30, AArch64.v30);
        masm.neon.rev32VV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, AArch64.v31, AArch64.v31);
        masm.sub(64, key, key, keylen, AArch64Assembler.ShiftType.LSL, CodeUtil.log2((int)JavaKind.Int.getByteCount()));
    }

    static void aesecbEncrypt(AArch64MacroAssembler masm, Register from, Register to, Register keylen, Register data, int unrolls) {
        new AESKernelGenerator(masm, unrolls, from, to, keylen, data, AArch64.v17).unroll();
    }

    static final class AESKernelGenerator
    extends KernelGenerator {
        private final AArch64MacroAssembler masm;
        private final Register from;
        private final Register to;
        private final Register keylen;
        private final Register data;
        private final Register subkeys;
        private final boolean once;
        private final Label rounds44;
        private final Label rounds52;

        AESKernelGenerator(AArch64MacroAssembler masm, int unrolls, Register from, Register to, Register keylen, Register data, Register subkeys, boolean once) {
            super(unrolls);
            this.masm = masm;
            this.from = from;
            this.to = to;
            this.keylen = keylen;
            this.data = data;
            this.subkeys = subkeys;
            this.once = once;
            this.rounds44 = new Label();
            this.rounds52 = new Label();
        }

        AESKernelGenerator(AArch64MacroAssembler masm, int unrolls, Register from, Register to, Register keylen, Register data, Register subkeys) {
            this(masm, unrolls, from, to, keylen, data, subkeys, true);
        }

        private void aesRound(Register input, Register subkey) {
            this.masm.neon.aese(input, subkey);
            this.masm.neon.aesmc(input, input);
        }

        @Override
        public void generate(int index) {
            switch (index) {
                case 0: {
                    if (this.from.equals((Object)Register.None)) break;
                    this.masm.fldr(128, this.data, AArch64Address.createBaseRegisterOnlyAddress(128, this.from));
                    break;
                }
                case 1: {
                    if (!this.once) break;
                    this.masm.compare(32, this.keylen, 52);
                    this.masm.branchConditionally(AArch64Assembler.ConditionFlag.LO, this.rounds44);
                    this.masm.branchConditionally(AArch64Assembler.ConditionFlag.EQ, this.rounds52);
                    break;
                }
                case 2: {
                    this.aesRound(this.data, AArch64AESEncryptOp.asFloatRegister(this.subkeys, 0));
                    break;
                }
                case 3: {
                    this.aesRound(this.data, AArch64AESEncryptOp.asFloatRegister(this.subkeys, 1));
                    break;
                }
                case 4: {
                    if (!this.once) break;
                    this.masm.bind(this.rounds52);
                    break;
                }
                case 5: {
                    this.aesRound(this.data, AArch64AESEncryptOp.asFloatRegister(this.subkeys, 2));
                    break;
                }
                case 6: {
                    this.aesRound(this.data, AArch64AESEncryptOp.asFloatRegister(this.subkeys, 3));
                    break;
                }
                case 7: {
                    if (!this.once) break;
                    this.masm.bind(this.rounds44);
                    break;
                }
                case 8: {
                    this.aesRound(this.data, AArch64AESEncryptOp.asFloatRegister(this.subkeys, 4));
                    break;
                }
                case 9: {
                    this.aesRound(this.data, AArch64AESEncryptOp.asFloatRegister(this.subkeys, 5));
                    break;
                }
                case 10: {
                    this.aesRound(this.data, AArch64AESEncryptOp.asFloatRegister(this.subkeys, 6));
                    break;
                }
                case 11: {
                    this.aesRound(this.data, AArch64AESEncryptOp.asFloatRegister(this.subkeys, 7));
                    break;
                }
                case 12: {
                    this.aesRound(this.data, AArch64AESEncryptOp.asFloatRegister(this.subkeys, 8));
                    break;
                }
                case 13: {
                    this.aesRound(this.data, AArch64AESEncryptOp.asFloatRegister(this.subkeys, 9));
                    break;
                }
                case 14: {
                    this.aesRound(this.data, AArch64AESEncryptOp.asFloatRegister(this.subkeys, 10));
                    break;
                }
                case 15: {
                    this.aesRound(this.data, AArch64AESEncryptOp.asFloatRegister(this.subkeys, 11));
                    break;
                }
                case 16: {
                    this.aesRound(this.data, AArch64AESEncryptOp.asFloatRegister(this.subkeys, 12));
                    break;
                }
                case 17: {
                    this.masm.neon.aese(this.data, AArch64AESEncryptOp.asFloatRegister(this.subkeys, 13));
                    break;
                }
                case 18: {
                    this.masm.neon.eorVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, this.data, this.data, AArch64AESEncryptOp.asFloatRegister(this.subkeys, 14));
                    break;
                }
                case 19: {
                    if (this.to.equals((Object)Register.None)) break;
                    this.masm.fstr(128, this.data, AArch64Address.createBaseRegisterOnlyAddress(128, this.to));
                    break;
                }
                default: {
                    throw GraalError.shouldNotReachHere();
                }
            }
        }

        @Override
        public KernelGenerator next() {
            return new AESKernelGenerator(this.masm, this.unrolls, this.from, this.to, this.keylen, AArch64AESEncryptOp.asFloatRegister(this.data, 1), this.subkeys, false);
        }

        @Override
        public int length() {
            return 20;
        }
    }

    static abstract class KernelGenerator {
        protected final int unrolls;

        KernelGenerator(int unrolls) {
            this.unrolls = unrolls;
        }

        public abstract void generate(int var1);

        public abstract int length();

        public abstract KernelGenerator next();

        public void unroll() {
            KernelGenerator[] generators = new KernelGenerator[this.unrolls];
            generators[0] = this;
            for (int i = 1; i < this.unrolls; ++i) {
                generators[i] = generators[i - 1].next();
            }
            for (int j = 0; j < this.length(); ++j) {
                for (int i = 0; i < this.unrolls; ++i) {
                    generators[i].generate(j);
                }
            }
        }
    }
}

