/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.aarch64;

import jdk.vm.ci.aarch64.AArch64Kind;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.asm.aarch64.AArch64MacroAssembler;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.aarch64.AArch64LIRInstruction;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;

public class AArch64ReinterpretOp
extends AArch64LIRInstruction {
    private static final LIRInstructionClass<AArch64ReinterpretOp> TYPE = LIRInstructionClass.create(AArch64ReinterpretOp.class);
    @LIRInstruction.Def
    protected AllocatableValue resultValue;
    @LIRInstruction.Use
    protected AllocatableValue inputValue;

    public AArch64ReinterpretOp(AllocatableValue resultValue, AllocatableValue inputValue) {
        super((LIRInstructionClass<? extends AArch64LIRInstruction>)TYPE);
        AArch64Kind from = (AArch64Kind)inputValue.getPlatformKind();
        AArch64Kind to = (AArch64Kind)resultValue.getPlatformKind();
        assert (from.getSizeInBytes() == to.getSizeInBytes() && from.isInteger() ^ to.isInteger());
        this.resultValue = resultValue;
        this.inputValue = inputValue;
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
        Register result = ValueUtil.asRegister((Value)this.resultValue);
        Register input = ValueUtil.asRegister((Value)this.inputValue);
        AArch64Kind to = (AArch64Kind)this.resultValue.getPlatformKind();
        int size = to.getSizeInBytes() * 8;
        masm.fmov(size, result, input);
    }
}

