/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import jdk.vm.ci.meta.DeoptimizationAction;
import jdk.vm.ci.meta.DeoptimizationReason;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.EconomicSet;
import org.graalvm.collections.Equivalence;
import org.graalvm.compiler.core.common.PermanentBailoutException;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeBitMap;
import org.graalvm.compiler.graph.NodeInputList;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.AbstractEndNode;
import org.graalvm.compiler.nodes.AbstractMergeNode;
import org.graalvm.compiler.nodes.BeginNode;
import org.graalvm.compiler.nodes.ControlSinkNode;
import org.graalvm.compiler.nodes.ControlSplitNode;
import org.graalvm.compiler.nodes.DeoptimizeNode;
import org.graalvm.compiler.nodes.EndNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.GraphDecoder;
import org.graalvm.compiler.nodes.LoopBeginNode;
import org.graalvm.compiler.nodes.LoopEndNode;
import org.graalvm.compiler.nodes.LoopExitNode;
import org.graalvm.compiler.nodes.MergeNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.PhiNode;
import org.graalvm.compiler.nodes.ProfileData;
import org.graalvm.compiler.nodes.ProxyNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.ValuePhiNode;
import org.graalvm.compiler.nodes.ValueProxyNode;
import org.graalvm.compiler.nodes.extended.IntegerSwitchNode;
import org.graalvm.compiler.nodes.graphbuilderconf.LoopExplosionPlugin;

class LoopDetector
implements Runnable {
    private final StructuredGraph graph;
    private final GraphDecoder.MethodScope methodScope;
    private Loop irreducibleLoopHandler;
    private IntegerSwitchNode irreducibleLoopSwitch;

    protected LoopDetector(StructuredGraph graph, GraphDecoder.MethodScope methodScope) {
        this.graph = graph;
        this.methodScope = methodScope;
    }

    @Override
    public void run() {
        DebugContext debug = this.graph.getDebug();
        debug.dump(4, this.graph, "Before loop detection");
        if (this.methodScope.loopExplosionHead == null) {
            return;
        }
        List<Loop> orderedLoops = this.findLoops();
        assert (orderedLoops.get(orderedLoops.size() - 1) == this.irreducibleLoopHandler) : "outermost loop must be the last element in the list";
        for (Loop loop : orderedLoops) {
            if (loop.ends.isEmpty()) {
                assert (loop == this.irreducibleLoopHandler);
                continue;
            }
            this.findLoopExits(loop);
            if (loop.irreducible) {
                this.handleIrreducibleLoop(loop);
            } else {
                this.insertLoopNodes(loop);
            }
            debug.dump(4, (Object)this.graph, "After handling of loop %s", loop.header);
        }
        this.logIrreducibleLoops();
        debug.dump(4, this.graph, "After loop detection");
    }

    private List<Loop> findLoops() {
        EconomicMap unorderedLoops = EconomicMap.create((Equivalence)Equivalence.IDENTITY);
        ArrayList<Loop> orderedLoops = new ArrayList<Loop>();
        this.irreducibleLoopHandler = this.findOrCreateLoop((EconomicMap<MergeNode, Loop>)unorderedLoops, this.methodScope.loopExplosionHead);
        NodeBitMap visited = this.graph.createNodeBitMap();
        NodeBitMap active = this.graph.createNodeBitMap();
        ArrayDeque<Node> stack = new ArrayDeque<Node>();
        visited.mark(this.methodScope.loopExplosionHead);
        stack.push(this.methodScope.loopExplosionHead);
        while (!stack.isEmpty()) {
            Node current = (Node)stack.peek();
            assert (visited.isMarked(current));
            if (active.isMarked(current)) {
                Loop loop;
                stack.pop();
                active.clear(current);
                if (!(current instanceof MergeNode) || (loop = (Loop)unorderedLoops.get((Object)((MergeNode)current))) == null) continue;
                assert (!orderedLoops.contains(loop));
                orderedLoops.add(loop);
                continue;
            }
            active.mark(current);
            for (Node node : current.cfgSuccessors()) {
                if (active.isMarked(node)) {
                    Loop loop = this.findOrCreateLoop((EconomicMap<MergeNode, Loop>)unorderedLoops, (MergeNode)node);
                    assert (!loop.ends.contains(current));
                    loop.ends.add((EndNode)current);
                    continue;
                }
                if (visited.isMarked(node)) continue;
                visited.mark(node);
                stack.push(node);
            }
        }
        return orderedLoops;
    }

    private Loop findOrCreateLoop(EconomicMap<MergeNode, Loop> unorderedLoops, MergeNode loopHeader) {
        assert (this.methodScope.loopExplosionMerges.contains((Object)loopHeader)) : loopHeader;
        Loop loop = (Loop)unorderedLoops.get((Object)loopHeader);
        if (loop == null) {
            loop = new Loop();
            loop.header = loopHeader;
            unorderedLoops.put((Object)loopHeader, (Object)loop);
        }
        return loop;
    }

    /*
     * WARNING - void declaration
     */
    private void findLoopExits(Loop loop) {
        Object current;
        ArrayList<Node> possibleExits = new ArrayList<Node>();
        NodeBitMap visited = this.graph.createNodeBitMap();
        ArrayDeque<Node> stack = new ArrayDeque<Node>();
        for (EndNode endNode : loop.ends) {
            stack.push(endNode);
            visited.mark(endNode);
        }
        while (!stack.isEmpty()) {
            current = (Node)stack.pop();
            if (current == loop.header) continue;
            if (!this.graph.isNew(this.methodScope.methodStartMark, (Node)current)) {
                loop.irreducible = true;
                return;
            }
            for (Node node : ((Node)current).cfgPredecessors()) {
                if (node instanceof LoopExitNode) {
                    LoopBeginNode innerLoopBegin = ((LoopExitNode)node).loopBegin();
                    if (visited.isMarked(innerLoopBegin)) continue;
                    stack.push(innerLoopBegin);
                    visited.mark(innerLoopBegin);
                    for (LoopExitNode exit : innerLoopBegin.loopExits()) {
                        possibleExits.add(exit);
                    }
                    continue;
                }
                if (visited.isMarked(node)) continue;
                stack.push(node);
                visited.mark(node);
                if (!(node instanceof ControlSplitNode)) continue;
                for (Node node2 : node.cfgSuccessors()) {
                    possibleExits.add(node2);
                }
            }
        }
        for (Node node : possibleExits) {
            if (visited.contains(node)) continue;
            stack.push(node);
            visited.mark(node);
            assert (!this.methodScope.loopExplosionMerges.contains((Object)node));
        }
        while (!stack.isEmpty()) {
            current = (Node)stack.pop();
            assert (visited.isMarked((Node)current));
            assert (current instanceof ControlSinkNode || current instanceof LoopEndNode || ((Node)current).cfgSuccessors().iterator().hasNext()) : "Must not reach a node that has not been decoded yet";
            for (Node node : ((Node)current).cfgSuccessors()) {
                if (visited.isMarked(node)) continue;
                if (this.methodScope.loopExplosionMerges.contains((Object)node)) {
                    assert (node instanceof MergeNode);
                    assert (!loop.exits.contains(current));
                    loop.exits.add((AbstractEndNode)current);
                    continue;
                }
                visited.mark(node);
                stack.push(node);
            }
        }
        EconomicSet merges = EconomicSet.create((Equivalence)Equivalence.IDENTITY_WITH_SYSTEM_HASHCODE);
        EconomicSet economicSet = EconomicSet.create((Equivalence)Equivalence.IDENTITY_WITH_SYSTEM_HASHCODE);
        for (AbstractEndNode end : loop.exits) {
            AbstractMergeNode abstractMergeNode = end.merge();
            assert (abstractMergeNode instanceof MergeNode);
            if (merges.contains((Object)((MergeNode)abstractMergeNode))) {
                economicSet.add((Object)((MergeNode)abstractMergeNode));
                continue;
            }
            merges.add((Object)((MergeNode)abstractMergeNode));
        }
        merges.clear();
        merges.addAll(economicSet);
        economicSet.clear();
        block9: for (MergeNode merge : merges) {
            for (EndNode end : merge.ends) {
                if (loop.exits.contains(end)) continue;
                continue block9;
            }
            economicSet.add((Object)merge);
        }
        if (economicSet.size() > 0) {
            assert (merges.size() < loop.exits.size());
            Iterator iterator = economicSet.iterator();
            block11: while (iterator.hasNext()) {
                void var9_30;
                MergeNode merge;
                MergeNode mergeNode = merge = (MergeNode)iterator.next();
                while (var9_30 != null) {
                    if (var9_30 instanceof FixedWithNextNode) {
                        FixedNode fixedNode = ((FixedWithNextNode)var9_30).next();
                        continue;
                    }
                    if (!(var9_30 instanceof EndNode) || !this.methodScope.loopExplosionMerges.contains((Object)((EndNode)var9_30).merge())) continue block11;
                    loop.exits.removeIf(x -> x.merge() == merge);
                    loop.exits.add((EndNode)var9_30);
                    continue block11;
                }
            }
        }
    }

    private void insertLoopNodes(Loop loop) {
        MergeNode merge = loop.header;
        FrameState stateAfter = merge.stateAfter().duplicate();
        FixedNode afterMerge = merge.next();
        merge.setNext(null);
        EndNode preLoopEnd = this.graph.add(new EndNode());
        LoopBeginNode loopBegin = this.graph.add(new LoopBeginNode());
        merge.setNext(preLoopEnd);
        loopBegin.addForwardEnd(preLoopEnd);
        loopBegin.setNext(afterMerge);
        loopBegin.setStateAfter(stateAfter);
        List<PhiNode> mergePhis = merge.phis().snapshot();
        ArrayList<PhiNode> loopBeginPhis = new ArrayList<PhiNode>(mergePhis.size());
        for (int i = 0; i < mergePhis.size(); ++i) {
            PhiNode mergePhi = mergePhis.get(i);
            PhiNode loopBeginPhi = this.graph.addWithoutUnique(new ValuePhiNode(mergePhi.stamp(NodeView.DEFAULT), loopBegin));
            mergePhi.replaceAtUsages(loopBeginPhi);
            loopBeginPhi.addInput(mergePhi);
            loopBeginPhis.add(loopBeginPhi);
        }
        for (EndNode endNode : loop.ends) {
            for (int i = 0; i < mergePhis.size(); ++i) {
                PhiNode mergePhi = mergePhis.get(i);
                PhiNode loopBeginPhi = (PhiNode)loopBeginPhis.get(i);
                loopBeginPhi.addInput(mergePhi.valueAt(endNode));
            }
            merge.removeEnd(endNode);
            LoopEndNode loopEnd = this.graph.add(new LoopEndNode(loopBegin));
            endNode.replaceAndDelete(loopEnd);
        }
        for (AbstractEndNode exit : loop.exits) {
            AbstractMergeNode loopExplosionMerge = exit.merge();
            assert (this.methodScope.loopExplosionMerges.contains((Object)loopExplosionMerge));
            LoopExitNode loopExit = this.graph.add(new LoopExitNode(loopBegin));
            exit.replaceAtPredecessor(loopExit);
            loopExit.setNext(exit);
            this.assignLoopExitState(loopExit, loopExplosionMerge, exit);
        }
    }

    private void assignLoopExitState(final LoopExitNode loopExit, final AbstractMergeNode loopExplosionMerge, final AbstractEndNode loopExplosionEnd) {
        FrameState oldState = loopExplosionMerge.stateAfter();
        final EconomicSet loopBeginValues = EconomicSet.create((Equivalence)Equivalence.IDENTITY);
        for (FrameState state = loopExit.loopBegin().stateAfter(); state != null; state = state.outerFrameState()) {
            for (ValueNode value : state.values()) {
                if (value == null || value.isConstant() || loopExit.loopBegin().isPhiAtMerge(value)) continue;
                loopBeginValues.add((Object)GraphDecoder.ProxyPlaceholder.unwrap(value));
            }
        }
        final EconomicMap old2NewValues = EconomicMap.create();
        FrameState.ValueFunction valueFunction = new FrameState.ValueFunction(){

            @Override
            public ValueNode apply(int index, ValueNode v) {
                if (v != null && old2NewValues.containsKey((Object)v)) {
                    return (ValueNode)old2NewValues.get((Object)v);
                }
                ValueNode value = v;
                ValueNode realValue = GraphDecoder.ProxyPlaceholder.unwrap(value);
                if (realValue instanceof PhiNode && loopExplosionMerge.isPhiAtMerge(realValue)) {
                    value = ((PhiNode)realValue).valueAt(loopExplosionEnd);
                    realValue = GraphDecoder.ProxyPlaceholder.unwrap(value);
                }
                if (realValue == null || realValue.isConstant() || loopBeginValues.contains((Object)realValue) || !LoopDetector.this.graph.isNew(LoopDetector.this.methodScope.methodStartMark, realValue)) {
                    if (v != null) {
                        old2NewValues.put((Object)v, (Object)v);
                    }
                    return v;
                }
                GraalError.guarantee(value instanceof GraphDecoder.ProxyPlaceholder && ((GraphDecoder.ProxyPlaceholder)value).proxyPoint == loopExplosionMerge, "Value flowing out of loop, but we are not prepared to insert a ProxyNode");
                GraphDecoder.ProxyPlaceholder proxyPlaceholder = (GraphDecoder.ProxyPlaceholder)value;
                ValueProxyNode proxy = ProxyNode.forValue(proxyPlaceholder.value, loopExit);
                proxyPlaceholder.setValue(proxy);
                old2NewValues.put((Object)v, (Object)proxy);
                return proxy;
            }
        };
        FrameState newState = oldState.duplicate(valueFunction);
        assert (loopExit.stateAfter() == null);
        loopExit.setStateAfter(this.graph.add(newState));
    }

    private void handleIrreducibleLoop(Loop loop) {
        AbstractBeginNode unreachableDefaultSuccessor;
        int i;
        ValuePhiNode loopVariablePhi;
        assert (loop != this.irreducibleLoopHandler);
        FrameState loopState = loop.header.stateAfter();
        FrameState explosionHeadState = this.irreducibleLoopHandler.header.stateAfter();
        assert (loopState.outerFrameState() == explosionHeadState.outerFrameState());
        NodeInputList<ValueNode> loopValues = loopState.values();
        NodeInputList<ValueNode> explosionHeadValues = explosionHeadState.values();
        assert (loopValues.size() == explosionHeadValues.size());
        int loopVariableIndex = -1;
        ValueNode loopValue = null;
        ValueNode explosionHeadValue = null;
        for (int i2 = 0; i2 < loopValues.size(); ++i2) {
            ValueNode curLoopValue = (ValueNode)loopValues.get(i2);
            ValueNode curExplosionHeadValue = (ValueNode)explosionHeadValues.get(i2);
            if (GraphDecoder.ProxyPlaceholder.unwrap(curLoopValue) == GraphDecoder.ProxyPlaceholder.unwrap(curExplosionHeadValue)) continue;
            if (loopVariableIndex != -1) {
                throw LoopDetector.bailout("must have only one variable that is changed in loop. " + loopValue + " != " + explosionHeadValue + " and " + curLoopValue + " != " + curExplosionHeadValue);
            }
            loopVariableIndex = i2;
            loopValue = curLoopValue;
            explosionHeadValue = curExplosionHeadValue;
        }
        assert (loopVariableIndex != -1);
        assert (explosionHeadValue != null);
        TreeMap<Integer, AbstractBeginNode> dispatchTable = new TreeMap<Integer, AbstractBeginNode>();
        if (this.irreducibleLoopSwitch == null) {
            assert (!this.irreducibleLoopHandler.header.isPhiAtMerge(explosionHeadValue));
            assert (this.irreducibleLoopHandler.header.phis().isEmpty());
            loopVariablePhi = this.graph.addWithoutUnique(new ValuePhiNode(explosionHeadValue.stamp(NodeView.DEFAULT).unrestricted(), this.irreducibleLoopHandler.header));
            for (i = 0; i < this.irreducibleLoopHandler.header.phiPredecessorCount(); ++i) {
                loopVariablePhi.addInput(explosionHeadValue);
            }
            final int loopVariableIndexCopy = loopVariableIndex;
            FrameState.ValueFunction valueFunction = new FrameState.ValueFunction(){

                @Override
                public ValueNode apply(int index, ValueNode node) {
                    if (index == loopVariableIndexCopy) {
                        return loopVariablePhi;
                    }
                    return node;
                }
            };
            FrameState newFrameState = this.graph.add(explosionHeadState.duplicate(valueFunction));
            explosionHeadState.replaceAtUsages(newFrameState);
            FixedNode handlerNext = this.irreducibleLoopHandler.header.next();
            this.irreducibleLoopHandler.header.setNext(null);
            BeginNode handlerBegin = this.graph.add(new BeginNode());
            handlerBegin.setNext(handlerNext);
            dispatchTable.put(LoopDetector.asInt(explosionHeadValue), handlerBegin);
            unreachableDefaultSuccessor = this.graph.add(new BeginNode());
            DeoptimizeNode deopt = this.graph.add(new DeoptimizeNode(DeoptimizationAction.InvalidateRecompile, DeoptimizationReason.UnreachedCode));
            unreachableDefaultSuccessor.setNext(deopt);
        } else {
            assert (this.irreducibleLoopHandler.header.isPhiAtMerge(explosionHeadValue));
            assert (this.irreducibleLoopHandler.header.phis().count() == 1 && this.irreducibleLoopHandler.header.phis().first() == explosionHeadValue);
            assert (this.irreducibleLoopSwitch.value() == explosionHeadValue);
            loopVariablePhi = (ValuePhiNode)explosionHeadValue;
            for (i = 0; i < this.irreducibleLoopSwitch.keyCount(); ++i) {
                int key = this.irreducibleLoopSwitch.keyAt(i).asInt();
                dispatchTable.put(key, this.irreducibleLoopSwitch.successorAtKey(key));
            }
            unreachableDefaultSuccessor = this.irreducibleLoopSwitch.defaultSuccessor();
            assert (this.irreducibleLoopHandler.header.next() == this.irreducibleLoopSwitch);
            this.irreducibleLoopHandler.header.setNext(null);
            this.irreducibleLoopSwitch.clearSuccessors();
            this.irreducibleLoopSwitch.safeDelete();
        }
        assert (loop.header.phis().isEmpty());
        BeginNode dispatchBegin = this.graph.add(new BeginNode());
        EndNode dispatchEnd = this.graph.add(new EndNode());
        dispatchBegin.setNext(dispatchEnd);
        loop.header.addForwardEnd(dispatchEnd);
        int intLoopValue = LoopDetector.asInt(loopValue);
        assert (!dispatchTable.containsKey(intLoopValue));
        dispatchTable.put(intLoopValue, dispatchBegin);
        for (EndNode end : loop.ends) {
            loop.header.removeEnd(end);
            this.irreducibleLoopHandler.ends.add(end);
            this.irreducibleLoopHandler.header.addForwardEnd(end);
            loopVariablePhi.addInput(loopValue);
        }
        this.irreducibleLoopSwitch = this.graph.add(LoopDetector.createSwitch(loopVariablePhi, dispatchTable, unreachableDefaultSuccessor));
        this.irreducibleLoopHandler.header.setNext(this.irreducibleLoopSwitch);
    }

    private static int asInt(ValueNode node) {
        if (!node.isConstant() || node.asJavaConstant().getJavaKind() != JavaKind.Int) {
            throw LoopDetector.bailout("must have a loop variable of type int. " + node);
        }
        return node.asJavaConstant().asInt();
    }

    private static RuntimeException bailout(String msg) {
        throw new PermanentBailoutException("Graal implementation restriction: Method with %s loop explosion %s", new Object[]{LoopExplosionPlugin.LoopExplosionKind.MERGE_EXPLODE, msg});
    }

    private static IntegerSwitchNode createSwitch(ValuePhiNode switchedValue, SortedMap<Integer, AbstractBeginNode> dispatchTable, AbstractBeginNode defaultSuccessor) {
        int numKeys = dispatchTable.size();
        int numSuccessors = numKeys + 1;
        AbstractBeginNode[] switchSuccessors = new AbstractBeginNode[numSuccessors];
        int[] switchKeys = new int[numKeys];
        double[] switchKeyProbabilities = new double[numSuccessors];
        int[] switchKeySuccessors = new int[numSuccessors];
        int idx = 0;
        for (Map.Entry<Integer, AbstractBeginNode> entry : dispatchTable.entrySet()) {
            switchSuccessors[idx] = entry.getValue();
            switchKeys[idx] = entry.getKey();
            switchKeyProbabilities[idx] = 1.0 / (double)numKeys;
            switchKeySuccessors[idx] = idx;
            ++idx;
        }
        switchSuccessors[idx] = defaultSuccessor;
        switchKeyProbabilities[idx] = 0.0;
        switchKeySuccessors[idx] = idx;
        return new IntegerSwitchNode((ValueNode)switchedValue, switchSuccessors, switchKeys, switchKeySuccessors, ProfileData.SwitchProbabilityData.unknown(switchKeyProbabilities));
    }

    private void logIrreducibleLoops() {
        DebugContext debug = this.graph.getDebug();
        try (DebugContext.Scope s = debug.scope("IrreducibleLoops");){
            if (debug.isLogEnabled(1) && this.irreducibleLoopSwitch != null) {
                StringBuilder msg = new StringBuilder("Inserted state machine to remove irreducible loops. Dispatching to the following states: ");
                String sep = "";
                for (int i = 0; i < this.irreducibleLoopSwitch.keyCount(); ++i) {
                    msg.append(sep).append(this.irreducibleLoopSwitch.keyAt(i).asInt());
                    sep = ", ";
                }
                debug.log(1, "%s", (Object)msg);
            }
        }
    }

    static class Loop {
        MergeNode header;
        List<EndNode> ends = new ArrayList<EndNode>(2);
        List<AbstractEndNode> exits = new ArrayList<AbstractEndNode>();
        boolean irreducible;

        Loop() {
        }
    }
}

