/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.phases.graph;

import java.util.function.ToDoubleFunction;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.Equivalence;
import org.graalvm.compiler.debug.CounterKey;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeInputList;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.AbstractEndNode;
import org.graalvm.compiler.nodes.AbstractMergeNode;
import org.graalvm.compiler.nodes.ControlSplitNode;
import org.graalvm.compiler.nodes.EndNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.LoopBeginNode;
import org.graalvm.compiler.nodes.StartNode;
import org.graalvm.compiler.nodes.cfg.ControlFlowGraph;

public class FixedNodeRelativeFrequencyCache
implements ToDoubleFunction<FixedNode> {
    private static final CounterKey computeNodeRelativeFrequencyCounter = DebugContext.counter("ComputeNodeRelativeFrequency");
    private final EconomicMap<FixedNode, Double> cache = EconomicMap.create((Equivalence)Equivalence.IDENTITY);

    @Override
    public double applyAsDouble(FixedNode node) {
        assert (node != null);
        computeNodeRelativeFrequencyCounter.increment(node.getDebug());
        FixedNode current = FixedNodeRelativeFrequencyCache.findBegin(node);
        if (current == null) {
            return 1.0;
        }
        assert (current instanceof AbstractBeginNode);
        Double cachedValue = (Double)this.cache.get((Object)current);
        if (cachedValue != null) {
            return cachedValue;
        }
        ControlFlowGraph cfg = ControlFlowGraph.compute(node.graph(), false, false, false, false);
        double relativeFrequency = 0.0;
        if (current.predecessor() == null) {
            if (current instanceof AbstractMergeNode) {
                relativeFrequency = this.handleMerge(current, relativeFrequency, cfg);
            } else {
                assert (current instanceof StartNode);
                relativeFrequency = 1.0;
            }
        } else {
            ControlSplitNode split = (ControlSplitNode)current.predecessor();
            relativeFrequency = ControlFlowGraph.multiplyRelativeFrequencies(split.probability((AbstractBeginNode)current), this.applyAsDouble(split));
        }
        assert (!Double.isNaN(relativeFrequency) && !Double.isInfinite(relativeFrequency)) : current + " " + relativeFrequency;
        this.cache.put((Object)current, (Object)relativeFrequency);
        return relativeFrequency;
    }

    private double handleMerge(FixedNode current, double relativeFrequency, ControlFlowGraph cfg) {
        double result = relativeFrequency;
        AbstractMergeNode currentMerge = (AbstractMergeNode)current;
        NodeInputList<EndNode> currentForwardEnds = currentMerge.forwardEnds();
        for (AbstractEndNode abstractEndNode : currentForwardEnds) {
            result += this.applyAsDouble(abstractEndNode);
        }
        if (current instanceof LoopBeginNode) {
            result = ControlFlowGraph.multiplyRelativeFrequencies(result, cfg.localLoopFrequency((LoopBeginNode)current));
        }
        return result;
    }

    private static FixedNode findBegin(FixedNode node) {
        FixedNode current = node;
        while (true) {
            assert (current != null);
            Node predecessor = current.predecessor();
            if (current instanceof AbstractBeginNode) {
                if (predecessor == null) break;
                if (predecessor.successors().count() != 1) {
                    assert (predecessor instanceof ControlSplitNode) : "a FixedNode with multiple successors needs to be a ControlSplitNode: " + current + " / " + predecessor;
                    break;
                }
            } else if (predecessor == null) {
                current = null;
                break;
            }
            current = (FixedNode)predecessor;
        }
        return current;
    }
}

