/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements.nodes;

import java.util.EnumSet;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.lir.GenerateStub;
import org.graalvm.compiler.lir.GenerateStubs;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.NamedLocationIdentity;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.spi.Canonicalizable;
import org.graalvm.compiler.nodes.spi.CanonicalizerTool;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import org.graalvm.compiler.nodes.spi.Virtualizable;
import org.graalvm.compiler.nodes.spi.VirtualizerTool;
import org.graalvm.compiler.nodes.util.GraphUtil;
import org.graalvm.compiler.nodes.virtual.VirtualObjectNode;
import org.graalvm.compiler.replacements.nodes.ArrayEqualsForeignCalls;
import org.graalvm.compiler.replacements.nodes.PureFunctionStubIntrinsicNode;
import org.graalvm.word.Pointer;

@NodeInfo(cycles=NodeCycles.CYCLES_UNKNOWN, size=NodeSize.SIZE_16)
public class ArrayEqualsNode
extends PureFunctionStubIntrinsicNode
implements Canonicalizable,
Virtualizable {
    public static final NodeClass<ArrayEqualsNode> TYPE = NodeClass.create(ArrayEqualsNode.class);
    protected final JavaKind kind;
    @Node.Input
    protected ValueNode array1;
    @Node.Input
    protected ValueNode offset1;
    @Node.Input
    protected ValueNode array2;
    @Node.Input
    protected ValueNode offset2;
    @Node.Input
    protected ValueNode length;

    public ArrayEqualsNode(ValueNode array1, ValueNode offset1, ValueNode array2, ValueNode offset2, ValueNode length, @Node.ConstantNodeParameter JavaKind kind) {
        this(TYPE, array1, offset1, array2, offset2, length, kind, null);
    }

    public ArrayEqualsNode(ValueNode array1, ValueNode offset1, ValueNode array2, ValueNode offset2, ValueNode length, @Node.ConstantNodeParameter JavaKind kind, @Node.ConstantNodeParameter EnumSet<?> runtimeCheckedCPUFeatures) {
        this(TYPE, array1, offset1, array2, offset2, length, kind, runtimeCheckedCPUFeatures);
    }

    protected ArrayEqualsNode(NodeClass<? extends ArrayEqualsNode> c, ValueNode array1, ValueNode offset1, ValueNode array2, ValueNode offset2, ValueNode length, @Node.ConstantNodeParameter JavaKind kind, @Node.ConstantNodeParameter EnumSet<?> runtimeCheckedCPUFeatures) {
        super(c, StampFactory.forKind(JavaKind.Boolean), runtimeCheckedCPUFeatures, NamedLocationIdentity.getArrayLocation(kind));
        this.kind = kind;
        this.array1 = array1;
        this.offset1 = offset1;
        this.array2 = array2;
        this.offset2 = offset2;
        this.length = length;
    }

    private static boolean isNaNFloat(JavaConstant constant) {
        JavaKind kind = constant.getJavaKind();
        return kind == JavaKind.Float && Float.isNaN(constant.asFloat()) || kind == JavaKind.Double && Double.isNaN(constant.asDouble());
    }

    protected static boolean arrayEquals(ConstantReflectionProvider constantReflection, JavaConstant a, int startIndexA, JavaConstant b, int startIndexB, int len) {
        for (int i = 0; i < len; ++i) {
            JavaConstant bElem;
            JavaConstant aElem = constantReflection.readArrayElement(a, startIndexA + i);
            if (constantReflection.constantEquals((Constant)aElem, (Constant)(bElem = constantReflection.readArrayElement(b, startIndexB + i))).booleanValue() || ArrayEqualsNode.isNaNFloat(aElem) && ArrayEqualsNode.isNaNFloat(bElem)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Node canonical(CanonicalizerTool tool) {
        ValueNode a2;
        if (tool.allUsagesAvailable() && this.hasNoUsages()) {
            return null;
        }
        ValueNode a1 = GraphUtil.unproxify(this.array1);
        if (a1 == (a2 = GraphUtil.unproxify(this.array2))) {
            return ConstantNode.forBoolean(true);
        }
        if (a1.isConstant() && this.offset1.isConstant() && a2.isConstant() && this.offset2.isConstant() && this.length.isConstant()) {
            GraalError.guarantee(this.offset1.asJavaConstant().asLong() == (long)tool.getMetaAccess().getArrayBaseOffset(this.kind), "offset must be exactly the array base offset");
            GraalError.guarantee(this.offset2.asJavaConstant().asLong() == (long)tool.getMetaAccess().getArrayBaseOffset(this.kind), "offset must be exactly the array base offset");
            ConstantNode c1 = (ConstantNode)a1;
            ConstantNode c2 = (ConstantNode)a2;
            if (c1.getStableDimension() >= 1 && c2.getStableDimension() >= 1) {
                ConstantReflectionProvider constantReflection = tool.getConstantReflection();
                Integer c1Length = constantReflection.readArrayLength(c1.asJavaConstant());
                Integer c2Length = constantReflection.readArrayLength(c2.asJavaConstant());
                if (c1Length != null && c2Length != null && c1Length.equals(c2Length)) {
                    boolean ret = ArrayEqualsNode.arrayEquals(constantReflection, c1.asJavaConstant(), 0, c2.asJavaConstant(), 0, this.length.asJavaConstant().asInt());
                    return ConstantNode.forBoolean(ret);
                }
            }
        }
        return this;
    }

    @Override
    public void virtualize(VirtualizerTool tool) {
        ValueNode alias2;
        ValueNode alias1 = tool.getAlias(this.array1);
        if (alias1 == (alias2 = tool.getAlias(this.array2))) {
            tool.replaceWithValue(ConstantNode.forBoolean(true, this.graph()));
        } else if (alias1 instanceof VirtualObjectNode && alias2 instanceof VirtualObjectNode) {
            VirtualObjectNode virtual1 = (VirtualObjectNode)alias1;
            VirtualObjectNode virtual2 = (VirtualObjectNode)alias2;
            if (virtual1.entryCount() == virtual2.entryCount()) {
                int entryCount = virtual1.entryCount();
                boolean allEqual = true;
                for (int i = 0; i < entryCount; ++i) {
                    ValueNode entry2;
                    ValueNode entry1 = tool.getEntry(virtual1, i);
                    if (entry1 != (entry2 = tool.getEntry(virtual2, i))) {
                        if (entry1 instanceof ConstantNode && entry2 instanceof ConstantNode) {
                            if (entry1.getStackKind() == JavaKind.Float && entry2.getStackKind() == JavaKind.Float) {
                                float value1 = ((JavaConstant)entry1.asConstant()).asFloat();
                                float value2 = ((JavaConstant)entry2.asConstant()).asFloat();
                                if (Float.floatToIntBits(value1) != Float.floatToIntBits(value2)) {
                                    allEqual = false;
                                }
                            } else if (entry1.getStackKind() == JavaKind.Double && entry2.getStackKind() == JavaKind.Double) {
                                double value1 = ((JavaConstant)entry1.asConstant()).asDouble();
                                double value2 = ((JavaConstant)entry2.asConstant()).asDouble();
                                if (Double.doubleToLongBits(value1) != Double.doubleToLongBits(value2)) {
                                    allEqual = false;
                                }
                            } else {
                                allEqual = false;
                            }
                        } else {
                            allEqual = false;
                        }
                    }
                    if (!entry1.stamp(NodeView.DEFAULT).alwaysDistinct(entry2.stamp(NodeView.DEFAULT))) continue;
                    tool.replaceWithValue(ConstantNode.forBoolean(false, this.graph()));
                    return;
                }
                if (allEqual) {
                    tool.replaceWithValue(ConstantNode.forBoolean(true, this.graph()));
                }
            }
        }
    }

    @Node.NodeIntrinsic
    @GenerateStubs(value={@GenerateStub(name="longArraysEquals", parameters={"Long"}), @GenerateStub(name="floatArraysEquals", parameters={"Float"}), @GenerateStub(name="doubleArraysEquals", parameters={"Double"})})
    public static native boolean equals(Pointer var0, long var1, Pointer var3, long var4, int var6, @Node.ConstantNodeParameter JavaKind var7);

    @Node.NodeIntrinsic
    public static native boolean equals(Pointer var0, long var1, Pointer var3, long var4, int var6, @Node.ConstantNodeParameter JavaKind var7, @Node.ConstantNodeParameter EnumSet<?> var8);

    public ValueNode getArray1() {
        return this.array1;
    }

    public ValueNode getArray2() {
        return this.array2;
    }

    public ValueNode getLength() {
        return this.length;
    }

    public JavaKind getKind() {
        return this.kind;
    }

    @Override
    public ForeignCallDescriptor getForeignCallDescriptor() {
        return ArrayEqualsForeignCalls.getArrayEqualsStub(this);
    }

    @Override
    public ValueNode[] getForeignCallArguments() {
        return new ValueNode[]{this.array1, this.offset1, this.array2, this.offset2, this.length};
    }

    @Override
    public void emitIntrinsic(NodeLIRBuilderTool gen) {
        gen.setResult(this, (Value)gen.getLIRGeneratorTool().emitArrayEquals(this.kind, this.getRuntimeCheckedCPUFeatures(), gen.operand(this.array1), gen.operand(this.offset1), gen.operand(this.array2), gen.operand(this.offset2), gen.operand(this.length)));
    }
}

