/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.nativebridge;

import org.graalvm.nativebridge.BinaryInput;
import org.graalvm.nativebridge.BinaryMarshaller;
import org.graalvm.nativebridge.BinaryOutput;

final class DefaultStackTraceMarshaller
implements BinaryMarshaller<StackTraceElement[]> {
    private static final int STACK_TRACE_ELEMENT_SIZE_ESTIMATE = 100;
    static final DefaultStackTraceMarshaller INSTANCE = new DefaultStackTraceMarshaller();

    private DefaultStackTraceMarshaller() {
    }

    @Override
    public StackTraceElement[] read(BinaryInput in) {
        int len = in.readInt();
        StackTraceElement[] res = new StackTraceElement[len];
        for (int i = 0; i < len; ++i) {
            String className = in.readUTF();
            String methodName = in.readUTF();
            String fileName = in.readUTF();
            fileName = fileName.isEmpty() ? null : fileName;
            int lineNumber = in.readInt();
            res[i] = new StackTraceElement(className, methodName, fileName, lineNumber);
        }
        return res;
    }

    @Override
    public void write(BinaryOutput out, StackTraceElement[] stack) {
        out.writeInt(stack.length);
        for (StackTraceElement stackTraceElement : stack) {
            out.writeUTF(stackTraceElement.getClassName());
            out.writeUTF(stackTraceElement.getMethodName());
            String fileName = stackTraceElement.getFileName();
            out.writeUTF(fileName == null ? "" : fileName);
            out.writeInt(stackTraceElement.getLineNumber());
        }
    }

    @Override
    public int inferSize(StackTraceElement[] object) {
        return object.length * 100;
    }
}

