/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.code;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.Arrays;
import jdk.vm.ci.code.CodeCacheProvider;
import jdk.vm.ci.code.CodeUtil;
import jdk.vm.ci.code.DebugInfo;
import jdk.vm.ci.code.InstalledCode;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.RegisterConfig;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.code.site.Call;
import jdk.vm.ci.code.site.DataPatch;
import jdk.vm.ci.code.site.ExceptionHandler;
import jdk.vm.ci.code.site.Infopoint;
import jdk.vm.ci.services.Services;
import org.graalvm.compiler.code.CompilationResult;
import org.graalvm.compiler.code.DisassemblerProvider;
import org.graalvm.compiler.code.HexCodeFile;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.serviceprovider.ServiceProvider;

@ServiceProvider(value=DisassemblerProvider.class)
public class HexCodeFileDisassemblerProvider
implements DisassemblerProvider {
    @Override
    public String disassembleCompiledCode(OptionValues options, CodeCacheProvider codeCache, CompilationResult compResult) {
        assert (compResult != null);
        return HexCodeFileDisassemblerProvider.disassemble(codeCache, compResult, null);
    }

    @Override
    public String getName() {
        return "hcf";
    }

    @Override
    public String disassembleInstalledCode(CodeCacheProvider codeCache, CompilationResult compResult, InstalledCode installedCode) {
        assert (installedCode != null);
        return installedCode.isValid() ? HexCodeFileDisassemblerProvider.disassemble(codeCache, compResult, installedCode) : null;
    }

    private static String disassemble(CodeCacheProvider codeCache, CompilationResult compResult, InstalledCode installedCode) {
        byte[] code;
        TargetDescription target = codeCache.getTarget();
        RegisterConfig regConfig = codeCache.getRegisterConfig();
        byte[] byArray = code = installedCode == null ? Arrays.copyOf(compResult.getTargetCode(), compResult.getTargetCodeSize()) : installedCode.getCode();
        if (code == null) {
            return "";
        }
        long start = installedCode == null ? 0L : installedCode.getStart();
        HexCodeFile hcf = new HexCodeFile(code, start, target.arch.getName(), target.wordSize * 8);
        if (compResult != null) {
            HexCodeFile.addAnnotations(hcf, compResult.getCodeAnnotations());
            HexCodeFileDisassemblerProvider.addExceptionHandlersComment(compResult, hcf);
            Register fp = regConfig.getFrameRegister();
            CodeUtil.DefaultRefMapFormatter slotFormatter = new CodeUtil.DefaultRefMapFormatter(target.wordSize, fp, 0);
            for (Infopoint infopoint : compResult.getInfopoints()) {
                if (infopoint instanceof Call) {
                    Call call = (Call)infopoint;
                    if (call.debugInfo != null) {
                        hcf.addComment(call.pcOffset + call.size, CodeUtil.append((StringBuilder)new StringBuilder(100), (DebugInfo)call.debugInfo, (CodeUtil.RefMapFormatter)slotFormatter).toString());
                    }
                    HexCodeFileDisassemblerProvider.addOperandComment(hcf, call.pcOffset, "{" + codeCache.getTargetName(call) + "}");
                    continue;
                }
                if (infopoint.debugInfo != null) {
                    hcf.addComment(infopoint.pcOffset, CodeUtil.append((StringBuilder)new StringBuilder(100), (DebugInfo)infopoint.debugInfo, (CodeUtil.RefMapFormatter)slotFormatter).toString());
                }
                HexCodeFileDisassemblerProvider.addOperandComment(hcf, infopoint.pcOffset, "{infopoint: " + infopoint.reason + "}");
            }
            for (DataPatch site : compResult.getDataPatches()) {
                hcf.addOperandComment(site.pcOffset, "{" + site.reference.toString() + "}");
            }
            for (CompilationResult.CodeMark mark : compResult.getMarks()) {
                hcf.addComment(mark.pcOffset, mark.id.getName());
            }
        }
        String hcfEmbeddedString = hcf.toEmbeddedString();
        return HexCodeFileDisTool.tryDisassemble(hcfEmbeddedString);
    }

    private static void addExceptionHandlersComment(CompilationResult compResult, HexCodeFile hcf) {
        if (!compResult.getExceptionHandlers().isEmpty()) {
            String nl = HexCodeFile.NEW_LINE;
            StringBuilder buf = new StringBuilder("------ Exception Handlers ------").append(nl);
            for (ExceptionHandler e : compResult.getExceptionHandlers()) {
                buf.append("    ").append(e.pcOffset).append(" -> ").append(e.handlerPos).append(nl);
                hcf.addComment(e.pcOffset, "[exception -> " + e.handlerPos + "]");
                hcf.addComment(e.handlerPos, "[exception handler for " + e.pcOffset + "]");
            }
            hcf.addComment(0, buf.toString());
        }
    }

    private static void addOperandComment(HexCodeFile hcf, int pos, String comment) {
        hcf.addOperandComment(pos, comment);
    }

    static class HexCodeFileDisTool {
        static final MethodHandle processMethod;

        HexCodeFileDisTool() {
        }

        public static String tryDisassemble(String hcfEmbeddedString) {
            if (processMethod != null) {
                try {
                    return processMethod.invokeExact(hcfEmbeddedString);
                }
                catch (Throwable e) {
                    throw new InternalError(e);
                }
            }
            return hcfEmbeddedString;
        }

        static {
            MethodHandle toolMethod = null;
            try {
                Class<?> toolClass = Class.forName("com.oracle.max.hcfdis.HexCodeFileDis", true, ClassLoader.getSystemClassLoader());
                Method reflectMethod = toolClass.getDeclaredMethod("processEmbeddedString", String.class);
                reflectMethod.setAccessible(true);
                toolMethod = MethodHandles.lookup().unreflect(reflectMethod);
            }
            catch (Exception toolClass) {
                // empty catch block
            }
            if (toolMethod != null) {
                byte[] code = new byte[]{};
                String arch = (String)Services.getSavedProperties().get("os.arch");
                if (arch.equals("x86_64")) {
                    arch = "amd64";
                }
                int wordWidth = arch.endsWith("64") ? 64 : Integer.parseInt(Services.getSavedProperties().getOrDefault("sun.arch.data.model", "64"));
                String hcf = new HexCodeFile(code, 0L, arch.toLowerCase(), wordWidth).toEmbeddedString();
                try {
                    toolMethod.invokeExact(hcf);
                }
                catch (Throwable e) {
                    toolMethod = null;
                }
            }
            processMethod = toolMethod;
        }
    }
}

