/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.core.common;

import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.core.common.CompilerProfiler;
import org.graalvm.compiler.debug.CompilationListener;
import org.graalvm.compiler.debug.DebugContext;

public class CompilationListenerProfiler
implements CompilationListener {
    private final int compileId;
    private final CompilerProfiler profiler;

    public CompilationListenerProfiler(CompilerProfiler profiler, int compileId) {
        this.profiler = profiler;
        this.compileId = compileId;
    }

    @Override
    public void notifyInlining(ResolvedJavaMethod caller, ResolvedJavaMethod callee, boolean succeeded, CharSequence message, int bci) {
        this.profiler.notifyCompilerInlingEvent(this.compileId, caller, callee, succeeded, message.toString(), bci);
    }

    @Override
    public DebugContext.CompilerPhaseScope enterPhase(final CharSequence name, final int nesting) {
        final long start = this.profiler.getTicks();
        return new DebugContext.CompilerPhaseScope(){

            @Override
            public void close() {
                CompilationListenerProfiler.this.profiler.notifyCompilerPhaseEvent(CompilationListenerProfiler.this.compileId, start, name.toString(), nesting);
            }
        };
    }
}

