/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.core.common.alloc;

import java.util.BitSet;
import java.util.PriorityQueue;
import org.graalvm.compiler.core.common.alloc.BasicBlockOrderUtils;
import org.graalvm.compiler.core.common.cfg.AbstractBlockBase;

public final class LinearScanOrder {
    private static final int PENALTY_VERSUS_UNSCHEDULED = 10;

    public static <T extends AbstractBlockBase<T>> AbstractBlockBase<?>[] computeLinearScanOrder(int originalBlockCount, T startBlock) {
        BasicBlockOrderUtils.BlockList order = new BasicBlockOrderUtils.BlockList(originalBlockCount);
        BitSet visitedBlocks = new BitSet(originalBlockCount);
        PriorityQueue<T> worklist = BasicBlockOrderUtils.initializeWorklist(startBlock, visitedBlocks);
        LinearScanOrder.computeLinearScanOrder(order, worklist, visitedBlocks);
        BasicBlockOrderUtils.checkOrder(order, originalBlockCount);
        BasicBlockOrderUtils.checkStartBlock(order, startBlock);
        return order.toArray();
    }

    private static <T extends AbstractBlockBase<T>> void computeLinearScanOrder(BasicBlockOrderUtils.BlockList<T> order, PriorityQueue<T> worklist, BitSet visitedBlocks) {
        while (!worklist.isEmpty()) {
            AbstractBlockBase nextImportantPath = (AbstractBlockBase)worklist.poll();
            while ((nextImportantPath = LinearScanOrder.addPathToLinearScanOrder(nextImportantPath, order, worklist, visitedBlocks)) != null) {
            }
        }
    }

    private static <T extends AbstractBlockBase<T>> T addPathToLinearScanOrder(T block, BasicBlockOrderUtils.BlockList<T> order, PriorityQueue<T> worklist, BitSet visitedBlocks) {
        block.setLinearScanNumber(order.size());
        order.add(block);
        T mostLikelySuccessor = BasicBlockOrderUtils.findAndMarkMostLikelySuccessor(block, order, visitedBlocks);
        BasicBlockOrderUtils.enqueueSuccessors(block, worklist, visitedBlocks);
        if (mostLikelySuccessor != null) {
            if (!mostLikelySuccessor.isLoopHeader() && mostLikelySuccessor.getPredecessorCount() > 1) {
                double unscheduledSum = 0.0;
                for (AbstractBlockBase pred : mostLikelySuccessor.getPredecessors()) {
                    if (pred.getLinearScanNumber() != -1) continue;
                    unscheduledSum += pred.getRelativeFrequency();
                }
                if (unscheduledSum > block.getRelativeFrequency() / 10.0) {
                    visitedBlocks.clear(mostLikelySuccessor.getId());
                    return null;
                }
            }
            return mostLikelySuccessor;
        }
        return null;
    }
}

