/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.graph.iterators;

import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.iterators.NodePredicate;

public abstract class NodePredicates {
    private static final TautologyPredicate TAUTOLOGY = new TautologyPredicate();
    private static final ContradictionPredicate CONTRADICTION = new ContradictionPredicate();
    private static final IsNullPredicate IS_NULL = new IsNullPredicate();

    public static NodePredicate alwaysTrue() {
        return TAUTOLOGY;
    }

    public static NodePredicate alwaysFalse() {
        return CONTRADICTION;
    }

    public static NodePredicate isNull() {
        return IS_NULL;
    }

    public static NegativeTypePredicate isNotA(Class<? extends Node> clazz) {
        return new NegativeTypePredicate(clazz);
    }

    public static PositiveTypePredicate isA(Class<? extends Node> clazz) {
        return new PositiveTypePredicate(clazz);
    }

    public static final class NegativeTypePredicate
    implements NodePredicate {
        private final Class<?> type;
        private NegativeTypePredicate nor;

        NegativeTypePredicate(Class<?> type) {
            this.type = type;
        }

        public NegativeTypePredicate(PositiveTypePredicate a) {
            this.type = a.type;
            if (a.or != null) {
                this.nor = new NegativeTypePredicate(a.or);
            }
        }

        @Override
        public boolean apply(Node n) {
            return !this.type.isInstance(n) && (this.nor == null || this.nor.apply(n));
        }

        public NegativeTypePredicate nor(Class<? extends Node> clazz) {
            if (this.nor == null) {
                this.nor = new NegativeTypePredicate(clazz);
            } else {
                this.nor.nor(clazz);
            }
            return this;
        }

        public NodePredicate negate() {
            return new PositiveTypePredicate(this);
        }
    }

    public static final class PositiveTypePredicate
    implements NodePredicate {
        private final Class<?> type;
        private PositiveTypePredicate or;

        PositiveTypePredicate(Class<?> type) {
            this.type = type;
        }

        public PositiveTypePredicate(NegativeTypePredicate a) {
            this.type = a.type;
            if (a.nor != null) {
                this.or = new PositiveTypePredicate(a.nor);
            }
        }

        @Override
        public boolean apply(Node n) {
            return this.type.isInstance(n) || this.or != null && this.or.apply(n);
        }

        public PositiveTypePredicate or(Class<? extends Node> clazz) {
            if (this.or == null) {
                this.or = new PositiveTypePredicate(clazz);
            } else {
                this.or.or(clazz);
            }
            return this;
        }

        public NodePredicate negate() {
            return new NegativeTypePredicate(this);
        }
    }

    static final class IsNullPredicate
    implements NodePredicate {
        IsNullPredicate() {
        }

        @Override
        public boolean apply(Node n) {
            return n == null;
        }
    }

    static final class NotPredicate
    implements NodePredicate {
        private final NodePredicate a;

        NotPredicate(NodePredicate n) {
            this.a = n;
        }

        @Override
        public boolean apply(Node n) {
            return !this.a.apply(n);
        }

        public NodePredicate negate() {
            return this.a;
        }
    }

    static final class AndPredicate
    implements NodePredicate {
        private final NodePredicate a;
        private final NodePredicate b;

        AndPredicate(NodePredicate a, NodePredicate b) {
            this.a = a;
            this.b = b;
        }

        @Override
        public boolean apply(Node n) {
            return this.a.apply(n) && this.b.apply(n);
        }
    }

    static final class ContradictionPredicate
    implements NodePredicate {
        ContradictionPredicate() {
        }

        @Override
        public boolean apply(Node n) {
            return false;
        }

        @Override
        public NodePredicate and(NodePredicate np) {
            return this;
        }
    }

    static final class TautologyPredicate
    implements NodePredicate {
        TautologyPredicate() {
        }

        @Override
        public boolean apply(Node n) {
            return true;
        }

        @Override
        public NodePredicate and(NodePredicate np) {
            return np;
        }
    }
}

