/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import jdk.vm.ci.code.Architecture;
import jdk.vm.ci.code.stack.StackIntrospection;
import jdk.vm.ci.common.InitTimer;
import jdk.vm.ci.hotspot.HotSpotJVMCIRuntime;
import jdk.vm.ci.hotspot.HotSpotVMConfigStore;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.runtime.JVMCIBackend;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.Equivalence;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.core.CompilationWrapper;
import org.graalvm.compiler.core.Instrumentation;
import org.graalvm.compiler.core.common.CompilationIdentifier;
import org.graalvm.compiler.core.common.CompilationListenerProfiler;
import org.graalvm.compiler.core.common.CompilerProfiler;
import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.core.common.spi.ForeignCallsProvider;
import org.graalvm.compiler.core.target.Backend;
import org.graalvm.compiler.debug.Assertions;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.DebugHandlersFactory;
import org.graalvm.compiler.debug.DiagnosticsOutputDirectory;
import org.graalvm.compiler.debug.GlobalMetrics;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.debug.TTY;
import org.graalvm.compiler.hotspot.CompilationStatistics;
import org.graalvm.compiler.hotspot.CompilerConfigurationFactory;
import org.graalvm.compiler.hotspot.GraalHotSpotVMConfig;
import org.graalvm.compiler.hotspot.GraalHotSpotVMConfigAccess;
import org.graalvm.compiler.hotspot.HotSpotBackend;
import org.graalvm.compiler.hotspot.HotSpotBackendFactory;
import org.graalvm.compiler.hotspot.HotSpotCompilationIdentifier;
import org.graalvm.compiler.hotspot.HotSpotGraalRuntimeProvider;
import org.graalvm.compiler.hotspot.debug.BenchmarkCounters;
import org.graalvm.compiler.hotspot.meta.HotSpotProviders;
import org.graalvm.compiler.nodes.spi.StampProvider;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.tiers.CompilerConfiguration;
import org.graalvm.compiler.replacements.SnippetCounter;
import org.graalvm.compiler.runtime.RuntimeProvider;
import org.graalvm.compiler.serviceprovider.GraalServices;

public final class HotSpotGraalRuntime
implements HotSpotGraalRuntimeProvider {
    private final String runtimeName;
    private final String compilerConfigurationName;
    private final HotSpotBackend hostBackend;
    private final GlobalMetrics metricValues = new GlobalMetrics();
    private final List<SnippetCounter.Group> snippetCounterGroups;
    private final HotSpotGC garbageCollector;
    private final EconomicMap<Class<? extends Architecture>, HotSpotBackend> backends = EconomicMap.create((Equivalence)Equivalence.IDENTITY);
    private final GraalHotSpotVMConfig config;
    private final Instrumentation instrumentation;
    private final OptionValues options;
    private final DiagnosticsOutputDirectory outputDirectory;
    private final Map<CompilationWrapper.ExceptionAction, Integer> compilationProblemsPerAction;
    private final CompilerProfiler compilerProfiler;
    private long runtimeStartTime;
    private volatile boolean shutdown;
    private List<Runnable> shutdownHooks = new ArrayList<Runnable>();
    private final boolean bootstrapJVMCI;
    private boolean bootstrapFinished;

    private static boolean checkArrayIndexScaleInvariants(MetaAccessProvider metaAccess) {
        assert (metaAccess.getArrayIndexScale(JavaKind.Byte) == 1);
        assert (metaAccess.getArrayIndexScale(JavaKind.Boolean) == 1);
        assert (metaAccess.getArrayIndexScale(JavaKind.Char) == 2);
        assert (metaAccess.getArrayIndexScale(JavaKind.Short) == 2);
        assert (metaAccess.getArrayIndexScale(JavaKind.Int) == 4);
        assert (metaAccess.getArrayIndexScale(JavaKind.Long) == 8);
        assert (metaAccess.getArrayIndexScale(JavaKind.Float) == 4);
        assert (metaAccess.getArrayIndexScale(JavaKind.Double) == 8);
        return true;
    }

    public GlobalMetrics getMetricValues() {
        return this.metricValues;
    }

    HotSpotGraalRuntime(String nameQualifier, HotSpotJVMCIRuntime jvmciRuntime, CompilerConfigurationFactory compilerConfigurationFactory, OptionValues initialOptions) {
        this.runtimeName = this.getClass().getSimpleName() + ":" + nameQualifier;
        HotSpotVMConfigStore store = jvmciRuntime.getConfigStore();
        this.config = new GraalHotSpotVMConfig(store);
        this.options = GraalOptions.HotSpotPrintInlining.getValue(initialOptions) == false && this.config.printInlining ? new OptionValues(initialOptions, GraalOptions.HotSpotPrintInlining, true, new Object[0]) : initialOptions;
        this.garbageCollector = this.getSelectedGC();
        this.outputDirectory = new DiagnosticsOutputDirectory(this.options);
        this.compilationProblemsPerAction = new EnumMap<CompilationWrapper.ExceptionAction, Integer>(CompilationWrapper.ExceptionAction.class);
        this.snippetCounterGroups = GraalOptions.SnippetCounters.getValue(this.options) != false ? new ArrayList() : null;
        CompilerConfiguration compilerConfiguration = compilerConfigurationFactory.createCompilerConfiguration();
        this.compilerConfigurationName = compilerConfigurationFactory.getName();
        this.instrumentation = compilerConfigurationFactory.createInstrumentation(this.options);
        CompilerConfigurationFactory.BackendMap backendMap = compilerConfigurationFactory.createBackendMap();
        JVMCIBackend hostJvmciBackend = jvmciRuntime.getHostJVMCIBackend();
        Architecture hostArchitecture = hostJvmciBackend.getTarget().arch;
        try (InitTimer t = InitTimer.timer((String)"create backend:", (Object)hostArchitecture);){
            HotSpotBackendFactory factory = backendMap.getBackendFactory(hostArchitecture);
            if (factory == null) {
                throw new GraalError("No backend available for host architecture \"%s\"", hostArchitecture);
            }
            this.hostBackend = this.registerBackend(factory.createBackend(this, compilerConfiguration, jvmciRuntime, null));
        }
        for (JVMCIBackend jvmciBackend : jvmciRuntime.getJVMCIBackends().values()) {
            if (jvmciBackend == hostJvmciBackend) continue;
            Architecture gpuArchitecture = jvmciBackend.getTarget().arch;
            HotSpotBackendFactory factory = backendMap.getBackendFactory(gpuArchitecture);
            if (factory == null) {
                throw new GraalError("No backend available for specified GPU architecture \"%s\"", gpuArchitecture);
            }
            InitTimer t = InitTimer.timer((String)"create backend:", (Object)gpuArchitecture);
            try {
                this.registerBackend(factory.createBackend(this, compilerConfiguration, null, this.hostBackend));
            }
            finally {
                if (t == null) continue;
                t.close();
            }
        }
        try (InitTimer st = InitTimer.timer((String)this.hostBackend.getTarget().arch.getName(), (Object)".completeInitialization");){
            this.hostBackend.completeInitialization(jvmciRuntime, this.options);
        }
        for (HotSpotBackend backend : this.backends.getValues()) {
            if (backend == this.hostBackend) continue;
            InitTimer st = InitTimer.timer((String)backend.getTarget().arch.getName(), (Object)".completeInitialization");
            try {
                backend.completeInitialization(jvmciRuntime, this.options);
            }
            finally {
                if (st == null) continue;
                st.close();
            }
        }
        BenchmarkCounters.initialize(jvmciRuntime, this.options);
        assert (HotSpotGraalRuntime.checkArrayIndexScaleInvariants(hostJvmciBackend.getMetaAccess()));
        this.runtimeStartTime = System.nanoTime();
        this.bootstrapJVMCI = this.config.getFlag("BootstrapJVMCI", Boolean.class);
        this.compilerProfiler = GraalServices.loadSingle(CompilerProfiler.class, false);
        HotSpotGraalRuntime.startupLibGraal(this);
    }

    private HotSpotGC getSelectedGC() throws GraalError {
        HotSpotGC selected = null;
        for (HotSpotGC gc : HotSpotGC.values()) {
            if (!gc.isSelected(this.config)) continue;
            if (!gc.supported) {
                throw new GraalError(gc.name() + " garbage collector is not supported by Graal");
            }
            selected = gc;
            if (!Assertions.assertionsEnabled()) break;
        }
        if (selected == null) {
            selected = HotSpotGC.Serial;
        }
        return selected;
    }

    private HotSpotBackend registerBackend(HotSpotBackend backend) {
        Class<?> arch = backend.getTarget().arch.getClass();
        HotSpotBackend oldValue = (HotSpotBackend)this.backends.put(arch, (Object)backend);
        assert (oldValue == null) : "cannot overwrite existing backend for architecture " + arch.getSimpleName();
        return backend;
    }

    @Override
    public HotSpotProviders getHostProviders() {
        return this.getHostBackend().getProviders();
    }

    @Override
    public GraalHotSpotVMConfig getVMConfig() {
        return this.config;
    }

    @Override
    public DebugContext openDebugContext(OptionValues compilationOptions, CompilationIdentifier compilationId, Object compilable, Iterable<DebugHandlersFactory> factories, PrintStream logStream) {
        DebugContext.Description description = new DebugContext.Description(compilable, compilationId.toString(CompilationIdentifier.Verbosity.ID));
        DebugContext.Builder builder = new DebugContext.Builder(compilationOptions, factories).globalMetrics(this.metricValues).description(description).logStream(logStream);
        if (this.compilerProfiler != null) {
            int compileId = ((HotSpotCompilationIdentifier)compilationId).getRequest().getId();
            builder.compilationListener(new CompilationListenerProfiler(this.compilerProfiler, compileId));
        }
        return builder.build();
    }

    @Override
    public OptionValues getOptions() {
        return this.options;
    }

    @Override
    public SnippetCounter.Group createSnippetCounterGroup(String groupName) {
        if (this.snippetCounterGroups != null) {
            SnippetCounter.Group group = new SnippetCounter.Group(groupName);
            this.snippetCounterGroups.add(group);
            return group;
        }
        return null;
    }

    @Override
    public String getName() {
        return this.runtimeName;
    }

    @Override
    public <T> T getCapability(Class<T> clazz) {
        if (clazz == RuntimeProvider.class) {
            return (T)this;
        }
        if (clazz == OptionValues.class) {
            return (T)this.options;
        }
        if (clazz == StackIntrospection.class) {
            return (T)this;
        }
        if (clazz == SnippetReflectionProvider.class) {
            return (T)this.getHostProviders().getSnippetReflection();
        }
        if (clazz == GraalHotSpotVMConfig.class) {
            return (T)this.getVMConfig();
        }
        if (clazz == StampProvider.class) {
            return (T)this.getHostProviders().getStampProvider();
        }
        if (ForeignCallsProvider.class.isAssignableFrom(clazz)) {
            return (T)this.getHostProviders().getForeignCalls();
        }
        return null;
    }

    @Override
    public HotSpotGC getGarbageCollector() {
        return this.garbageCollector;
    }

    @Override
    public HotSpotBackend getHostBackend() {
        return this.hostBackend;
    }

    @Override
    public <T extends Architecture> Backend getBackend(Class<T> arch) {
        assert (arch != Architecture.class);
        return (Backend)this.backends.get(arch);
    }

    @Override
    public String getCompilerConfigurationName() {
        return this.compilerConfigurationName;
    }

    @Override
    public Instrumentation getInstrumentation() {
        return this.instrumentation;
    }

    void phaseTransition(String phase) {
        if (CompilationStatistics.Options.UseCompilationStatistics.getValue(this.options).booleanValue()) {
            CompilationStatistics.clear(phase);
        }
    }

    public synchronized void addShutdownHook(Runnable hook) {
        if (!this.shutdown) {
            this.shutdownHooks.add(hook);
        }
    }

    synchronized void shutdown() {
        this.shutdown = true;
        for (Runnable r : this.shutdownHooks) {
            try {
                r.run();
            }
            catch (Throwable e) {
                e.printStackTrace(TTY.out);
            }
        }
        this.metricValues.print(this.options);
        this.phaseTransition("final");
        if (this.snippetCounterGroups != null) {
            for (SnippetCounter.Group group : this.snippetCounterGroups) {
                TTY.out().out().println(group);
            }
        }
        BenchmarkCounters.shutdown(HotSpotJVMCIRuntime.runtime(), this.options, this.runtimeStartTime);
        this.outputDirectory.close();
        HotSpotGraalRuntime.shutdownLibGraal(this);
    }

    private static void startupLibGraal(HotSpotGraalRuntime runtime) {
    }

    private static void shutdownLibGraal(HotSpotGraalRuntime runtime) {
    }

    void clearMetrics() {
        this.metricValues.clear();
    }

    public void notifyBootstrapFinished() {
        this.bootstrapFinished = true;
    }

    @Override
    public boolean isBootstrapping() {
        return this.bootstrapJVMCI && !this.bootstrapFinished;
    }

    @Override
    public boolean isShutdown() {
        return this.shutdown;
    }

    @Override
    public DiagnosticsOutputDirectory getOutputDirectory() {
        return this.outputDirectory;
    }

    @Override
    public Map<CompilationWrapper.ExceptionAction, Integer> getCompilationProblemsPerAction() {
        return this.compilationProblemsPerAction;
    }

    public static enum HotSpotGC {
        Serial(true, GraalHotSpotVMConfigAccess.JDK >= 11, "UseSerialGC", true),
        Parallel(true, GraalHotSpotVMConfigAccess.JDK >= 11, "UseParallelGC", true, "UseParallelOldGC", GraalHotSpotVMConfigAccess.JDK < 15, "UseParNewGC", GraalHotSpotVMConfigAccess.JDK < 10),
        CMS(true, GraalHotSpotVMConfigAccess.JDK >= 11 && GraalHotSpotVMConfigAccess.JDK <= 14, "UseConcMarkSweepGC", GraalHotSpotVMConfigAccess.JDK < 14),
        G1(true, GraalHotSpotVMConfigAccess.JDK >= 11, "UseG1GC", true),
        Epsilon(false, GraalHotSpotVMConfigAccess.JDK >= 11, "UseEpsilonGC", GraalHotSpotVMConfigAccess.JDK >= 11),
        Z(false, GraalHotSpotVMConfigAccess.JDK >= 11, "UseZGC", GraalHotSpotVMConfigAccess.JDK >= 11),
        Shenandoah(false, GraalHotSpotVMConfigAccess.JDK >= 12, "UseShenandoahGC", GraalHotSpotVMConfigAccess.JDK >= 12);

        final boolean supported;
        final boolean expectNamePresent;
        private final String[] flags;
        final boolean[] expectFlagsPresent;

        private HotSpotGC(boolean supported, boolean expectNamePresent, String flag1, boolean expectFlagPresent1, String flag2, boolean expectFlagPresent2, String flag3, boolean expectFlagPresent3) {
            this.supported = supported;
            this.expectNamePresent = expectNamePresent;
            this.expectFlagsPresent = new boolean[]{expectFlagPresent1, expectFlagPresent2, expectFlagPresent3};
            this.flags = new String[]{flag1, flag2, flag3};
        }

        private HotSpotGC(boolean supported, boolean expectNamePresent, String flag, boolean expectFlagPresent) {
            this.supported = supported;
            this.expectNamePresent = expectNamePresent;
            this.expectFlagsPresent = new boolean[]{expectFlagPresent};
            this.flags = new String[]{flag};
        }

        public boolean isSelected(GraalHotSpotVMConfig config) {
            boolean selected = false;
            for (int i = 0; i < this.flags.length; ++i) {
                boolean notPresent = false;
                if (!config.getFlag(this.flags[i], Boolean.class, false, this.expectFlagsPresent[i]).booleanValue()) continue;
                selected = true;
                if (!Assertions.assertionsEnabled()) break;
            }
            return selected;
        }

        static HotSpotGC forName(int name, GraalHotSpotVMConfig config) {
            for (HotSpotGC gc : HotSpotGC.values()) {
                if (config.getConstant("CollectedHeap::" + gc.name(), Integer.class, -1, gc.expectNamePresent) != name) continue;
                return gc;
            }
            return null;
        }
    }
}

