/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.replacements;

import jdk.vm.ci.meta.Constant;
import org.graalvm.compiler.api.replacements.Snippet;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.hotspot.meta.HotSpotProviders;
import org.graalvm.compiler.hotspot.replacements.Log;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.spi.LoweringTool;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.replacements.SnippetTemplate;
import org.graalvm.compiler.replacements.Snippets;
import org.graalvm.compiler.replacements.nodes.CStringConstant;
import org.graalvm.compiler.replacements.nodes.LogNode;
import org.graalvm.compiler.word.Word;
import org.graalvm.word.LocationIdentity;

public class LogSnippets
implements Snippets {
    @Snippet
    public static void print(@Snippet.ConstantParameter Word message) {
        Log.print(message);
    }

    @Snippet
    public static void printf1(@Snippet.ConstantParameter Word message, long l1) {
        Log.printf(message, l1);
    }

    @Snippet
    public static void printf2(@Snippet.ConstantParameter Word message, long l1, long l2) {
        Log.printf(message, l1, l2);
    }

    @Snippet
    public static void printf3(@Snippet.ConstantParameter Word message, long l1, long l2, long l3) {
        Log.printf(message, l1, l2, l3);
    }

    public static class Templates
    extends SnippetTemplate.AbstractTemplates {
        private final SnippetTemplate.SnippetInfo print = this.snippet(LogSnippets.class, "print", new LocationIdentity[0]);
        private final SnippetTemplate.SnippetInfo printf1 = this.snippet(LogSnippets.class, "printf1", new LocationIdentity[0]);
        private final SnippetTemplate.SnippetInfo printf2 = this.snippet(LogSnippets.class, "printf2", new LocationIdentity[0]);
        private final SnippetTemplate.SnippetInfo printf3 = this.snippet(LogSnippets.class, "printf3", new LocationIdentity[0]);

        public Templates(OptionValues options, HotSpotProviders providers) {
            super(options, providers);
        }

        public void lower(LogNode logNode, LoweringTool tool) {
            StructuredGraph graph = logNode.graph();
            SnippetTemplate.SnippetInfo info = this.print;
            if (logNode.getL3() != null) {
                info = this.printf3;
            } else if (logNode.getL2() != null) {
                info = this.printf2;
            } else if (logNode.getL1() != null) {
                info = this.printf1;
            }
            SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(info, graph.getGuardsStage(), tool.getLoweringStage());
            args.addConst("message", graph.unique(new ConstantNode((Constant)new CStringConstant(logNode.message()), StampFactory.pointer())));
            if (logNode.getL1() != null) {
                args.add("l1", logNode.getL1());
            }
            if (logNode.getL2() != null) {
                args.add("l2", logNode.getL2());
            }
            if (logNode.getL3() != null) {
                args.add("l3", logNode.getL3());
            }
            this.template(logNode, args).instantiate(this.providers.getMetaAccess(), logNode, SnippetTemplate.DEFAULT_REPLACER, args);
        }
    }
}

