/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir;

import java.util.Arrays;
import java.util.BitSet;
import java.util.EnumSet;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.core.common.cfg.AbstractBlockBase;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.debug.TTY;
import org.graalvm.compiler.lir.LIR;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRValueUtil;
import org.graalvm.compiler.lir.StandardOp;
import org.graalvm.compiler.lir.ValueConsumer;
import org.graalvm.compiler.lir.framemap.FrameMap;
import org.graalvm.compiler.lir.ssa.SSAUtil;

public final class LIRVerifier {
    private final LIR lir;
    private final FrameMap frameMap;
    private final boolean beforeRegisterAllocation;
    private final BitSet[] blockLiveOut;
    private final Object[] variableDefinitions;
    private BitSet curVariablesLive;
    private Value[] curRegistersLive;
    private AbstractBlockBase<?> curBlock;
    private Object curInstruction;
    private BitSet curRegistersDefined;

    private BitSet liveOutFor(AbstractBlockBase<?> block) {
        return this.blockLiveOut[block.getId()];
    }

    private void setLiveOutFor(AbstractBlockBase<?> block, BitSet liveOut) {
        this.blockLiveOut[block.getId()] = liveOut;
    }

    private int maxRegisterNum() {
        return this.frameMap.getTarget().arch.getRegisters().size();
    }

    private boolean isAllocatableRegister(Value value) {
        return ValueUtil.isRegister((Value)value) && this.frameMap.getRegisterConfig().getAttributesMap()[ValueUtil.asRegister((Value)value).number].isAllocatable();
    }

    public static boolean verify(LIRInstruction op) {
        op.visitEachInput(LIRVerifier::allowed);
        op.visitEachAlive(LIRVerifier::allowed);
        op.visitEachState(LIRVerifier::allowed);
        op.visitEachTemp(LIRVerifier::allowed);
        op.visitEachOutput(LIRVerifier::allowed);
        op.verify();
        return true;
    }

    public static boolean verify(boolean beforeRegisterAllocation, LIR lir, FrameMap frameMap) {
        LIRVerifier verifier = new LIRVerifier(beforeRegisterAllocation, lir, frameMap);
        verifier.verify();
        return true;
    }

    private LIRVerifier(boolean beforeRegisterAllocation, LIR lir, FrameMap frameMap) {
        this.beforeRegisterAllocation = beforeRegisterAllocation;
        this.lir = lir;
        this.frameMap = frameMap;
        this.blockLiveOut = new BitSet[lir.linearScanOrder().length];
        this.variableDefinitions = new Object[lir.numVariables()];
    }

    private void verify() {
        ValueConsumer useConsumer = new ValueConsumer(){

            @Override
            public void visitValue(Value value, LIRInstruction.OperandMode mode, EnumSet<LIRInstruction.OperandFlag> flags) {
                LIRVerifier.this.use(value, mode, flags);
            }
        };
        ValueConsumer defConsumer = new ValueConsumer(){

            @Override
            public void visitValue(Value value, LIRInstruction.OperandMode mode, EnumSet<LIRInstruction.OperandFlag> flags) {
                LIRVerifier.this.def(value, mode, flags);
            }
        };
        int maxRegisterNum = this.maxRegisterNum();
        this.curRegistersDefined = new BitSet();
        for (AbstractBlockBase<?> block : this.lir.linearScanOrder()) {
            this.curBlock = block;
            this.curVariablesLive = new BitSet();
            this.curRegistersLive = new Value[maxRegisterNum];
            if (block.getDominator() != null) {
                this.curVariablesLive.or(this.liveOutFor((AbstractBlockBase<?>)block.getDominator()));
            }
            assert (this.lir.getLIRforBlock(block).get(0) instanceof StandardOp.LabelOp) : "block must start with label";
            if (block.getSuccessorCount() > 0) {
                LIRInstruction last = this.lir.getLIRforBlock(block).get(this.lir.getLIRforBlock(block).size() - 1);
                assert (last instanceof StandardOp.JumpOp) : "block with successor must end with unconditional jump";
            }
            if (block.getPredecessorCount() > 1) {
                SSAUtil.verifyPhi(this.lir, block);
            }
            for (LIRInstruction op : this.lir.getLIRforBlock(block)) {
                this.curInstruction = op;
                op.visitEachInput(useConsumer);
                if (op.destroysCallerSavedRegisters()) {
                    for (Register register : this.frameMap.getRegisterConfig().getCallerSaveRegisters()) {
                        this.curRegistersLive[register.number] = null;
                    }
                }
                this.curRegistersDefined.clear();
                op.visitEachAlive(useConsumer);
                op.visitEachState(useConsumer);
                op.visitEachTemp(defConsumer);
                op.visitEachOutput(defConsumer);
                this.curInstruction = null;
            }
            this.setLiveOutFor(block, this.curVariablesLive);
        }
    }

    private void use(Value value, LIRInstruction.OperandMode mode, EnumSet<LIRInstruction.OperandFlag> flags) {
        LIRVerifier.allowed(this.curInstruction, value, mode, flags);
        if (LIRValueUtil.isVariable(value)) {
            assert (this.beforeRegisterAllocation);
            int variableIdx = LIRValueUtil.asVariable((Value)value).index;
            if (!this.curVariablesLive.get(variableIdx)) {
                TTY.println("block %s  instruction %s", this.curBlock, this.curInstruction);
                TTY.println("live variables: %s", this.curVariablesLive);
                if (this.variableDefinitions[variableIdx] != null) {
                    TTY.println("definition of %s: %s", value, this.variableDefinitions[variableIdx]);
                }
                TTY.println("ERROR: Use of variable %s that is not defined in dominator", value);
                throw GraalError.shouldNotReachHere();
            }
        } else if (this.isAllocatableRegister(value)) {
            int regNum = ValueUtil.asRegister((Value)value).number;
            if (mode == LIRInstruction.OperandMode.ALIVE) {
                this.curRegistersDefined.set(regNum);
            }
            if (this.beforeRegisterAllocation && !this.curRegistersLive[regNum].equals((Object)value)) {
                TTY.println("block %s  instruction %s", this.curBlock, this.curInstruction);
                TTY.println("live registers: %s", Arrays.toString(this.curRegistersLive));
                TTY.println("ERROR: Use of fixed register %s that is not defined in this block", value);
                throw GraalError.shouldNotReachHere();
            }
        }
    }

    private void def(Value value, LIRInstruction.OperandMode mode, EnumSet<LIRInstruction.OperandFlag> flags) {
        LIRVerifier.allowed(this.curInstruction, value, mode, flags);
        if (LIRValueUtil.isVariable(value)) {
            assert (this.beforeRegisterAllocation);
            int variableIdx = LIRValueUtil.asVariable((Value)value).index;
            if (this.variableDefinitions[variableIdx] != null) {
                TTY.println("block %s  instruction %s", this.curBlock, this.curInstruction);
                TTY.println("live variables: %s", this.curVariablesLive);
                TTY.println("definition of %s: %s", value, this.variableDefinitions[variableIdx]);
                TTY.println("ERROR: Variable %s defined multiple times", value);
                throw GraalError.shouldNotReachHere();
            }
            assert (this.curInstruction != null);
            this.variableDefinitions[variableIdx] = this.curInstruction;
            assert (!this.curVariablesLive.get(variableIdx));
            if (mode == LIRInstruction.OperandMode.DEF) {
                this.curVariablesLive.set(variableIdx);
            }
        } else if (this.isAllocatableRegister(value)) {
            int regNum = ValueUtil.asRegister((Value)value).number;
            if (this.curRegistersDefined.get(regNum)) {
                TTY.println("block %s  instruction %s", this.curBlock, this.curInstruction);
                TTY.println("ERROR: Same register defined twice in the same instruction: %s", value);
                throw GraalError.shouldNotReachHere();
            }
            this.curRegistersDefined.set(regNum);
            if (this.beforeRegisterAllocation) {
                this.curRegistersLive[regNum] = mode == LIRInstruction.OperandMode.DEF ? value : null;
            }
        }
    }

    private static void allowed(Object op, Value val, LIRInstruction.OperandMode mode, EnumSet<LIRInstruction.OperandFlag> flags) {
        Value value = LIRValueUtil.stripCast(val);
        if (LIRValueUtil.isVariable(value) && flags.contains((Object)LIRInstruction.OperandFlag.REG) || ValueUtil.isRegister((Value)value) && flags.contains((Object)LIRInstruction.OperandFlag.REG) || LIRValueUtil.isStackSlotValue(value) && flags.contains((Object)LIRInstruction.OperandFlag.STACK) || LIRValueUtil.isConstantValue(value) && flags.contains((Object)LIRInstruction.OperandFlag.CONST) && mode != LIRInstruction.OperandMode.DEF || ValueUtil.isIllegal((Value)value) && flags.contains((Object)LIRInstruction.OperandFlag.ILLEGAL)) {
            return;
        }
        throw new GraalError("Invalid LIR%n  Instruction: %s%n  Mode: %s%n  Flags: %s%n  Unexpected value: %s %s", new Object[]{op, mode, flags, value.getClass().getSimpleName(), value});
    }
}

