/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.amd64;

import jdk.vm.ci.amd64.AMD64Kind;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.PlatformKind;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.asm.Label;
import org.graalvm.compiler.asm.amd64.AMD64Address;
import org.graalvm.compiler.asm.amd64.AMD64Assembler;
import org.graalvm.compiler.asm.amd64.AMD64MacroAssembler;
import org.graalvm.compiler.asm.amd64.AVXKind;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.StubPort;
import org.graalvm.compiler.lir.amd64.AMD64HotSpotHelper;
import org.graalvm.compiler.lir.amd64.AMD64LIRInstruction;
import org.graalvm.compiler.lir.asm.ArrayDataPointerConstant;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;
import org.graalvm.compiler.lir.gen.LIRGeneratorTool;

@StubPort(path="src/hotspot/cpu/x86/stubGenerator_x86_64.cpp", lineStart=3575, lineEnd=3666, commit="0c6094e79602fe85a88e3131710bb39813364ad2", sha1="c9f2bd7811e98336d14037382a8324968e56fc09")
public final class AMD64AESEncryptOp
extends AMD64LIRInstruction {
    public static final LIRInstructionClass<AMD64AESEncryptOp> TYPE = LIRInstructionClass.create(AMD64AESEncryptOp.class);
    public static final int AES_BLOCK_SIZE = 16;
    private final int lengthOffset;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
    private Value fromValue;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
    private Value toValue;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
    private Value keyValue;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    private Value keyLenValue;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    private Value xmmResultValue;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    private Value xmmKeyShufMaskValue;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    private Value xmmTempValue1;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    private Value xmmTempValue2;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    private Value xmmTempValue3;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    private Value xmmTempValue4;
    private ArrayDataPointerConstant keyShuffleMask = AMD64HotSpotHelper.pointerConstant(16, new int[]{66051, 67438087, 134810123, 202182159});

    public AMD64AESEncryptOp(LIRGeneratorTool tool, AllocatableValue fromValue, AllocatableValue toValue, AllocatableValue keyValue, int lengthOffset) {
        super((LIRInstructionClass<? extends AMD64LIRInstruction>)TYPE);
        this.fromValue = fromValue;
        this.toValue = toValue;
        this.keyValue = keyValue;
        this.lengthOffset = lengthOffset;
        this.keyLenValue = tool.newVariable(LIRKind.value((PlatformKind)AMD64Kind.DWORD));
        LIRKind lirKind = LIRKind.value((PlatformKind)AMD64Kind.V128_BYTE);
        this.xmmResultValue = tool.newVariable(lirKind);
        this.xmmKeyShufMaskValue = tool.newVariable(lirKind);
        this.xmmTempValue1 = tool.newVariable(lirKind);
        this.xmmTempValue2 = tool.newVariable(lirKind);
        this.xmmTempValue3 = tool.newVariable(lirKind);
        this.xmmTempValue4 = tool.newVariable(lirKind);
    }

    public static void loadKey(AMD64MacroAssembler masm, Register xmmDst, Register key, int offset, Register xmmShufMask) {
        masm.movdqu(xmmDst, new AMD64Address(key, offset));
        AMD64Assembler.VexRVMOp.VPSHUFB.emit((AMD64Assembler)masm, AVXKind.AVXSize.XMM, xmmDst, xmmDst, xmmShufMask);
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
        assert (this.fromValue.getPlatformKind().equals(AMD64Kind.QWORD)) : this.fromValue;
        assert (this.toValue.getPlatformKind().equals(AMD64Kind.QWORD)) : this.toValue;
        assert (this.keyValue.getPlatformKind().equals(AMD64Kind.QWORD)) : this.keyValue;
        Label labelDoLast = new Label();
        Register from = ValueUtil.asRegister((Value)this.fromValue);
        Register to = ValueUtil.asRegister((Value)this.toValue);
        Register key = ValueUtil.asRegister((Value)this.keyValue);
        Register keylen = ValueUtil.asRegister((Value)this.keyLenValue);
        Register xmmResult = ValueUtil.asRegister((Value)this.xmmResultValue);
        Register xmmKeyShufMask = ValueUtil.asRegister((Value)this.xmmKeyShufMaskValue);
        Register xmmTemp1 = ValueUtil.asRegister((Value)this.xmmTempValue1);
        Register xmmTemp2 = ValueUtil.asRegister((Value)this.xmmTempValue2);
        Register xmmTemp3 = ValueUtil.asRegister((Value)this.xmmTempValue3);
        Register xmmTemp4 = ValueUtil.asRegister((Value)this.xmmTempValue4);
        masm.movl(keylen, new AMD64Address(key, this.lengthOffset));
        masm.movdqu(xmmKeyShufMask, AMD64HotSpotHelper.recordExternalAddress(crb, this.keyShuffleMask));
        masm.movdqu(xmmResult, new AMD64Address(from));
        AMD64AESEncryptOp.loadKey(masm, xmmTemp1, key, 0, xmmKeyShufMask);
        masm.pxor(xmmResult, xmmTemp1);
        AMD64AESEncryptOp.loadKey(masm, xmmTemp1, key, 16, xmmKeyShufMask);
        AMD64AESEncryptOp.loadKey(masm, xmmTemp2, key, 32, xmmKeyShufMask);
        AMD64AESEncryptOp.loadKey(masm, xmmTemp3, key, 48, xmmKeyShufMask);
        AMD64AESEncryptOp.loadKey(masm, xmmTemp4, key, 64, xmmKeyShufMask);
        masm.aesenc(xmmResult, xmmTemp1);
        masm.aesenc(xmmResult, xmmTemp2);
        masm.aesenc(xmmResult, xmmTemp3);
        masm.aesenc(xmmResult, xmmTemp4);
        AMD64AESEncryptOp.loadKey(masm, xmmTemp1, key, 80, xmmKeyShufMask);
        AMD64AESEncryptOp.loadKey(masm, xmmTemp2, key, 96, xmmKeyShufMask);
        AMD64AESEncryptOp.loadKey(masm, xmmTemp3, key, 112, xmmKeyShufMask);
        AMD64AESEncryptOp.loadKey(masm, xmmTemp4, key, 128, xmmKeyShufMask);
        masm.aesenc(xmmResult, xmmTemp1);
        masm.aesenc(xmmResult, xmmTemp2);
        masm.aesenc(xmmResult, xmmTemp3);
        masm.aesenc(xmmResult, xmmTemp4);
        AMD64AESEncryptOp.loadKey(masm, xmmTemp1, key, 144, xmmKeyShufMask);
        AMD64AESEncryptOp.loadKey(masm, xmmTemp2, key, 160, xmmKeyShufMask);
        masm.cmplAndJcc(keylen, 44, AMD64Assembler.ConditionFlag.Equal, labelDoLast, true);
        masm.aesenc(xmmResult, xmmTemp1);
        masm.aesenc(xmmResult, xmmTemp2);
        AMD64AESEncryptOp.loadKey(masm, xmmTemp1, key, 176, xmmKeyShufMask);
        AMD64AESEncryptOp.loadKey(masm, xmmTemp2, key, 192, xmmKeyShufMask);
        masm.cmplAndJcc(keylen, 52, AMD64Assembler.ConditionFlag.Equal, labelDoLast, true);
        masm.aesenc(xmmResult, xmmTemp1);
        masm.aesenc(xmmResult, xmmTemp2);
        AMD64AESEncryptOp.loadKey(masm, xmmTemp1, key, 208, xmmKeyShufMask);
        AMD64AESEncryptOp.loadKey(masm, xmmTemp2, key, 224, xmmKeyShufMask);
        masm.bind(labelDoLast);
        masm.aesenc(xmmResult, xmmTemp1);
        masm.aesenclast(xmmResult, xmmTemp2);
        masm.movdqu(new AMD64Address(to), xmmResult);
    }
}

