/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.hashing;

import java.util.Arrays;
import java.util.Optional;

public final class IntHasher {
    public final int cardinality;
    public final short factor;
    public final byte shift;
    private static final Short[] factors = new Short[1000];
    private static final double log2;

    private IntHasher(int cardinality, short factor, byte shift) {
        this.cardinality = cardinality;
        this.factor = factor;
        this.shift = shift;
    }

    private static boolean canSimplify(short factor) {
        return IntHasher.isPowerOf2(factor - 1) || IntHasher.isPowerOf2(factor + 1) || IntHasher.isPowerOf2(-factor);
    }

    private static boolean isPowerOf2(int n) {
        return (n & n - 1) == 0;
    }

    public static Optional<IntHasher> forKeys(int[] keys) {
        int length = keys.length;
        int cardinality = 1 << (int)(Math.log(keys.length - 1) / log2) + 1;
        int maskBits = (int)(Math.log(cardinality) / log2 + 1.0);
        int[] scratch = new int[length];
        boolean[] seen = new boolean[cardinality];
        Short[] shortArray = factors;
        int n = shortArray.length;
        for (int i = 0; i < n; ++i) {
            short factor = shortArray[i];
            for (int i2 = 0; i2 < length; ++i2) {
                scratch[i2] = keys[i2] * factor;
            }
            block2: for (byte shift = 0; shift < 32 - maskBits; shift = (byte)(shift + 1)) {
                Arrays.fill(seen, false);
                for (int h = 0; h < length; ++h) {
                    int idx = scratch[h] >> shift & cardinality - 1;
                    if (seen[idx]) continue block2;
                    seen[idx] = true;
                }
                return Optional.of(new IntHasher(cardinality, factor, shift));
            }
        }
        return Optional.empty();
    }

    public int hash(int value) {
        return value * this.factor >> this.shift & this.cardinality - 1;
    }

    public String toString() {
        return "IntHasher [cardinality=" + this.cardinality + ", factor=" + this.factor + ", shift=" + this.shift + "]";
    }

    static {
        int pos = 0;
        short i = 1;
        while (pos < factors.length) {
            boolean factor = true;
            for (short j = 2; j < i; ++j) {
                if (i % j != 0) continue;
                factor = false;
                break;
            }
            if (factor) {
                IntHasher.factors[pos] = i;
                ++pos;
            }
            i = (short)(i + 1);
        }
        Arrays.sort(factors, (a, b) -> {
            if (IntHasher.canSimplify(a) && !IntHasher.canSimplify(b)) {
                return -1;
            }
            if (!IntHasher.canSimplify(a) && IntHasher.canSimplify(b)) {
                return 1;
            }
            return 0;
        });
        log2 = Math.log(2.0);
    }
}

