/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.calc;

import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.PrimitiveConstant;
import org.graalvm.compiler.core.common.type.ArithmeticOpTable;
import org.graalvm.compiler.core.common.type.IntegerStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.lir.gen.ArithmeticLIRGeneratorTool;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.AddNode;
import org.graalvm.compiler.nodes.calc.BinaryArithmeticNode;
import org.graalvm.compiler.nodes.calc.NarrowableArithmeticNode;
import org.graalvm.compiler.nodes.calc.NotNode;
import org.graalvm.compiler.nodes.calc.OrNode;
import org.graalvm.compiler.nodes.calc.SignExtendNode;
import org.graalvm.compiler.nodes.calc.ZeroExtendNode;
import org.graalvm.compiler.nodes.spi.Canonicalizable;
import org.graalvm.compiler.nodes.spi.CanonicalizerTool;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import org.graalvm.compiler.nodes.util.GraphUtil;

@NodeInfo(shortName="&")
public final class AndNode
extends BinaryArithmeticNode<ArithmeticOpTable.BinaryOp.And>
implements NarrowableArithmeticNode,
Canonicalizable.BinaryCommutative<ValueNode> {
    public static final NodeClass<AndNode> TYPE = NodeClass.create(AndNode.class);

    public AndNode(ValueNode x, ValueNode y) {
        super(TYPE, AndNode.getArithmeticOpTable(x).getAnd(), x, y);
    }

    public static ValueNode create(ValueNode x, ValueNode y, NodeView view) {
        Stamp stamp;
        ArithmeticOpTable.BinaryOp<ArithmeticOpTable.BinaryOp.And> op = ArithmeticOpTable.forStamp(x.stamp(view)).getAnd();
        ConstantNode tryConstantFold = AndNode.tryConstantFold(op, x, y, stamp = op.foldStamp(x.stamp(view), y.stamp(view)), view);
        if (tryConstantFold != null) {
            return tryConstantFold;
        }
        return AndNode.canonical(null, op, x, y, view);
    }

    @Override
    protected ArithmeticOpTable.BinaryOp<ArithmeticOpTable.BinaryOp.And> getOp(ArithmeticOpTable table) {
        return table.getAnd();
    }

    @Override
    public ValueNode canonical(CanonicalizerTool tool, ValueNode forX, ValueNode forY) {
        ValueNode ret = super.canonical(tool, forX, forY);
        if (ret != this) {
            return ret;
        }
        NodeView view = NodeView.from(tool);
        return AndNode.canonical(this, this.getOp(forX, forY), forX, forY, view);
    }

    public static ValueNode eliminateRedundantBinaryArithmeticOp(ValueNode usingAndInput, IntegerStamp usingAndOtherStamp) {
        if (usingAndOtherStamp.isUnrestricted()) {
            return null;
        }
        if (!(usingAndInput instanceof BinaryArithmeticNode)) {
            return null;
        }
        BinaryArithmeticNode opNode = (BinaryArithmeticNode)usingAndInput;
        ValueNode opX = opNode.getX();
        ValueNode opY = opNode.getY();
        IntegerStamp stampX = (IntegerStamp)opX.stamp(NodeView.DEFAULT);
        IntegerStamp stampY = (IntegerStamp)opY.stamp(NodeView.DEFAULT);
        if (usingAndInput instanceof OrNode) {
            if (!stampY.isUnrestricted() && (stampY.upMask() & usingAndOtherStamp.upMask()) == 0L) {
                return opX;
            }
            if (!stampX.isUnrestricted() && (stampX.upMask() & usingAndOtherStamp.upMask()) == 0L) {
                return opY;
            }
        } else if (usingAndInput instanceof AddNode) {
            long mightBeOne = usingAndOtherStamp.upMask();
            if (Long.numberOfLeadingZeros(mightBeOne) + Long.bitCount(mightBeOne) != 64) {
                return null;
            }
            if (mightBeOne != 0L) {
                if (!stampY.isUnrestricted() && (stampY.upMask() & mightBeOne) == 0L) {
                    return opX;
                }
                if (!stampX.isUnrestricted() && (stampX.upMask() & mightBeOne) == 0L) {
                    return opY;
                }
            }
        }
        return null;
    }

    private static ValueNode canonical(AndNode self, ArithmeticOpTable.BinaryOp<ArithmeticOpTable.BinaryOp.And> op, ValueNode forX, ValueNode forY, NodeView view) {
        if (GraphUtil.unproxify(forX) == GraphUtil.unproxify(forY)) {
            return forX;
        }
        if (forX.isConstant() && !forY.isConstant()) {
            return new AndNode(forY, forX);
        }
        Stamp rawXStamp = forX.stamp(view);
        Stamp rawYStamp = forY.stamp(view);
        if (rawXStamp instanceof IntegerStamp && rawYStamp instanceof IntegerStamp) {
            IntegerStamp xStamp = (IntegerStamp)rawXStamp;
            IntegerStamp yStamp = (IntegerStamp)rawYStamp;
            if (((xStamp.downMask() ^ 0xFFFFFFFFFFFFFFFFL) & yStamp.upMask()) == 0L) {
                return forY;
            }
            if (((yStamp.downMask() ^ 0xFFFFFFFFFFFFFFFFL) & xStamp.upMask()) == 0L) {
                return forX;
            }
            ValueNode newLHS = AndNode.eliminateRedundantBinaryArithmeticOp(forX, yStamp);
            if (newLHS != null) {
                return new AndNode(newLHS, forY);
            }
            ValueNode newRHS = AndNode.eliminateRedundantBinaryArithmeticOp(forY, xStamp);
            if (newRHS != null) {
                return new AndNode(forX, newRHS);
            }
        }
        if (forY.isConstant()) {
            Constant c = forY.asConstant();
            if (op.isNeutral(c)) {
                return forX;
            }
            if (c instanceof PrimitiveConstant && ((PrimitiveConstant)c).getJavaKind().isNumericInteger()) {
                SignExtendNode ext;
                long rawY = ((PrimitiveConstant)c).asLong();
                if (forX instanceof SignExtendNode && rawY == (1L << (ext = (SignExtendNode)forX).getInputBits()) - 1L) {
                    return new ZeroExtendNode(ext.getValue(), ext.getResultBits());
                }
            }
            return AndNode.reassociateMatchedValues(self != null ? self : (AndNode)new AndNode(forX, forY).maybeCommuteInputs(), ValueNode.isConstantPredicate(), forX, forY, view);
        }
        if (forX instanceof NotNode && forY instanceof NotNode) {
            return new NotNode(OrNode.create(((NotNode)forX).getValue(), ((NotNode)forY).getValue(), view));
        }
        return self != null ? self : new AndNode(forX, forY).maybeCommuteInputs();
    }

    @Override
    public void generate(NodeLIRBuilderTool nodeValueMap, ArithmeticLIRGeneratorTool gen) {
        nodeValueMap.setResult(this, gen.emitAnd(nodeValueMap.operand(this.getX()), nodeValueMap.operand(this.getY())));
    }
}

