/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.java;

import org.graalvm.compiler.core.common.type.AbstractPointerStamp;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.WithExceptionNode;
import org.graalvm.compiler.nodes.java.DynamicNewInstanceNode;
import org.graalvm.compiler.nodes.memory.SingleMemoryKill;
import org.graalvm.compiler.nodes.spi.Lowerable;
import org.graalvm.compiler.nodes.spi.Simplifiable;
import org.graalvm.compiler.nodes.spi.SimplifierTool;
import org.graalvm.word.LocationIdentity;

@NodeInfo(size=NodeSize.SIZE_8, cycles=NodeCycles.CYCLES_8, cyclesRationale="Performs multiple checks.")
public final class ValidateNewInstanceClassNode
extends WithExceptionNode
implements Lowerable,
Simplifiable,
SingleMemoryKill {
    @Node.Input
    ValueNode clazz;
    @Node.OptionalInput
    ValueNode classClass;
    public static final NodeClass<ValidateNewInstanceClassNode> TYPE = NodeClass.create(ValidateNewInstanceClassNode.class);

    protected ValidateNewInstanceClassNode(ValueNode clazz) {
        super((NodeClass<? extends WithExceptionNode>)TYPE, AbstractPointerStamp.pointerNonNull(clazz.stamp(NodeView.DEFAULT)));
        this.clazz = clazz;
    }

    public ValueNode getInstanceType() {
        return this.clazz;
    }

    public ValueNode getClassClass() {
        return this.classClass;
    }

    public void setClassClass(ValueNode newClassClass) {
        this.updateUsages(this.classClass, newClassClass);
        this.classClass = newClassClass;
    }

    @Override
    public LocationIdentity getKilledLocationIdentity() {
        return LocationIdentity.any();
    }

    @Override
    public void simplify(SimplifierTool tool) {
        if (DynamicNewInstanceNode.tryConvertToNonDynamic(this.clazz, tool) != null) {
            this.killExceptionEdge();
            tool.addToWorkList(this.usages());
            this.replaceAtUsages(this.clazz);
            this.graph().removeSplit(this, this.next());
        }
    }
}

