/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.phases.graph;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.Equivalence;
import org.graalvm.collections.MapCursor;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.AbstractEndNode;
import org.graalvm.compiler.nodes.AbstractMergeNode;
import org.graalvm.compiler.nodes.EndNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.LoopBeginNode;
import org.graalvm.compiler.nodes.LoopEndNode;
import org.graalvm.compiler.nodes.LoopExitNode;

public final class ReentrantNodeIterator {
    private ReentrantNodeIterator() {
    }

    public static <StateT> LoopInfo<StateT> processLoop(NodeIteratorClosure<StateT> closure, LoopBeginNode loop, StateT initialState) {
        EconomicMap<FixedNode, StateT> blockEndStates = ReentrantNodeIterator.apply(closure, loop, initialState, loop);
        LoopInfo info = new LoopInfo(loop.loopEnds().count(), loop.loopExits().count());
        for (LoopEndNode end : loop.loopEnds()) {
            if (!blockEndStates.containsKey((Object)end)) continue;
            info.endStates.put((Object)end, blockEndStates.get((Object)end));
        }
        for (LoopExitNode exit : loop.loopExits()) {
            if (!blockEndStates.containsKey((Object)exit)) continue;
            info.exitStates.put((Object)exit, blockEndStates.get((Object)exit));
        }
        return info;
    }

    public static <StateT> void apply(NodeIteratorClosure<StateT> closure, FixedNode start, StateT initialState) {
        ReentrantNodeIterator.apply(closure, start, initialState, null);
    }

    /*
     * WARNING - void declaration
     */
    private static <StateT> EconomicMap<FixedNode, StateT> apply(NodeIteratorClosure<StateT> closure, FixedNode start, StateT initialState, LoopBeginNode boundary) {
        assert (start != null);
        ArrayDeque<AbstractBeginNode> nodeQueue = new ArrayDeque<AbstractBeginNode>();
        EconomicMap blockEndStates = EconomicMap.create((Equivalence)Equivalence.IDENTITY);
        Object state = initialState;
        FixedNode current = start;
        while (true) {
            block16: {
                Iterator successors;
                block17: {
                    block18: {
                        if (current instanceof FixedWithNextNode) {
                            if (boundary != null && current instanceof LoopExitNode && ((LoopExitNode)current).loopBegin() == boundary) {
                                blockEndStates.put((Object)current, state);
                                current = null;
                                continue;
                            }
                            FixedNode next = ((FixedWithNextNode)current).next();
                            current = closure.continueIteration(state = closure.processNode(current, state)) ? next : null;
                            continue;
                        }
                        if (current == null || !closure.continueIteration(state = closure.processNode(current, state))) break block16;
                        successors = current.successors().iterator();
                        if (successors.hasNext()) break block17;
                        if (!(current instanceof LoopEndNode)) break block18;
                        blockEndStates.put((Object)current, state);
                        break block16;
                    }
                    if (!(current instanceof EndNode)) break block16;
                    AbstractMergeNode merge = ((EndNode)current).merge();
                    if (merge instanceof LoopBeginNode) {
                        EconomicMap loopExitState = closure.processLoop((LoopBeginNode)merge, state);
                        MapCursor entry = loopExitState.getEntries();
                        while (entry.advance()) {
                            blockEndStates.put((Object)((FixedNode)entry.getKey()), entry.getValue());
                            nodeQueue.add((AbstractBeginNode)entry.getKey());
                        }
                    } else {
                        boolean endsVisited = true;
                        for (AbstractEndNode abstractEndNode : merge.forwardEnds()) {
                            if (abstractEndNode == current || blockEndStates.containsKey((Object)abstractEndNode)) continue;
                            endsVisited = false;
                            break;
                        }
                        if (endsVisited) {
                            void var12_16;
                            ArrayList<StateT> states = new ArrayList<StateT>(merge.forwardEndCount());
                            boolean bl = false;
                            while (var12_16 < merge.forwardEndCount()) {
                                EndNode forwardEnd = merge.forwardEndAt((int)var12_16);
                                assert (forwardEnd == current || blockEndStates.containsKey((Object)forwardEnd));
                                Object other = forwardEnd == current ? state : blockEndStates.removeKey((Object)forwardEnd);
                                states.add(other);
                                ++var12_16;
                            }
                            state = closure.merge(merge, states);
                            current = closure.continueIteration(state) ? merge : null;
                            continue;
                        }
                        assert (!blockEndStates.containsKey((Object)current));
                        blockEndStates.put((Object)current, state);
                    }
                    break block16;
                }
                FixedNode firstSuccessor = (FixedNode)successors.next();
                if (!successors.hasNext()) {
                    current = firstSuccessor;
                    continue;
                }
                do {
                    AbstractBeginNode successor;
                    Object successorState;
                    if (!closure.continueIteration(successorState = closure.afterSplit(successor = (AbstractBeginNode)successors.next(), state))) continue;
                    blockEndStates.put((Object)successor, successorState);
                    nodeQueue.add(successor);
                } while (successors.hasNext());
                current = closure.continueIteration(state = closure.afterSplit((AbstractBeginNode)firstSuccessor, state)) ? firstSuccessor : null;
                continue;
            }
            if (nodeQueue.isEmpty()) {
                return blockEndStates;
            }
            current = (FixedNode)nodeQueue.removeFirst();
            assert (blockEndStates.containsKey((Object)current));
            state = blockEndStates.removeKey((Object)current);
            if (!($assertionsDisabled || !(current instanceof AbstractMergeNode) && current instanceof AbstractBeginNode)) break;
        }
        throw new AssertionError();
    }

    public static abstract class NodeIteratorClosure<StateT> {
        protected abstract StateT processNode(FixedNode var1, StateT var2);

        protected abstract StateT merge(AbstractMergeNode var1, List<StateT> var2);

        protected abstract StateT afterSplit(AbstractBeginNode var1, StateT var2);

        protected abstract EconomicMap<LoopExitNode, StateT> processLoop(LoopBeginNode var1, StateT var2);

        protected boolean continueIteration(StateT currentState) {
            return true;
        }
    }

    public static class LoopInfo<StateT> {
        public final EconomicMap<LoopEndNode, StateT> endStates;
        public final EconomicMap<LoopExitNode, StateT> exitStates;

        public LoopInfo(int endCount, int exitCount) {
            this.endStates = EconomicMap.create((Equivalence)Equivalence.IDENTITY, (int)endCount);
            this.exitStates = EconomicMap.create((Equivalence)Equivalence.IDENTITY, (int)exitCount);
        }
    }
}

