/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.compiler.hotspot;

import jdk.vm.ci.code.InstalledCode;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.asm.Assembler;
import org.graalvm.compiler.code.CompilationResult;
import org.graalvm.compiler.core.common.spi.CodeGenProviders;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.hotspot.GraalHotSpotVMConfig;
import org.graalvm.compiler.hotspot.HotSpotMarkId;
import org.graalvm.compiler.hotspot.meta.HotSpotRegistersProvider;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;
import org.graalvm.compiler.lir.asm.DataBuilder;
import org.graalvm.compiler.lir.asm.FrameContext;
import org.graalvm.compiler.lir.framemap.FrameMap;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.truffle.common.TruffleCompilerRuntime;

public abstract class TruffleCallBoundaryInstrumentation
extends CompilationResultBuilder {
    protected final GraalHotSpotVMConfig config;
    protected final HotSpotRegistersProvider registers;
    protected final MetaAccessProvider metaAccess;

    public TruffleCallBoundaryInstrumentation(CodeGenProviders providers, FrameMap frameMap, Assembler<?> asm, DataBuilder dataBuilder, FrameContext frameContext, OptionValues options, DebugContext debug, CompilationResult compilationResult, GraalHotSpotVMConfig config, HotSpotRegistersProvider registers) {
        super(providers, frameMap, asm, dataBuilder, frameContext, options, debug, compilationResult, Register.None, null, CompilationResultBuilder.NO_VERIFIERS);
        this.metaAccess = providers.getMetaAccess();
        this.config = config;
        this.registers = registers;
    }

    @Override
    public CompilationResult.CodeMark recordMark(CompilationResult.MarkId id) {
        CompilationResult.CodeMark mark = super.recordMark(id);
        if (id == HotSpotMarkId.VERIFIED_ENTRY) {
            ResolvedJavaType optimizedCallTargetType = TruffleCompilerRuntime.getRuntime().resolveType(this.metaAccess, "org.graalvm.compiler.truffle.runtime.hotspot.HotSpotOptimizedCallTarget");
            int installedCodeOffset = TruffleCallBoundaryInstrumentation.getFieldOffset("installedCode", optimizedCallTargetType);
            int entryPointOffset = TruffleCallBoundaryInstrumentation.getFieldOffset("entryPoint", TruffleCompilerRuntime.getRuntime().resolveType(this.metaAccess, InstalledCode.class.getName()));
            this.injectTailCallCode(installedCodeOffset, entryPointOffset);
        }
        return mark;
    }

    private static int getFieldOffset(String name, ResolvedJavaType declaringType) {
        for (ResolvedJavaField field : declaringType.getInstanceFields(false)) {
            if (!field.getName().equals(name)) continue;
            return field.getOffset();
        }
        throw new NoSuchFieldError(declaringType.toJavaName() + "." + name);
    }

    protected abstract void injectTailCallCode(int var1, int var2);
}

