/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.compiler.nodes.frame;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.SpeculationLog;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.core.common.type.TypeReference;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.IterableNodeType;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.graph.NodeInputList;
import org.graalvm.compiler.graph.NodeSourcePosition;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.spi.Canonicalizable;
import org.graalvm.compiler.nodes.spi.CanonicalizerTool;
import org.graalvm.compiler.nodes.spi.VirtualizableAllocation;
import org.graalvm.compiler.nodes.spi.VirtualizerTool;
import org.graalvm.compiler.nodes.virtual.VirtualArrayNode;
import org.graalvm.compiler.nodes.virtual.VirtualInstanceNode;
import org.graalvm.compiler.nodes.virtual.VirtualObjectNode;
import org.graalvm.compiler.serviceprovider.SpeculationReasonGroup;
import org.graalvm.compiler.truffle.common.TruffleCompilerRuntime;
import org.graalvm.compiler.truffle.compiler.nodes.frame.VirtualFrameAccessType;
import org.graalvm.compiler.truffle.compiler.substitutions.KnownTruffleTypes;

@NodeInfo(cycles=NodeCycles.CYCLES_0, size=NodeSize.SIZE_0)
public final class NewFrameNode
extends FixedWithNextNode
implements IterableNodeType,
VirtualizableAllocation,
Canonicalizable {
    public static final byte NO_TYPE_MARKER = 121;
    public static final byte INITIAL_TYPE_MARKER = 120;
    public static final byte FrameSlotKindObjectTag = 0;
    public static final byte FrameSlotKindLongTag = 1;
    private static final byte FrameSlotKindIntTag = 2;
    private static final byte FrameSlotKindDoubleTag = 3;
    private static final byte FrameSlotKindFloatTag = 4;
    private static final byte FrameSlotKindBooleanTag = 5;
    private static final byte FrameSlotKindByteTag = 6;
    public static final byte FrameSlotKindIllegalTag = 7;
    public static final byte FrameSlotKindStaticTag = 8;
    private static final byte FrameDescriptorNoStaticMode = 1;
    private static final byte FrameDescriptorAllStaticMode = 2;
    private static final byte FrameDescriptorMixedStaticMode = 3;
    public static final NodeClass<NewFrameNode> TYPE = NodeClass.create(NewFrameNode.class);
    @Node.Input
    ValueNode descriptor;
    @Node.Input
    ValueNode arguments;
    @Node.Input
    VirtualInstanceNode virtualFrame;
    @Node.Input
    NodeInputList<ValueNode> virtualFrameArrays;
    private static final int INDEXED_OBJECT_ARRAY = 0;
    private static final int INDEXED_PRIMITIVE_ARRAY = 1;
    private static final int INDEXED_TAGS_ARRAY = 2;
    private static final int AUXILIARY_SLOTS_ARRAY = 3;
    @Node.Input
    NodeInputList<ValueNode> smallIntConstants;
    @Node.Input
    private ValueNode frameDefaultValue;
    private final boolean intrinsifyAccessors;
    private final byte[] indexedFrameSlotKinds;
    private final int indexedFrameSize;
    private final int auxiliarySize;
    private final int staticMode;
    private final SpeculationLog.SpeculationReason intrinsifyAccessorsSpeculation;
    private static final SpeculationReasonGroup INTRINSIFY_FRAME_ACCESSORS_SPECULATIONS = new SpeculationReasonGroup("IntrinsifyFrameAccessor", new Class[0]);
    private final KnownTruffleTypes types;

    public static byte asStackTag(byte tag) {
        switch (tag) {
            case 2: 
            case 5: 
            case 6: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
            case 0: 
            case 1: 
            case 7: 
            case 120: 
            case 121: {
                return 1;
            }
            case 8: {
                return 8;
            }
        }
        throw new IllegalStateException("Unexpected frame slot kind tag: " + tag);
    }

    public static JavaKind asJavaKind(byte tag) {
        switch (tag) {
            case 2: {
                return JavaKind.Int;
            }
            case 3: {
                return JavaKind.Double;
            }
            case 4: {
                return JavaKind.Float;
            }
            case 1: 
            case 121: {
                return JavaKind.Long;
            }
        }
        throw new IllegalStateException("Unexpected frame slot kind tag: " + tag);
    }

    public NewFrameNode(GraphBuilderContext b, ValueNode frameDescriptorNode, ValueNode arguments, KnownTruffleTypes types) {
        super((NodeClass<? extends FixedWithNextNode>)TYPE, (Stamp)StampFactory.objectNonNull(TypeReference.createExactTrusted(types.classFrameClass)));
        ValueNode indexedTags;
        ValueNode indexedPrimitiveLocals;
        ValueNode indexedLocals;
        boolean emptyArraysAvailable;
        this.descriptor = frameDescriptorNode;
        this.arguments = arguments;
        this.types = types;
        StructuredGraph graph = b.getGraph();
        MetaAccessProvider metaAccess = b.getMetaAccess();
        ConstantReflectionProvider constantReflection = b.getConstantReflection();
        JavaConstant frameDescriptor = frameDescriptorNode.asJavaConstant();
        this.intrinsifyAccessorsSpeculation = INTRINSIFY_FRAME_ACCESSORS_SPECULATIONS.createSpeculationReason(new Object[0]);
        boolean intrinsify = false;
        if (!constantReflection.readFieldValue(types.fieldFrameDescriptorMaterializeCalled, frameDescriptor).asBoolean()) {
            SpeculationLog speculationLog = graph.getSpeculationLog();
            intrinsify = speculationLog != null && speculationLog.maySpeculate(this.intrinsifyAccessorsSpeculation);
        }
        this.intrinsifyAccessors = intrinsify;
        JavaConstant defaultValue = constantReflection.readFieldValue(types.fieldFrameDescriptorDefaultValue, frameDescriptor);
        this.frameDefaultValue = ConstantNode.forConstant(defaultValue, metaAccess, graph);
        JavaConstant indexedTagsArray = constantReflection.readFieldValue(types.fieldFrameDescriptorIndexedSlotTags, frameDescriptor);
        this.indexedFrameSize = constantReflection.readArrayLength(indexedTagsArray);
        JavaConstant staticModeValue = constantReflection.readFieldValue(types.fieldFrameDescriptorStaticMode, frameDescriptor);
        this.staticMode = staticModeValue.asInt();
        byte[] indexedFrameSlotKindsCandidate = new byte[this.indexedFrameSize];
        if (this.staticMode == 1) {
            Arrays.fill(indexedFrameSlotKindsCandidate, (byte)1);
        } else if (this.staticMode == 2) {
            Arrays.fill(indexedFrameSlotKindsCandidate, (byte)8);
        } else if (this.staticMode == 3) {
            int indexedTagsArrayLength = constantReflection.readArrayLength(indexedTagsArray);
            for (int i = 0; i < indexedTagsArrayLength; ++i) {
                int slot = constantReflection.readArrayElement(indexedTagsArray, i).asInt();
                indexedFrameSlotKindsCandidate[i] = slot == 8 ? 8 : 1;
            }
        }
        this.indexedFrameSlotKinds = indexedFrameSlotKindsCandidate;
        this.auxiliarySize = constantReflection.readFieldValue(types.fieldFrameDescriptorAuxiliarySlotCount, frameDescriptor).asInt();
        ResolvedJavaType frameType = types.classFrameClass;
        ResolvedJavaField[] frameFields = frameType.getInstanceFields(true);
        this.virtualFrame = graph.add(new VirtualInstanceNode(frameType, frameFields, true));
        ValueNode emptyObjectArray = NewFrameNode.constantObject(graph, b, types.fieldEmptyObjectArray);
        ValueNode emptyLongArray = NewFrameNode.constantObject(graph, b, types.fieldEmptyLongArray);
        ValueNode emptyByteArray = NewFrameNode.constantObject(graph, b, types.fieldEmptyByteArray);
        boolean bl = emptyArraysAvailable = emptyObjectArray != null && emptyLongArray != null && emptyByteArray != null;
        if (this.indexedFrameSize == 0 && emptyArraysAvailable) {
            indexedLocals = emptyObjectArray;
            indexedPrimitiveLocals = emptyLongArray;
            indexedTags = emptyByteArray;
        } else {
            indexedLocals = graph.add(new VirtualArrayNode((ResolvedJavaType)types.fieldIndexedLocals.getType().getComponentType(), this.indexedFrameSize));
            indexedPrimitiveLocals = graph.add(new VirtualArrayNode((ResolvedJavaType)types.fieldIndexedPrimitiveLocals.getType().getComponentType(), this.indexedFrameSize));
            indexedTags = graph.add(new VirtualArrayNode((ResolvedJavaType)types.fieldIndexedTags.getType().getComponentType(), this.indexedFrameSize));
        }
        ValueNode auxiliarySlotsArray = this.auxiliarySize == 0 && emptyArraysAvailable ? emptyObjectArray : (ValueNode)graph.add(new VirtualArrayNode((ResolvedJavaType)types.fieldAuxiliarySlots.getType().getComponentType(), this.auxiliarySize));
        this.virtualFrameArrays = new NodeInputList((Node)this, (Node[])new ValueNode[]{indexedLocals, indexedPrimitiveLocals, indexedTags, auxiliarySlotsArray});
        Node[] c = new ValueNode[TruffleCompilerRuntime.getRuntime().getFrameSlotKindTagsCount() * 2];
        for (int i = 0; i < c.length; ++i) {
            c[i] = ConstantNode.forInt(i, graph);
        }
        this.smallIntConstants = new NodeInputList((Node)this, c);
    }

    private static ValueNode constantObject(StructuredGraph graph, GraphBuilderContext b, ResolvedJavaField field) {
        JavaConstant fieldValue = b.getConstantReflection().readFieldValue(field, null);
        return fieldValue == null ? null : ConstantNode.forConstant(fieldValue, b.getMetaAccess(), graph);
    }

    public byte[] getIndexedFrameSlotKinds() {
        return this.indexedFrameSlotKinds;
    }

    public ValueNode getDescriptor() {
        return this.descriptor;
    }

    public ValueNode getArguments() {
        return this.arguments;
    }

    public boolean getIntrinsifyAccessors() {
        return this.intrinsifyAccessors;
    }

    public SpeculationLog.SpeculationReason getIntrinsifyAccessorsSpeculation() {
        return this.intrinsifyAccessorsSpeculation;
    }

    public boolean isValidIndexedSlotIndex(int index) {
        return index >= 0 && index < this.indexedFrameSize;
    }

    static ResolvedJavaField findField(ResolvedJavaField[] fields, String fieldName) {
        for (ResolvedJavaField field : fields) {
            if (!field.getName().equals(fieldName)) continue;
            return field;
        }
        return null;
    }

    @Override
    public void virtualize(VirtualizerTool tool) {
        ResolvedJavaType frameType = this.stamp(NodeView.DEFAULT).javaType(tool.getMetaAccess());
        assert (frameType.equals(this.types.classFrameClass));
        NodeSourcePosition sourcePosition = this.getNodeSourcePosition();
        ConstantNode defaultLong = ConstantNode.defaultForKind(JavaKind.Long, this.graph());
        if (this.virtualFrameArrays.get(0) instanceof VirtualArrayNode) {
            Object[] indexedObjectArrayEntryState = new ValueNode[this.indexedFrameSize];
            Object[] indexedPrimitiveArrayEntryState = new ValueNode[this.indexedFrameSize];
            Object[] indexedTagArrayEntryState = new ValueNode[this.indexedFrameSize];
            Arrays.fill(indexedObjectArrayEntryState, this.frameDefaultValue);
            if (this.staticMode == 1) {
                Arrays.fill(indexedTagArrayEntryState, this.smallIntConstants.get(0));
            } else if (this.staticMode == 2) {
                Arrays.fill(indexedTagArrayEntryState, this.smallIntConstants.get(8));
            } else if (this.staticMode == 3) {
                for (int slot = 0; slot < this.indexedFrameSize; ++slot) {
                    indexedTagArrayEntryState[slot] = this.indexedFrameSlotKinds[slot] == 8 ? (ValueNode)this.smallIntConstants.get(8) : (ValueNode)this.smallIntConstants.get(0);
                }
            }
            Arrays.fill(indexedPrimitiveArrayEntryState, defaultLong);
            tool.createVirtualObject((VirtualObjectNode)this.virtualFrameArrays.get(0), (ValueNode[])indexedObjectArrayEntryState, Collections.emptyList(), sourcePosition, false);
            tool.createVirtualObject((VirtualObjectNode)this.virtualFrameArrays.get(1), (ValueNode[])indexedPrimitiveArrayEntryState, Collections.emptyList(), sourcePosition, false);
            tool.createVirtualObject((VirtualObjectNode)this.virtualFrameArrays.get(2), (ValueNode[])indexedTagArrayEntryState, Collections.emptyList(), sourcePosition, false);
        }
        if (this.virtualFrameArrays.get(3) instanceof VirtualArrayNode) {
            Object[] auxiliarySlotArrayEntryState = new ValueNode[this.auxiliarySize];
            Arrays.fill(auxiliarySlotArrayEntryState, ConstantNode.defaultForKind(JavaKind.Object, this.graph()));
            tool.createVirtualObject((VirtualObjectNode)this.virtualFrameArrays.get(3), (ValueNode[])auxiliarySlotArrayEntryState, Collections.emptyList(), sourcePosition, false);
        }
        assert (this.types.frameFields.length == 6);
        ValueNode[] frameEntryState = new ValueNode[this.types.frameFields.length];
        List<ResolvedJavaField> frameFieldList = Arrays.asList(this.types.frameFields);
        frameEntryState[frameFieldList.indexOf((Object)this.types.fieldDescriptor)] = this.getDescriptor();
        frameEntryState[frameFieldList.indexOf((Object)this.types.fieldIndexedLocals)] = (ValueNode)this.virtualFrameArrays.get(0);
        frameEntryState[frameFieldList.indexOf((Object)this.types.fieldIndexedPrimitiveLocals)] = (ValueNode)this.virtualFrameArrays.get(1);
        frameEntryState[frameFieldList.indexOf((Object)this.types.fieldIndexedTags)] = (ValueNode)this.virtualFrameArrays.get(2);
        frameEntryState[frameFieldList.indexOf((Object)this.types.fieldArguments)] = this.getArguments();
        frameEntryState[frameFieldList.indexOf((Object)this.types.fieldAuxiliarySlots)] = (ValueNode)this.virtualFrameArrays.get(3);
        tool.createVirtualObject(this.virtualFrame, frameEntryState, Collections.emptyList(), sourcePosition, true);
        tool.replaceWithVirtual(this.virtualFrame);
    }

    @Override
    public Node canonical(CanonicalizerTool tool) {
        if (tool.allUsagesAvailable() && this.hasNoUsages()) {
            return null;
        }
        return this;
    }

    public VirtualArrayNode getTagArray(VirtualFrameAccessType type) {
        switch (type) {
            case Indexed: {
                return (VirtualArrayNode)this.virtualFrameArrays.get(2);
            }
            case Auxiliary: {
                return null;
            }
        }
        throw GraalError.shouldNotReachHere();
    }

    public VirtualArrayNode getObjectArray(VirtualFrameAccessType type) {
        switch (type) {
            case Indexed: {
                return (VirtualArrayNode)this.virtualFrameArrays.get(0);
            }
            case Auxiliary: {
                return (VirtualArrayNode)this.virtualFrameArrays.get(3);
            }
        }
        throw GraalError.shouldNotReachHere();
    }

    public VirtualArrayNode getPrimitiveArray(VirtualFrameAccessType type) {
        switch (type) {
            case Indexed: {
                return (VirtualArrayNode)this.virtualFrameArrays.get(1);
            }
            case Auxiliary: {
                return null;
            }
        }
        throw GraalError.shouldNotReachHere();
    }

    public int getIndexedFrameSize() {
        return this.indexedFrameSize;
    }
}

