/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.runtime.debug;

import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.NodeVisitor;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.graalvm.compiler.truffle.common.TruffleCompilerListener;
import org.graalvm.compiler.truffle.options.PolyglotCompilerOptions;
import org.graalvm.compiler.truffle.runtime.AbstractGraalTruffleRuntimeListener;
import org.graalvm.compiler.truffle.runtime.GraalTruffleRuntime;
import org.graalvm.compiler.truffle.runtime.OptimizedCallTarget;
import org.graalvm.compiler.truffle.runtime.TruffleInlining;

public final class TraceASTCompilationListener
extends AbstractGraalTruffleRuntimeListener {
    private TraceASTCompilationListener(GraalTruffleRuntime runtime) {
        super(runtime);
    }

    public static void install(GraalTruffleRuntime runtime) {
        runtime.addListener(new TraceASTCompilationListener(runtime));
    }

    @Override
    public void onCompilationSuccess(OptimizedCallTarget target, TruffleInlining inliningDecision, TruffleCompilerListener.GraphInfo graphInfo, TruffleCompilerListener.CompilationResultInfo compilationResultInfo, int tier) {
        if (target.getOptionValue(PolyglotCompilerOptions.TraceCompilationAST).booleanValue()) {
            StringWriter logMessage = new StringWriter();
            try (PrintWriter out = new PrintWriter(logMessage);){
                TraceASTCompilationListener.printCompactTree(out, target);
            }
            this.runtime.logEvent(target, 0, "opt AST", target.toString(), target.getDebugProperties(), logMessage.toString());
        }
    }

    private static void printCompactTree(final PrintWriter out, OptimizedCallTarget target) {
        target.accept(new NodeVisitor(){
            private boolean newLine = false;

            public boolean visit(Node node) {
                if (node == null) {
                    return true;
                }
                Node parent = node.getParent();
                if (this.newLine) {
                    out.println();
                } else {
                    this.newLine = true;
                }
                if (parent == null) {
                    out.printf("%s", node.getClass().getSimpleName());
                } else {
                    String fieldName = NodeUtil.findChildFieldName((Node)parent, (Node)node);
                    out.printf("%s = %s", fieldName, node.getClass().getSimpleName());
                }
                return true;
            }
        });
    }
}

