/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.virtual.phases.ea;

import java.util.Optional;
import org.graalvm.collections.EconomicSet;
import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.GraphState;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.cfg.ControlFlowGraph;
import org.graalvm.compiler.nodes.spi.CoreProviders;
import org.graalvm.compiler.nodes.virtual.VirtualObjectNode;
import org.graalvm.compiler.options.OptionKey;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.BasePhase;
import org.graalvm.compiler.phases.common.CanonicalizerPhase;
import org.graalvm.compiler.phases.schedule.SchedulePhase;
import org.graalvm.compiler.virtual.phases.ea.EffectsPhase;
import org.graalvm.compiler.virtual.phases.ea.PEReadEliminationClosure;
import org.graalvm.compiler.virtual.phases.ea.PartialEscapeClosure;
import org.graalvm.compiler.virtual.phases.ea.VirtualUtil;

public class PartialEscapePhase
extends EffectsPhase<CoreProviders> {
    private final boolean readElimination;
    private final BasePhase<CoreProviders> cleanupPhase;

    public PartialEscapePhase(boolean iterative, CanonicalizerPhase canonicalizer, OptionValues options) {
        this(iterative, Options.OptEarlyReadElimination.getValue(options), canonicalizer, null, options);
    }

    public PartialEscapePhase(boolean iterative, CanonicalizerPhase canonicalizer, BasePhase<CoreProviders> cleanupPhase, OptionValues options) {
        this(iterative, Options.OptEarlyReadElimination.getValue(options), canonicalizer, cleanupPhase, options);
    }

    public PartialEscapePhase(boolean iterative, boolean readElimination, CanonicalizerPhase canonicalizer, BasePhase<CoreProviders> cleanupPhase, OptionValues options) {
        super(iterative ? GraalOptions.EscapeAnalysisIterations.getValue(options) : 1, canonicalizer);
        this.readElimination = readElimination;
        this.cleanupPhase = cleanupPhase;
    }

    public PartialEscapePhase(int iterations, boolean readElimination, CanonicalizerPhase canonicalizer, BasePhase<CoreProviders> cleanupPhase) {
        super(iterations, canonicalizer);
        this.readElimination = readElimination;
        this.cleanupPhase = cleanupPhase;
    }

    public PartialEscapePhase(boolean iterative, boolean readElimination, CanonicalizerPhase canonicalizer, BasePhase<CoreProviders> cleanupPhase, OptionValues options, SchedulePhase.SchedulingStrategy strategy) {
        super(iterative ? GraalOptions.EscapeAnalysisIterations.getValue(options) : 1, canonicalizer, false, strategy);
        this.readElimination = readElimination;
        this.cleanupPhase = cleanupPhase;
    }

    @Override
    protected void postIteration(StructuredGraph graph, CoreProviders context, EconomicSet<Node> changedNodes) {
        super.postIteration(graph, context, changedNodes);
        if (this.cleanupPhase != null) {
            this.cleanupPhase.apply(graph, context);
        }
    }

    @Override
    public Optional<BasePhase.NotApplicable> canApply(GraphState graphState) {
        return BasePhase.NotApplicable.combineConstraints(super.canApply(graphState), BasePhase.NotApplicable.mustRunBefore(this, GraphState.StageFlag.HIGH_TIER_LOWERING, graphState), this.cleanupPhase != null ? this.cleanupPhase.canApply(graphState) : ALWAYS_APPLICABLE);
    }

    @Override
    protected void run(StructuredGraph graph, CoreProviders context) {
        if (VirtualUtil.matches(graph, GraalOptions.EscapeAnalyzeOnly.getValue(graph.getOptions())) && (this.readElimination || graph.hasVirtualizableAllocation())) {
            this.runAnalysis(graph, context);
        }
    }

    @Override
    protected EffectsPhase.Closure<?> createEffectsClosure(CoreProviders context, StructuredGraph.ScheduleResult schedule, ControlFlowGraph cfg) {
        for (VirtualObjectNode virtual : cfg.graph.getNodes(VirtualObjectNode.TYPE)) {
            virtual.resetObjectId();
        }
        assert (schedule != null);
        if (this.readElimination) {
            return new PEReadEliminationClosure(schedule, context);
        }
        return new PartialEscapeClosure.Final(schedule, context);
    }

    @Override
    public boolean checkContract() {
        return false;
    }

    static class Options {
        public static final OptionKey<Boolean> OptEarlyReadElimination = new OptionKey<Boolean>(true);

        Options() {
        }
    }
}

