/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.bytecode;

import java.lang.annotation.Annotation;
import jdk.vm.ci.meta.ConstantPool;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.bytecode.BytecodeDisassembler;
import org.graalvm.compiler.bytecode.BytecodeStream;
import org.graalvm.compiler.bytecode.ResolvedJavaMethodBytecode;

public class BridgeMethodUtils {
    public static ResolvedJavaMethod getBridgedMethod(ResolvedJavaMethod bridge) {
        assert (bridge.isBridge());
        ResolvedJavaMethodBytecode code = new ResolvedJavaMethodBytecode(bridge);
        BytecodeStream stream = new BytecodeStream(code.getCode());
        int opcode = stream.currentBC();
        ResolvedJavaMethod bridged = null;
        boolean calledAbstractMethodErrorConstructor = false;
        while (opcode != 256) {
            switch (opcode) {
                case 182: 
                case 183: 
                case 184: 
                case 185: {
                    char cpi = stream.readCPI();
                    ConstantPool cp = code.getConstantPool();
                    cp.loadReferencedType((int)cpi, opcode);
                    ResolvedJavaMethod method = (ResolvedJavaMethod)cp.lookupMethod((int)cpi, opcode);
                    if (method.getName().equals(bridge.getName())) {
                        if (!BridgeMethodUtils.assertionsEnabled()) {
                            return method;
                        }
                        assert (bridged == null || bridged.equals(method)) : String.format("Found calls to different methods named %s in bridge method %s%n  callee 1: %s%n  callee 2: %s", bridge.getName(), bridge.format("%R %H.%n(%P)"), bridged.format("%R %H.%n(%P)"), method.format("%R %H.%n(%P)"));
                        bridged = method;
                        break;
                    }
                    if (!method.getName().equals("<init>") || !method.getDeclaringClass().getName().equals("Ljava/lang/AbstractMethodError;")) break;
                    calledAbstractMethodErrorConstructor = true;
                    break;
                }
                case 191: {
                    if (!calledAbstractMethodErrorConstructor) break;
                    return null;
                }
            }
            stream.next();
            opcode = stream.currentBC();
        }
        if (bridged == null) {
            String dis = new BytecodeDisassembler().disassemble(bridge);
            throw new InternalError(String.format("Couldn't find method bridged by %s:%n%s", bridge.format("%R %H.%n(%P)"), dis));
        }
        return bridged;
    }

    private static boolean assertionsEnabled() {
        boolean enabled = false;
        if (!$assertionsDisabled) {
            enabled = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        return enabled;
    }

    public static <T extends Annotation> T getAnnotation(Class<T> annotationClass, ResolvedJavaMethod method) {
        ResolvedJavaMethod bridged;
        Annotation a = method.getAnnotation(annotationClass);
        if (a == null && method.isBridge() && (bridged = BridgeMethodUtils.getBridgedMethod(method)) != null) {
            a = bridged.getAnnotation(annotationClass);
        }
        return (T)a;
    }

    public static Annotation[][] getParameterAnnotations(ResolvedJavaMethod method) {
        ResolvedJavaMethod bridged;
        Annotation[][] a = method.getParameterAnnotations();
        if (a.length == 0 && method.isBridge() && (bridged = BridgeMethodUtils.getBridgedMethod(method)) != null) {
            a = bridged.getParameterAnnotations();
        }
        return a;
    }
}

