/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.core.aarch64;

import jdk.vm.ci.aarch64.AArch64;
import jdk.vm.ci.aarch64.AArch64Kind;
import jdk.vm.ci.code.CodeUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.PrimitiveConstant;
import jdk.vm.ci.meta.Value;
import jdk.vm.ci.meta.ValueKind;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.Equivalence;
import org.graalvm.compiler.asm.aarch64.AArch64Assembler;
import org.graalvm.compiler.core.aarch64.AArch64ArithmeticLIRGenerator;
import org.graalvm.compiler.core.aarch64.AArch64LIRGenerator;
import org.graalvm.compiler.core.aarch64.AArch64PointerAddNode;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.core.common.calc.CanonicalCondition;
import org.graalvm.compiler.core.common.calc.FloatConvert;
import org.graalvm.compiler.core.gen.NodeMatchRules;
import org.graalvm.compiler.core.match.ComplexMatchResult;
import org.graalvm.compiler.core.match.MatchRule;
import org.graalvm.compiler.core.match.MatchRules;
import org.graalvm.compiler.core.match.MatchableNode;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.lir.LIRFrameState;
import org.graalvm.compiler.lir.LabelRef;
import org.graalvm.compiler.lir.Variable;
import org.graalvm.compiler.lir.aarch64.AArch64ArithmeticOp;
import org.graalvm.compiler.lir.aarch64.AArch64BitFieldOp;
import org.graalvm.compiler.lir.aarch64.AArch64ControlFlow;
import org.graalvm.compiler.lir.gen.LIRGeneratorTool;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.DeoptimizingNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.IfNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.AddNode;
import org.graalvm.compiler.nodes.calc.AndNode;
import org.graalvm.compiler.nodes.calc.BinaryNode;
import org.graalvm.compiler.nodes.calc.FloatConvertNode;
import org.graalvm.compiler.nodes.calc.IntegerConvertNode;
import org.graalvm.compiler.nodes.calc.IntegerLessThanNode;
import org.graalvm.compiler.nodes.calc.LeftShiftNode;
import org.graalvm.compiler.nodes.calc.MulNode;
import org.graalvm.compiler.nodes.calc.NotNode;
import org.graalvm.compiler.nodes.calc.OrNode;
import org.graalvm.compiler.nodes.calc.RightShiftNode;
import org.graalvm.compiler.nodes.calc.ShiftNode;
import org.graalvm.compiler.nodes.calc.SignExtendNode;
import org.graalvm.compiler.nodes.calc.SubNode;
import org.graalvm.compiler.nodes.calc.UnaryNode;
import org.graalvm.compiler.nodes.calc.UnsignedRightShiftNode;
import org.graalvm.compiler.nodes.calc.XorNode;
import org.graalvm.compiler.nodes.calc.ZeroExtendNode;
import org.graalvm.compiler.nodes.memory.MemoryAccess;

@MatchableNode(nodeClass=AArch64PointerAddNode.class, inputs={"base", "offset"})
public class AArch64NodeMatchRules
extends NodeMatchRules {
    private static final EconomicMap<Class<? extends BinaryNode>, AArch64ArithmeticOp> binaryOpMap = EconomicMap.create((Equivalence)Equivalence.IDENTITY, (int)9);
    private static final EconomicMap<Class<? extends BinaryNode>, AArch64BitFieldOp.BitFieldOpCode> bitFieldOpMap;
    private static final EconomicMap<Class<? extends BinaryNode>, AArch64Assembler.ShiftType> shiftTypeMap;
    private static final EconomicMap<Class<? extends BinaryNode>, AArch64ArithmeticOp> logicalNotOpMap;

    public AArch64NodeMatchRules(LIRGeneratorTool gen) {
        super(gen);
    }

    protected boolean isNumericInteger(ValueNode ... values) {
        for (ValueNode value : values) {
            if (value.getStackKind().isNumericInteger()) continue;
            return false;
        }
        return true;
    }

    protected boolean isNumericFloat(ValueNode ... values) {
        for (ValueNode value : values) {
            if (value.getStackKind().isNumericFloat()) continue;
            return false;
        }
        return true;
    }

    protected LIRFrameState getState(MemoryAccess access) {
        if (access instanceof DeoptimizingNode) {
            return this.state((DeoptimizingNode)((Object)access));
        }
        return null;
    }

    protected AArch64Kind getMemoryKind(MemoryAccess access) {
        return (AArch64Kind)this.gen.getLIRKind(((ValueNode)((Object)access)).stamp(NodeView.DEFAULT)).getPlatformKind();
    }

    private static boolean isSupportedExtendedAddSubShift(IntegerConvertNode<?> node, int clampedShiftAmt) {
        assert (clampedShiftAmt >= 0);
        if (clampedShiftAmt <= 4) {
            switch (node.getInputBits()) {
                case 8: 
                case 16: 
                case 32: 
                case 64: {
                    return true;
                }
            }
        }
        return false;
    }

    private static AArch64Assembler.ExtendType getZeroExtendType(int fromBits) {
        switch (fromBits) {
            case 8: {
                return AArch64Assembler.ExtendType.UXTB;
            }
            case 16: {
                return AArch64Assembler.ExtendType.UXTH;
            }
            case 32: {
                return AArch64Assembler.ExtendType.UXTW;
            }
            case 64: {
                return AArch64Assembler.ExtendType.UXTX;
            }
        }
        GraalError.shouldNotReachHere("extended from " + fromBits + "bits is not supported!");
        return null;
    }

    private static AArch64Assembler.ExtendType getSignExtendType(int fromBits) {
        switch (fromBits) {
            case 8: {
                return AArch64Assembler.ExtendType.SXTB;
            }
            case 16: {
                return AArch64Assembler.ExtendType.SXTH;
            }
            case 32: {
                return AArch64Assembler.ExtendType.SXTW;
            }
            case 64: {
                return AArch64Assembler.ExtendType.SXTX;
            }
        }
        GraalError.shouldNotReachHere("extended from " + fromBits + "bits is not supported!");
        return null;
    }

    private AllocatableValue moveSp(AllocatableValue value) {
        return this.getLIRGeneratorTool().moveSp(value);
    }

    private static int getClampedShiftAmt(ShiftNode<?> op) {
        int clampMask = op.getShiftAmountMask();
        assert (clampMask == 63 || clampMask == 31);
        return op.getY().asJavaConstant().asInt() & clampMask;
    }

    protected ComplexMatchResult emitBinaryShift(AArch64ArithmeticOp op, ValueNode value, ShiftNode<?> shift) {
        AArch64Assembler.ShiftType shiftType = (AArch64Assembler.ShiftType)((Object)shiftTypeMap.get(shift.getClass()));
        assert (shiftType != null);
        assert (this.isNumericInteger(value, shift.getX()));
        return builder -> {
            Value a = this.operand(value);
            Value b = this.operand(shift.getX());
            Variable result = this.gen.newVariable(LIRKind.combine(a, b));
            AllocatableValue x = this.moveSp(this.gen.asAllocatable(a));
            AllocatableValue y = this.moveSp(this.gen.asAllocatable(b));
            int shiftAmount = AArch64NodeMatchRules.getClampedShiftAmt(shift);
            this.gen.append(new AArch64ArithmeticOp.BinaryShiftOp(op, result, x, y, shiftType, shiftAmount));
            return result;
        };
    }

    private ComplexMatchResult emitBitTestAndBranch(FixedNode trueSuccessor, FixedNode falseSuccessor, ValueNode value, double trueProbability, int nbits) {
        return builder -> {
            LabelRef trueDestination = this.getLIRBlock(trueSuccessor);
            LabelRef falseDestination = this.getLIRBlock(falseSuccessor);
            AllocatableValue src = this.moveSp(this.gen.asAllocatable(this.operand(value)));
            this.gen.append(new AArch64ControlFlow.BitTestAndBranchOp(trueDestination, falseDestination, src, trueProbability, nbits));
            return null;
        };
    }

    private ComplexMatchResult emitBitFieldHelper(JavaKind kind, AArch64BitFieldOp.BitFieldOpCode op, ValueNode value, int lsb, int width) {
        assert (this.isNumericInteger(value));
        assert (lsb + width <= kind.getBitCount());
        return builder -> {
            Value a = this.operand(value);
            LIRKind resultKind = LIRKind.fromJavaKind(this.gen.target().arch, kind);
            Variable result = this.gen.newVariable(resultKind);
            AllocatableValue src = this.moveSp(this.gen.asAllocatable(a));
            this.gen.append(new AArch64BitFieldOp(op, result, src, lsb, width));
            return result;
        };
    }

    private ComplexMatchResult emitBitFieldInsert(JavaKind kind, AArch64BitFieldOp.BitFieldOpCode op, ValueNode value, int lsb, int width) {
        assert (op == AArch64BitFieldOp.BitFieldOpCode.SBFIZ || op == AArch64BitFieldOp.BitFieldOpCode.UBFIZ);
        return this.emitBitFieldHelper(kind, op, value, lsb, width);
    }

    private ComplexMatchResult emitBitFieldExtract(JavaKind kind, AArch64BitFieldOp.BitFieldOpCode op, ValueNode value, int lsb, int width) {
        assert (op == AArch64BitFieldOp.BitFieldOpCode.SBFX || op == AArch64BitFieldOp.BitFieldOpCode.UBFX);
        return this.emitBitFieldHelper(kind, op, value, lsb, width);
    }

    private ComplexMatchResult emitExtendedAddSubShift(BinaryNode op, ValueNode x, ValueNode y, AArch64Assembler.ExtendType extType, int shiftAmt) {
        assert (op instanceof AddNode || op instanceof SubNode);
        return builder -> {
            AllocatableValue src1 = this.gen.asAllocatable(this.operand(x));
            AllocatableValue src2 = this.moveSp(this.gen.asAllocatable(this.operand(y)));
            Variable result = this.gen.newVariable(LIRKind.combine(this.operand(x), this.operand(y)));
            AArch64ArithmeticOp arithmeticOp = op instanceof AddNode ? AArch64ArithmeticOp.ADD : AArch64ArithmeticOp.SUB;
            this.gen.append(new AArch64ArithmeticOp.ExtendedAddSubShiftOp(arithmeticOp, result, src1, src2, extType, shiftAmt));
            return result;
        };
    }

    @MatchRules(value={@MatchRule(value="(Add=op x (LeftShift=lshift (SignExtend=ext y) Constant))"), @MatchRule(value="(Sub=op x (LeftShift=lshift (SignExtend=ext y) Constant))"), @MatchRule(value="(Add=op x (LeftShift=lshift (ZeroExtend=ext y) Constant))"), @MatchRule(value="(Sub=op x (LeftShift=lshift (ZeroExtend=ext y) Constant))")})
    public ComplexMatchResult mergeSignExtendByShiftIntoAddSub(BinaryNode op, LeftShiftNode lshift, ValueNode ext, ValueNode x, ValueNode y) {
        assert (this.isNumericInteger(lshift));
        int shiftAmt = AArch64NodeMatchRules.getClampedShiftAmt(lshift);
        if (!AArch64NodeMatchRules.isSupportedExtendedAddSubShift((IntegerConvertNode)ext, shiftAmt)) {
            return null;
        }
        AArch64Assembler.ExtendType extType = ext instanceof SignExtendNode ? AArch64NodeMatchRules.getSignExtendType(((SignExtendNode)ext).getInputBits()) : AArch64NodeMatchRules.getZeroExtendType(((ZeroExtendNode)ext).getInputBits());
        return this.emitExtendedAddSubShift(op, x, y, extType, shiftAmt);
    }

    @MatchRules(value={@MatchRule(value="(Add=op x (LeftShift=lshift (And y Constant=constant) Constant))"), @MatchRule(value="(Sub=op x (LeftShift=lshift (And y Constant=constant) Constant))")})
    public ComplexMatchResult mergeShiftDowncastIntoAddSub(BinaryNode op, LeftShiftNode lshift, ConstantNode constant, ValueNode x, ValueNode y) {
        assert (this.isNumericInteger(lshift, constant));
        int shiftAmt = AArch64NodeMatchRules.getClampedShiftAmt(lshift);
        if (shiftAmt > 4) {
            return null;
        }
        long mask = constant.asJavaConstant().asLong() & CodeUtil.mask((int)op.getStackKind().getBitCount());
        if (mask != 255L && mask != 65535L && mask != 0xFFFFFFFFL) {
            return null;
        }
        int numBits = 64 - Long.numberOfLeadingZeros(mask);
        return this.emitExtendedAddSubShift(op, x, y, AArch64NodeMatchRules.getZeroExtendType(numBits), shiftAmt);
    }

    @MatchRules(value={@MatchRule(value="(Add=op x (RightShift=signExt (LeftShift y Constant=shiftConst) Constant=shiftConst))"), @MatchRule(value="(Sub=op x (RightShift=signExt (LeftShift y Constant=shiftConst) Constant=shiftConst))")})
    public ComplexMatchResult mergePairShiftIntoAddSub(BinaryNode op, RightShiftNode signExt, ValueNode x, ValueNode y) {
        int signExtendAmt = AArch64NodeMatchRules.getClampedShiftAmt(signExt);
        int opSize = op.getStackKind().getBitCount();
        assert (opSize == 32 || opSize == 64);
        int remainingBits = opSize - signExtendAmt;
        if (remainingBits != 8 && remainingBits != 16 && remainingBits != 32) {
            return null;
        }
        return this.emitExtendedAddSubShift(op, x, y, AArch64NodeMatchRules.getSignExtendType(remainingBits), 0);
    }

    @MatchRules(value={@MatchRule(value="(Add=op x (LeftShift=outerShift (RightShift=signExt (LeftShift y Constant=shiftConst) Constant=shiftConst) Constant))"), @MatchRule(value="(Sub=op x (LeftShift=outerShift (RightShift=signExt (LeftShift y Constant=shiftConst) Constant=shiftConst) Constant))")})
    public ComplexMatchResult mergeShiftedPairShiftIntoAddSub(BinaryNode op, LeftShiftNode outerShift, RightShiftNode signExt, ValueNode x, ValueNode y) {
        int shiftAmt = AArch64NodeMatchRules.getClampedShiftAmt(outerShift);
        if (shiftAmt > 4) {
            return null;
        }
        int signExtendAmt = AArch64NodeMatchRules.getClampedShiftAmt(signExt);
        int opSize = op.getStackKind().getBitCount();
        assert (opSize == 32 || opSize == 64);
        int remainingBits = opSize - signExtendAmt;
        if (remainingBits != 8 && remainingBits != 16 && remainingBits != 32) {
            return null;
        }
        return this.emitExtendedAddSubShift(op, x, y, AArch64NodeMatchRules.getSignExtendType(remainingBits), shiftAmt);
    }

    @MatchRules(value={@MatchRule(value="(AArch64PointerAdd=addP base ZeroExtend)"), @MatchRule(value="(AArch64PointerAdd=addP base (LeftShift ZeroExtend Constant))")})
    public ComplexMatchResult extendedPointerAddShift(AArch64PointerAddNode addP) {
        int shiftAmt;
        ZeroExtendNode zeroExtend;
        ValueNode offset = addP.getOffset();
        if (offset instanceof ZeroExtendNode) {
            zeroExtend = (ZeroExtendNode)offset;
            shiftAmt = 0;
        } else {
            LeftShiftNode shift = (LeftShiftNode)offset;
            zeroExtend = (ZeroExtendNode)shift.getX();
            shiftAmt = AArch64NodeMatchRules.getClampedShiftAmt(shift);
        }
        if (!AArch64NodeMatchRules.isSupportedExtendedAddSubShift(zeroExtend, shiftAmt)) {
            return null;
        }
        int fromBits = zeroExtend.getInputBits();
        int toBits = zeroExtend.getResultBits();
        if (toBits != 64) {
            return null;
        }
        assert (fromBits <= toBits);
        AArch64Assembler.ExtendType extendType = AArch64NodeMatchRules.getZeroExtendType(fromBits);
        ValueNode base = addP.getBase();
        return builder -> {
            AllocatableValue x = this.gen.asAllocatable(this.operand(base));
            AllocatableValue y = this.moveSp(this.gen.asAllocatable(this.operand(zeroExtend.getValue())));
            AllocatableValue baseReference = LIRKind.derivedBaseFromValue(x);
            LIRKind kind = LIRKind.combineDerived(this.gen.getLIRKind(addP.stamp(NodeView.DEFAULT)), baseReference, null);
            Variable result = this.gen.newVariable(kind);
            this.gen.append(new AArch64ArithmeticOp.ExtendedAddSubShiftOp(AArch64ArithmeticOp.ADD, result, x, y, extendType, shiftAmt));
            return result;
        };
    }

    private ComplexMatchResult unsignedBitFieldHelper(JavaKind finalOpKind, BinaryNode shift, ValueNode value, ConstantNode maskNode, int andOpSize) {
        int shiftAmt;
        int shiftSize;
        long mask = maskNode.asJavaConstant().asLong() & CodeUtil.mask((int)andOpSize);
        if (!CodeUtil.isPowerOf2((long)(mask + 1L))) {
            return null;
        }
        int maskSize = 64 - Long.numberOfLeadingZeros(mask);
        int width = Math.min(maskSize, (shiftSize = shift.getStackKind().getBitCount()) - (shiftAmt = AArch64NodeMatchRules.getClampedShiftAmt((ShiftNode)shift)));
        if (width == finalOpKind.getBitCount()) {
            assert (maskSize == finalOpKind.getBitCount() && shiftAmt == 0);
            return builder -> this.operand(value);
        }
        if (shift instanceof UnsignedRightShiftNode) {
            return this.emitBitFieldExtract(finalOpKind, AArch64BitFieldOp.BitFieldOpCode.UBFX, value, shiftAmt, width);
        }
        return this.emitBitFieldInsert(finalOpKind, AArch64BitFieldOp.BitFieldOpCode.UBFIZ, value, shiftAmt, width);
    }

    @MatchRules(value={@MatchRule(value="(And (UnsignedRightShift=shift value Constant) Constant=a)"), @MatchRule(value="(LeftShift=shift (And value Constant=a) Constant)")})
    public ComplexMatchResult unsignedBitField(BinaryNode shift, ValueNode value, ConstantNode a) {
        return this.unsignedBitFieldHelper(shift.getStackKind(), shift, value, a, shift.getStackKind().getBitCount());
    }

    @MatchRules(value={@MatchRule(value="(LeftShift=shift (ZeroExtend=extend (And value Constant=a)) Constant)"), @MatchRule(value="(ZeroExtend=extend (And (UnsignedRightShift=shift value Constant) Constant=a))"), @MatchRule(value="(ZeroExtend=extend (LeftShift=shift (And value Constant=a) Constant))")})
    public ComplexMatchResult unsignedExtBitField(ZeroExtendNode extend, BinaryNode shift, ValueNode value, ConstantNode a) {
        return this.unsignedBitFieldHelper(extend.getStackKind(), shift, value, a, extend.getInputBits());
    }

    @MatchRule(value="(LeftShift=shift (SignExtend value) Constant)")
    public ComplexMatchResult signedBitField(LeftShiftNode shift, ValueNode value) {
        assert (this.isNumericInteger(shift));
        SignExtendNode extend = (SignExtendNode)shift.getX();
        int inputBits = extend.getInputBits();
        int resultBits = extend.getResultBits();
        JavaKind kind = shift.getStackKind();
        assert (kind.getBitCount() == resultBits);
        int lsb = AArch64NodeMatchRules.getClampedShiftAmt(shift);
        int width = Math.min(inputBits, resultBits - lsb);
        assert (width >= 1 && width <= resultBits - lsb);
        return this.emitBitFieldInsert(kind, AArch64BitFieldOp.BitFieldOpCode.SBFIZ, value, lsb, width);
    }

    @MatchRules(value={@MatchRule(value="(RightShift=rshift (LeftShift=lshift value Constant) Constant)"), @MatchRule(value="(UnsignedRightShift=rshift (LeftShift=lshift value Constant) Constant)")})
    public ComplexMatchResult bitFieldMove(BinaryNode rshift, LeftShiftNode lshift, ValueNode value) {
        assert (this.isNumericInteger(rshift));
        JavaKind opKind = rshift.getStackKind();
        int opSize = opKind.getBitCount();
        int lshiftAmt = AArch64NodeMatchRules.getClampedShiftAmt(lshift);
        int rshiftAmt = AArch64NodeMatchRules.getClampedShiftAmt((ShiftNode)rshift);
        int width = opSize - Math.max(lshiftAmt, rshiftAmt);
        assert (width > 1 || width <= opSize);
        if (width == opSize) {
            return builder -> this.operand(value);
        }
        if (lshiftAmt > rshiftAmt) {
            int lsb = lshiftAmt - rshiftAmt;
            AArch64BitFieldOp.BitFieldOpCode op = rshift instanceof RightShiftNode ? AArch64BitFieldOp.BitFieldOpCode.SBFIZ : AArch64BitFieldOp.BitFieldOpCode.UBFIZ;
            return this.emitBitFieldInsert(opKind, op, value, lsb, width);
        }
        int lsb = rshiftAmt - lshiftAmt;
        AArch64BitFieldOp.BitFieldOpCode op = rshift instanceof RightShiftNode ? AArch64BitFieldOp.BitFieldOpCode.SBFX : AArch64BitFieldOp.BitFieldOpCode.UBFX;
        return this.emitBitFieldExtract(opKind, op, value, lsb, width);
    }

    @MatchRules(value={@MatchRule(value="(Or=op (LeftShift=x src Constant) (UnsignedRightShift=y src Constant))"), @MatchRule(value="(Or=op (UnsignedRightShift=x src Constant) (LeftShift=y src Constant))"), @MatchRule(value="(Add=op (LeftShift=x src Constant) (UnsignedRightShift=y src Constant))"), @MatchRule(value="(Add=op (UnsignedRightShift=x src Constant) (LeftShift=y src Constant))")})
    public ComplexMatchResult rotationConstant(ValueNode op, ValueNode x, ValueNode y, ValueNode src) {
        int shiftAmt2;
        assert (this.isNumericInteger(src));
        assert (src.getStackKind() == op.getStackKind() && op.getStackKind() == x.getStackKind());
        int shiftAmt1 = AArch64NodeMatchRules.getClampedShiftAmt((ShiftNode)x);
        if (shiftAmt1 + (shiftAmt2 = AArch64NodeMatchRules.getClampedShiftAmt((ShiftNode)y)) == 0 && op instanceof OrNode) {
            assert (shiftAmt1 == 0 && shiftAmt2 == 0);
            return builder -> this.operand(src);
        }
        if (src.getStackKind().getBitCount() == shiftAmt1 + shiftAmt2) {
            return builder -> {
                AllocatableValue a = this.moveSp(this.gen.asAllocatable(this.operand(src)));
                PrimitiveConstant b = JavaConstant.forInt((int)(x instanceof LeftShiftNode ? shiftAmt2 : shiftAmt1));
                Variable result = this.gen.newVariable(LIRKind.combine(new Value[]{a}));
                this.getArithmeticLIRGenerator().emitBinaryConst(result, AArch64ArithmeticOp.ROR, a, (JavaConstant)b);
                return result;
            };
        }
        return null;
    }

    @MatchRules(value={@MatchRule(value="(Or (LeftShift=x src shiftAmount) (UnsignedRightShift src (Sub=y Constant shiftAmount)))"), @MatchRule(value="(Or (UnsignedRightShift=x src shiftAmount) (LeftShift src (Sub=y Constant shiftAmount)))"), @MatchRule(value="(Or (LeftShift=x src (Negate shiftAmount)) (UnsignedRightShift src (Add=y Constant shiftAmount)))"), @MatchRule(value="(Or (UnsignedRightShift=x src (Negate shiftAmount)) (LeftShift src (Add=y Constant shiftAmount)))"), @MatchRule(value="(Or (LeftShift=x src shiftAmount) (UnsignedRightShift src (Negate=y shiftAmount)))"), @MatchRule(value="(Or (UnsignedRightShift=x src shiftAmount) (LeftShift src (Negate=y shiftAmount)))")})
    public ComplexMatchResult rotationExpander(ValueNode src, ValueNode shiftAmount, ValueNode x, ValueNode y) {
        assert (this.isNumericInteger(src));
        assert (shiftAmount.getStackKind().getBitCount() == 32);
        if (y instanceof SubNode || y instanceof AddNode) {
            BinaryNode binary = (BinaryNode)y;
            ConstantNode delta = (ConstantNode)(binary.getX() != shiftAmount ? binary.getX() : binary.getY());
            int opSize = src.getStackKind().getBitCount();
            assert (opSize == 32 || opSize == 64);
            long clampedDelta = delta.asJavaConstant().asInt() & opSize - 1;
            if (clampedDelta != 0L) {
                return null;
            }
        }
        return builder -> {
            Value a = this.operand(src);
            Value b = y instanceof AddNode ? (x instanceof LeftShiftNode ? this.operand(shiftAmount) : this.getArithmeticLIRGenerator().emitNegate(this.operand(shiftAmount), false)) : (x instanceof LeftShiftNode ? this.getArithmeticLIRGenerator().emitNegate(this.operand(shiftAmount), false) : this.operand(shiftAmount));
            return this.getArithmeticLIRGenerator().emitBinary(LIRKind.combine(a, b), AArch64ArithmeticOp.ROR, false, a, b);
        };
    }

    @MatchRules(value={@MatchRule(value="(Add=binary a (LeftShift=shift b Constant))"), @MatchRule(value="(Add=binary a (RightShift=shift b Constant))"), @MatchRule(value="(Add=binary a (UnsignedRightShift=shift b Constant))"), @MatchRule(value="(Sub=binary a (LeftShift=shift b Constant))"), @MatchRule(value="(Sub=binary a (RightShift=shift b Constant))"), @MatchRule(value="(Sub=binary a (UnsignedRightShift=shift b Constant))")})
    public ComplexMatchResult addSubShift(BinaryNode binary, ValueNode a, BinaryNode shift) {
        AArch64ArithmeticOp op = (AArch64ArithmeticOp)((Object)binaryOpMap.get(binary.getClass()));
        assert (op != null);
        return this.emitBinaryShift(op, a, (ShiftNode)shift);
    }

    @MatchRules(value={@MatchRule(value="(And=binary a (LeftShift=shift b Constant))"), @MatchRule(value="(And=binary a (RightShift=shift b Constant))"), @MatchRule(value="(And=binary a (UnsignedRightShift=shift b Constant))"), @MatchRule(value="(Or=binary a (LeftShift=shift b Constant))"), @MatchRule(value="(Or=binary a (RightShift=shift b Constant))"), @MatchRule(value="(Or=binary a (UnsignedRightShift=shift b Constant))"), @MatchRule(value="(Xor=binary a (LeftShift=shift b Constant))"), @MatchRule(value="(Xor=binary a (RightShift=shift b Constant))"), @MatchRule(value="(Xor=binary a (UnsignedRightShift=shift b Constant))"), @MatchRule(value="(And=binary a (Not (LeftShift=shift b Constant)))"), @MatchRule(value="(And=binary a (Not (RightShift=shift b Constant)))"), @MatchRule(value="(And=binary a (Not (UnsignedRightShift=shift b Constant)))"), @MatchRule(value="(Or=binary a (Not (LeftShift=shift b Constant)))"), @MatchRule(value="(Or=binary a (Not (RightShift=shift b Constant)))"), @MatchRule(value="(Or=binary a (Not (UnsignedRightShift=shift b Constant)))"), @MatchRule(value="(Xor=binary a (Not (LeftShift=shift b Constant)))"), @MatchRule(value="(Xor=binary a (Not (RightShift=shift b Constant)))"), @MatchRule(value="(Xor=binary a (Not (UnsignedRightShift=shift b Constant)))")})
    public ComplexMatchResult logicShift(BinaryNode binary, ValueNode a, BinaryNode shift) {
        ValueNode operand = binary.getX() == a ? binary.getY() : binary.getX();
        AArch64ArithmeticOp op = operand instanceof NotNode ? (AArch64ArithmeticOp)((Object)logicalNotOpMap.get(binary.getClass())) : (AArch64ArithmeticOp)((Object)binaryOpMap.get(binary.getClass()));
        assert (op != null);
        return this.emitBinaryShift(op, a, (ShiftNode)shift);
    }

    @MatchRules(value={@MatchRule(value="(Negate (UnsignedRightShift=shift a Constant=b))"), @MatchRule(value="(Negate (RightShift=shift a Constant=b))"), @MatchRule(value="(Negate (LeftShift=shift a Constant=b))")})
    public ComplexMatchResult negShift(BinaryNode shift, ValueNode a, ConstantNode b) {
        assert (this.isNumericInteger(a, b));
        int shiftAmt = AArch64NodeMatchRules.getClampedShiftAmt((ShiftNode)shift);
        AArch64Assembler.ShiftType shiftType = (AArch64Assembler.ShiftType)((Object)shiftTypeMap.get(shift.getClass()));
        return builder -> {
            AllocatableValue src = this.moveSp(this.gen.asAllocatable(this.operand(a)));
            LIRKind kind = LIRKind.combine(this.operand(a));
            Variable result = this.gen.newVariable(kind);
            this.gen.append(new AArch64ArithmeticOp.BinaryShiftOp(AArch64ArithmeticOp.SUB, result, (AllocatableValue)AArch64.zr.asValue((ValueKind)kind), src, shiftType, shiftAmt));
            return result;
        };
    }

    @MatchRules(value={@MatchRule(value="(And=logic value1 (Not=not value2))"), @MatchRule(value="(Or=logic value1 (Not=not value2))")})
    public final ComplexMatchResult bitwiseLogicNot(BinaryNode logic, NotNode not) {
        assert (this.isNumericInteger(logic));
        AArch64ArithmeticOp op = (AArch64ArithmeticOp)((Object)logicalNotOpMap.get(logic.getClass()));
        assert (op != null);
        ValueNode src1 = logic.getX() == not ? logic.getY() : logic.getX();
        ValueNode src2 = not.getValue();
        return builder -> {
            Value a = this.operand(src1);
            Value b = this.operand(src2);
            LIRKind resultKind = LIRKind.combine(a, b);
            return this.getArithmeticLIRGenerator().emitBinary(resultKind, op, false, a, b);
        };
    }

    @MatchRules(value={@MatchRule(value="(Not (Xor value1 value2))"), @MatchRule(value="(Xor value1 (Not value2))"), @MatchRule(value="(Xor (Not value1) value2)")})
    public ComplexMatchResult bitwiseNotXor(ValueNode value1, ValueNode value2) {
        return builder -> {
            Value a = this.operand(value1);
            Value b = this.operand(value2);
            LIRKind resultKind = LIRKind.combine(a, b);
            return this.getArithmeticLIRGenerator().emitBinary(resultKind, AArch64ArithmeticOp.EON, true, a, b);
        };
    }

    private static boolean isI2LMultiply(MulNode mul, SignExtendNode x, SignExtendNode y) {
        if (mul.getStackKind() == JavaKind.Long) {
            assert (x.getResultBits() == 64 && y.getResultBits() == 64);
            return x.getInputBits() == 32 && y.getInputBits() == 32;
        }
        return false;
    }

    @MatchRules(value={@MatchRule(value="(Add=binary (Mul=mul (SignExtend a) (SignExtend b)) c)"), @MatchRule(value="(Sub=binary c (Mul=mul (SignExtend a) (SignExtend b)))")})
    public ComplexMatchResult signedMultiplyAddSubLong(BinaryNode binary, MulNode mul, ValueNode a, ValueNode b, ValueNode c) {
        assert (this.isNumericInteger(binary, mul, a, b, c));
        if (AArch64NodeMatchRules.isI2LMultiply(mul, (SignExtendNode)mul.getX(), (SignExtendNode)mul.getY())) {
            if (binary instanceof AddNode) {
                return builder -> this.getArithmeticLIRGenerator().emitIntegerMAdd(this.operand(a), this.operand(b), this.operand(c), true);
            }
            return builder -> this.getArithmeticLIRGenerator().emitIntegerMSub(this.operand(a), this.operand(b), this.operand(c), true);
        }
        return null;
    }

    @MatchRules(value={@MatchRule(value="(Negate (Mul=mul (SignExtend=ext1 a) (SignExtend=ext2 b)))"), @MatchRule(value="(Mul=mul (Negate (SignExtend=ext1 a)) (SignExtend=ext2 b))")})
    public ComplexMatchResult signedMultiplyNegLong(MulNode mul, SignExtendNode ext1, SignExtendNode ext2, ValueNode a, ValueNode b) {
        assert (this.isNumericInteger(mul, ext1, ext2, a, b));
        if (AArch64NodeMatchRules.isI2LMultiply(mul, ext1, ext2)) {
            LIRKind resultKind = LIRKind.fromJavaKind(this.gen.target().arch, JavaKind.Long);
            return builder -> this.getArithmeticLIRGenerator().emitBinary(resultKind, AArch64ArithmeticOp.SMNEGL, true, this.operand(a), this.operand(b));
        }
        return null;
    }

    @MatchRule(value="(Mul=mul (SignExtend a) (SignExtend b))")
    public ComplexMatchResult signedMultiplyLong(MulNode mul, ValueNode a, ValueNode b) {
        assert (this.isNumericInteger(mul, a, b));
        if (AArch64NodeMatchRules.isI2LMultiply(mul, (SignExtendNode)mul.getX(), (SignExtendNode)mul.getY())) {
            LIRKind resultKind = LIRKind.fromJavaKind(this.gen.target().arch, JavaKind.Long);
            return builder -> this.getArithmeticLIRGenerator().emitBinary(resultKind, AArch64ArithmeticOp.SMULL, true, this.operand(a), this.operand(b));
        }
        return null;
    }

    @MatchRules(value={@MatchRule(value="(Add=op x (And y Constant=constant))"), @MatchRule(value="(Sub=op x (And y Constant=constant))")})
    public ComplexMatchResult mergeDowncastIntoAddSub(BinaryNode op, ValueNode x, ValueNode y, ConstantNode constant) {
        assert (this.isNumericInteger(constant));
        long mask = constant.asJavaConstant().asLong() & CodeUtil.mask((int)op.getStackKind().getBitCount());
        if (mask != 255L && mask != 65535L && mask != 0xFFFFFFFFL) {
            return null;
        }
        int numBits = 64 - Long.numberOfLeadingZeros(mask);
        return this.emitExtendedAddSubShift(op, x, y, AArch64NodeMatchRules.getZeroExtendType(numBits), 0);
    }

    @MatchRules(value={@MatchRule(value="(Add=op x (SignExtend=ext y))"), @MatchRule(value="(Sub=op x (SignExtend=ext y))"), @MatchRule(value="(Add=op x (ZeroExtend=ext y))"), @MatchRule(value="(Sub=op x (ZeroExtend=ext y))")})
    public ComplexMatchResult mergeSignExtendIntoAddSub(BinaryNode op, UnaryNode ext, ValueNode x, ValueNode y) {
        if (!AArch64NodeMatchRules.isSupportedExtendedAddSubShift((IntegerConvertNode)ext, 0)) {
            return null;
        }
        AArch64Assembler.ExtendType extType = ext instanceof SignExtendNode ? AArch64NodeMatchRules.getSignExtendType(((SignExtendNode)ext).getInputBits()) : AArch64NodeMatchRules.getZeroExtendType(((ZeroExtendNode)ext).getInputBits());
        return this.emitExtendedAddSubShift(op, x, y, extType, 0);
    }

    @MatchRules(value={@MatchRule(value="(Mul (Negate a) b)"), @MatchRule(value="(Negate (Mul a b))")})
    public final ComplexMatchResult multiplyNegate(ValueNode a, ValueNode b) {
        if (this.isNumericInteger(a, b)) {
            return builder -> this.getArithmeticLIRGenerator().emitMNeg(this.operand(a), this.operand(b));
        }
        return null;
    }

    @MatchRules(value={@MatchRule(value="(Add=binary (Mul a b) c)"), @MatchRule(value="(Sub=binary c (Mul a b))")})
    public final ComplexMatchResult multiplyAddSub(BinaryNode binary, ValueNode a, ValueNode b, ValueNode c) {
        if (!this.isNumericInteger(a, b, c)) {
            return null;
        }
        if (binary instanceof AddNode) {
            return builder -> this.getArithmeticLIRGenerator().emitIntegerMAdd(this.operand(a), this.operand(b), this.operand(c), false);
        }
        return builder -> this.getArithmeticLIRGenerator().emitIntegerMSub(this.operand(a), this.operand(b), this.operand(c), false);
    }

    @MatchRule(value="(If (IntegerTest value Constant=a))")
    public ComplexMatchResult testBitAndBranch(IfNode root, ValueNode value, ConstantNode a) {
        long constant;
        if (this.isNumericInteger(value) && Long.bitCount(constant = a.asJavaConstant().asLong()) == 1) {
            return this.emitBitTestAndBranch(root.trueSuccessor(), root.falseSuccessor(), value, root.getTrueSuccessorProbability(), Long.numberOfTrailingZeros(constant));
        }
        return null;
    }

    @MatchRule(value="(If (IntegerLessThan=lessNode x Constant=y))")
    public ComplexMatchResult checkNegativeAndBranch(IfNode root, IntegerLessThanNode lessNode, ValueNode x, ConstantNode y) {
        assert (this.isNumericInteger(x));
        if (y.isJavaConstant() && 0L == y.asJavaConstant().asLong() && lessNode.condition().equals((Object)CanonicalCondition.LT)) {
            return this.emitBitTestAndBranch(root.falseSuccessor(), root.trueSuccessor(), x, 1.0 - root.getTrueSuccessorProbability(), x.getStackKind().getBitCount() - 1);
        }
        return null;
    }

    @MatchRule(value="(FloatConvert=a (Sqrt (FloatConvert=b c)))")
    public final ComplexMatchResult floatSqrt(FloatConvertNode a, FloatConvertNode b, ValueNode c) {
        if (this.isNumericFloat(a, c) && a.getFloatConvert() == FloatConvert.D2F && b.getFloatConvert() == FloatConvert.F2D) {
            return builder -> this.getArithmeticLIRGenerator().emitMathSqrt(this.operand(c));
        }
        return null;
    }

    @MatchRule(value="(Conditional (IntegerBelow x y) Constant=cm1 (Conditional (IntegerEquals x y) Constant=c0 Constant=c1))")
    public ComplexMatchResult normalizedIntegerCompare(ValueNode x, ValueNode y, ConstantNode cm1, ConstantNode c0, ConstantNode c1) {
        if (cm1.getStackKind() == JavaKind.Int && cm1.asJavaConstant().asInt() == -1 && c0.getStackKind() == JavaKind.Int && c0.asJavaConstant().asInt() == 0 && c1.getStackKind() == JavaKind.Int && c1.asJavaConstant().asInt() == 1) {
            return builder -> this.getArithmeticLIRGenerator().emitNormalizedUnsignedCompare(this.operand(x), this.operand(y));
        }
        return null;
    }

    @Override
    public AArch64LIRGenerator getLIRGeneratorTool() {
        return (AArch64LIRGenerator)this.gen;
    }

    protected AArch64ArithmeticLIRGenerator getArithmeticLIRGenerator() {
        return (AArch64ArithmeticLIRGenerator)this.getLIRGeneratorTool().getArithmetic();
    }

    static {
        binaryOpMap.put(AddNode.class, (Object)AArch64ArithmeticOp.ADD);
        binaryOpMap.put(SubNode.class, (Object)AArch64ArithmeticOp.SUB);
        binaryOpMap.put(MulNode.class, (Object)AArch64ArithmeticOp.MUL);
        binaryOpMap.put(AndNode.class, (Object)AArch64ArithmeticOp.AND);
        binaryOpMap.put(OrNode.class, (Object)AArch64ArithmeticOp.OR);
        binaryOpMap.put(XorNode.class, (Object)AArch64ArithmeticOp.XOR);
        binaryOpMap.put(LeftShiftNode.class, (Object)AArch64ArithmeticOp.LSL);
        binaryOpMap.put(RightShiftNode.class, (Object)AArch64ArithmeticOp.ASR);
        binaryOpMap.put(UnsignedRightShiftNode.class, (Object)AArch64ArithmeticOp.LSR);
        bitFieldOpMap = EconomicMap.create((Equivalence)Equivalence.IDENTITY, (int)2);
        bitFieldOpMap.put(UnsignedRightShiftNode.class, (Object)AArch64BitFieldOp.BitFieldOpCode.UBFX);
        bitFieldOpMap.put(LeftShiftNode.class, (Object)AArch64BitFieldOp.BitFieldOpCode.UBFIZ);
        logicalNotOpMap = EconomicMap.create((Equivalence)Equivalence.IDENTITY, (int)3);
        logicalNotOpMap.put(AndNode.class, (Object)AArch64ArithmeticOp.BIC);
        logicalNotOpMap.put(OrNode.class, (Object)AArch64ArithmeticOp.ORN);
        logicalNotOpMap.put(XorNode.class, (Object)AArch64ArithmeticOp.EON);
        shiftTypeMap = EconomicMap.create((Equivalence)Equivalence.IDENTITY, (int)3);
        shiftTypeMap.put(LeftShiftNode.class, (Object)AArch64Assembler.ShiftType.LSL);
        shiftTypeMap.put(RightShiftNode.class, (Object)AArch64Assembler.ShiftType.ASR);
        shiftTypeMap.put(UnsignedRightShiftNode.class, (Object)AArch64Assembler.ShiftType.LSR);
    }
}

