/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.core.amd64;

import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.code.RegisterValue;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.core.amd64.AMD64ArithmeticLIRGenerator;
import org.graalvm.compiler.core.amd64.AMD64LIRGenerator;
import org.graalvm.compiler.core.amd64.AMD64NodeMatchRules;
import org.graalvm.compiler.core.gen.NodeLIRBuilder;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.lir.LIRFrameState;
import org.graalvm.compiler.lir.amd64.AMD64Call;
import org.graalvm.compiler.lir.gen.LIRGeneratorTool;
import org.graalvm.compiler.nodes.DeoptimizingNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.IfNode;
import org.graalvm.compiler.nodes.IndirectCallTargetNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.IntegerDivRemNode;

public abstract class AMD64NodeLIRBuilder
extends NodeLIRBuilder {
    public AMD64NodeLIRBuilder(StructuredGraph graph, LIRGeneratorTool gen, AMD64NodeMatchRules nodeMatchRules) {
        super(graph, gen, nodeMatchRules);
    }

    @Override
    protected void emitIndirectCall(IndirectCallTargetNode callTarget, Value result, Value[] parameters, Value[] temps, LIRFrameState callState) {
        Value targetAddressSrc = this.operand(callTarget.computedAddress());
        RegisterValue targetAddress = AMD64.rax.asValue(targetAddressSrc.getValueKind());
        this.gen.emitMove((AllocatableValue)targetAddress, targetAddressSrc);
        this.append(new AMD64Call.IndirectCallOp(callTarget.targetMethod(), result, parameters, temps, (Value)targetAddress, callState));
    }

    @Override
    protected boolean peephole(ValueNode valueNode) {
        if (valueNode instanceof IntegerDivRemNode) {
            AMD64ArithmeticLIRGenerator arithmeticGen = (AMD64ArithmeticLIRGenerator)this.gen.getArithmetic();
            IntegerDivRemNode divRem = (IntegerDivRemNode)valueNode;
            FixedNode node = divRem.next();
            while (true) {
                if (node instanceof IfNode) {
                    IfNode ifNode = (IfNode)node;
                    double probability = ifNode.getTrueSuccessorProbability();
                    if (probability == 1.0) {
                        node = ifNode.trueSuccessor();
                    } else {
                        if (probability != 0.0) break;
                        node = ifNode.falseSuccessor();
                    }
                } else if (!(node instanceof FixedWithNextNode)) break;
                FixedWithNextNode fixedWithNextNode = (FixedWithNextNode)node;
                if (fixedWithNextNode instanceof IntegerDivRemNode) {
                    IntegerDivRemNode otherDivRem = (IntegerDivRemNode)fixedWithNextNode;
                    if (divRem.getOp() != otherDivRem.getOp() && divRem.getType() == otherDivRem.getType() && otherDivRem.getX() == divRem.getX() && otherDivRem.getY() == divRem.getY() && !this.hasOperand(otherDivRem)) {
                        Value[] results = switch (divRem.getType()) {
                            case IntegerDivRemNode.Type.SIGNED -> arithmeticGen.emitSignedDivRem(this.operand(divRem.getX()), this.operand(divRem.getY()), this.state((DeoptimizingNode)((Object)valueNode)));
                            case IntegerDivRemNode.Type.UNSIGNED -> arithmeticGen.emitUnsignedDivRem(this.operand(divRem.getX()), this.operand(divRem.getY()), this.state((DeoptimizingNode)((Object)valueNode)));
                            default -> throw GraalError.shouldNotReachHere();
                        };
                        switch (divRem.getOp()) {
                            case DIV: {
                                assert (otherDivRem.getOp() == IntegerDivRemNode.Op.REM);
                                this.setResult(divRem, results[0]);
                                this.setResult(otherDivRem, results[1]);
                                break;
                            }
                            case REM: {
                                assert (otherDivRem.getOp() == IntegerDivRemNode.Op.DIV);
                                this.setResult(divRem, results[1]);
                                this.setResult(otherDivRem, results[0]);
                                break;
                            }
                            default: {
                                throw GraalError.shouldNotReachHere();
                            }
                        }
                        return true;
                    }
                }
                node = fixedWithNextNode.next();
            }
        }
        return false;
    }

    @Override
    public AMD64LIRGenerator getLIRGeneratorTool() {
        return (AMD64LIRGenerator)this.gen;
    }
}

