/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.core.amd64;

import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.amd64.AMD64Kind;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.PlatformKind;
import jdk.vm.ci.meta.Value;
import jdk.vm.ci.meta.ValueKind;
import org.graalvm.compiler.asm.amd64.AMD64Assembler;
import org.graalvm.compiler.asm.amd64.AMD64BaseAssembler;
import org.graalvm.compiler.core.amd64.AMD64ArithmeticLIRGenerator;
import org.graalvm.compiler.core.amd64.AMD64LIRGenerator;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.core.common.NumUtil;
import org.graalvm.compiler.core.common.calc.CanonicalCondition;
import org.graalvm.compiler.core.common.calc.Condition;
import org.graalvm.compiler.core.common.memory.MemoryExtendKind;
import org.graalvm.compiler.core.common.memory.MemoryOrderMode;
import org.graalvm.compiler.core.gen.NodeLIRBuilder;
import org.graalvm.compiler.core.gen.NodeMatchRules;
import org.graalvm.compiler.core.match.ComplexMatchResult;
import org.graalvm.compiler.core.match.MatchRule;
import org.graalvm.compiler.core.match.MatchRules;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.lir.LIRFrameState;
import org.graalvm.compiler.lir.LIRValueUtil;
import org.graalvm.compiler.lir.LabelRef;
import org.graalvm.compiler.lir.amd64.AMD64AddressValue;
import org.graalvm.compiler.lir.amd64.AMD64BinaryConsumer;
import org.graalvm.compiler.lir.amd64.AMD64ControlFlow;
import org.graalvm.compiler.lir.amd64.AMD64UnaryConsumer;
import org.graalvm.compiler.lir.gen.LIRGeneratorTool;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.DeoptimizingNode;
import org.graalvm.compiler.nodes.IfNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.CompareNode;
import org.graalvm.compiler.nodes.calc.FloatConvertNode;
import org.graalvm.compiler.nodes.calc.LeftShiftNode;
import org.graalvm.compiler.nodes.calc.NarrowNode;
import org.graalvm.compiler.nodes.calc.ReinterpretNode;
import org.graalvm.compiler.nodes.calc.SignExtendNode;
import org.graalvm.compiler.nodes.calc.UnsignedRightShiftNode;
import org.graalvm.compiler.nodes.calc.ZeroExtendNode;
import org.graalvm.compiler.nodes.java.LogicCompareAndSwapNode;
import org.graalvm.compiler.nodes.java.ValueCompareAndSwapNode;
import org.graalvm.compiler.nodes.memory.AddressableMemoryAccess;
import org.graalvm.compiler.nodes.memory.LIRLowerableAccess;
import org.graalvm.compiler.nodes.memory.MemoryAccess;
import org.graalvm.compiler.nodes.memory.ReadNode;
import org.graalvm.compiler.nodes.memory.WriteNode;
import org.graalvm.compiler.nodes.util.GraphUtil;

public class AMD64NodeMatchRules
extends NodeMatchRules {
    public AMD64NodeMatchRules(LIRGeneratorTool gen) {
        super(gen);
    }

    protected LIRFrameState getState(MemoryAccess access) {
        if (access instanceof DeoptimizingNode) {
            return this.state((DeoptimizingNode)((Object)access));
        }
        return null;
    }

    protected AMD64Kind getMemoryKind(LIRLowerableAccess access) {
        return (AMD64Kind)this.getLirKind(access).getPlatformKind();
    }

    protected LIRKind getLirKind(LIRLowerableAccess access) {
        return this.gen.getLIRKind(access.getAccessStamp(NodeView.DEFAULT));
    }

    protected AMD64BaseAssembler.OperandSize getMemorySize(LIRLowerableAccess access) {
        switch (this.getMemoryKind(access)) {
            case BYTE: {
                return AMD64BaseAssembler.OperandSize.BYTE;
            }
            case WORD: {
                return AMD64BaseAssembler.OperandSize.WORD;
            }
            case DWORD: {
                return AMD64BaseAssembler.OperandSize.DWORD;
            }
            case QWORD: {
                return AMD64BaseAssembler.OperandSize.QWORD;
            }
            case SINGLE: {
                return AMD64BaseAssembler.OperandSize.SS;
            }
            case DOUBLE: {
                return AMD64BaseAssembler.OperandSize.SD;
            }
        }
        throw GraalError.shouldNotReachHere("unsupported memory access type " + this.getMemoryKind(access));
    }

    protected ComplexMatchResult emitCompareBranchMemory(final IfNode ifNode, final CompareNode compare, final ValueNode value, final LIRLowerableAccess access) {
        Condition cond = compare.condition().asCondition();
        final AMD64Kind kind = this.getMemoryKind(access);
        boolean matchedAsConstant = false;
        if (value.isConstant()) {
            JavaConstant constant = value.asJavaConstant();
            if (constant != null) {
                if (kind == AMD64Kind.QWORD && !constant.getJavaKind().isObject() && !NumUtil.isInt(constant.asLong())) {
                    return null;
                }
                boolean bl = matchedAsConstant = kind == AMD64Kind.QWORD && !constant.getJavaKind().isObject() && NumUtil.isInt(constant.asLong());
            }
            if (kind == AMD64Kind.DWORD) {
                matchedAsConstant = true;
            }
            if (kind.isXMM()) {
                ifNode.getDebug().log("Skipping constant compares for float kinds");
                return null;
            }
        }
        final boolean matchedAsConstantFinal = matchedAsConstant;
        final Condition finalCondition = GraphUtil.unproxify(compare.getX()) == access ? cond.mirror() : cond;
        return new ComplexMatchResult(){

            @Override
            public Value evaluate(NodeLIRBuilder builder) {
                LabelRef trueLabel = AMD64NodeMatchRules.this.getLIRBlock(ifNode.trueSuccessor());
                LabelRef falseLabel = AMD64NodeMatchRules.this.getLIRBlock(ifNode.falseSuccessor());
                boolean unorderedIsTrue = compare.unorderedIsTrue();
                double trueLabelProbability = ifNode.probability(ifNode.trueSuccessor());
                Value other = AMD64NodeMatchRules.this.operand(value);
                assert (!matchedAsConstantFinal || !LIRValueUtil.isVariable(other)) : "expected constant value " + value;
                AMD64AddressValue address = (AMD64AddressValue)AMD64NodeMatchRules.this.operand(access.getAddress());
                AMD64NodeMatchRules.this.getLIRGeneratorTool().emitCompareBranchMemory(kind, other, address, AMD64NodeMatchRules.this.getState(access), finalCondition, unorderedIsTrue, trueLabel, falseLabel, trueLabelProbability);
                return null;
            }
        };
    }

    private ComplexMatchResult emitIntegerTestBranchMemory(IfNode x, ValueNode value, LIRLowerableAccess access) {
        AMD64BaseAssembler.OperandSize size;
        LabelRef trueLabel = this.getLIRBlock(x.trueSuccessor());
        LabelRef falseLabel = this.getLIRBlock(x.falseSuccessor());
        double trueLabelProbability = x.probability(x.trueSuccessor());
        AMD64Kind kind = this.getMemoryKind(access);
        AMD64BaseAssembler.OperandSize operandSize = size = kind == AMD64Kind.QWORD ? AMD64BaseAssembler.OperandSize.QWORD : AMD64BaseAssembler.OperandSize.DWORD;
        if (kind.getVectorLength() > 1) {
            return null;
        }
        if (value.isJavaConstant()) {
            JavaConstant constant = value.asJavaConstant();
            if (kind == AMD64Kind.QWORD && !NumUtil.isInt(constant.asLong())) {
                return null;
            }
            return builder -> {
                AMD64AddressValue address = (AMD64AddressValue)this.operand(access.getAddress());
                this.gen.append(new AMD64ControlFlow.TestConstBranchOp(size, address, (int)constant.asLong(), this.getState(access), Condition.EQ, trueLabel, falseLabel, trueLabelProbability));
                return null;
            };
        }
        return builder -> {
            AMD64AddressValue address = (AMD64AddressValue)this.operand(access.getAddress());
            this.gen.append(new AMD64ControlFlow.TestBranchOp(size, this.gen.asAllocatable(this.operand(value)), address, this.getState(access), Condition.EQ, trueLabel, falseLabel, trueLabelProbability));
            return null;
        };
    }

    protected ComplexMatchResult emitConvertMemoryOp(PlatformKind kind, AMD64Assembler.AMD64RMOp op, AMD64BaseAssembler.OperandSize size, AddressableMemoryAccess access, ValueKind<?> addressKind) {
        return builder -> {
            AMD64AddressValue address = (AMD64AddressValue)this.operand(access.getAddress());
            LIRFrameState state = this.getState(access);
            if (addressKind != null) {
                address = address.withKind(addressKind);
            }
            return this.getArithmeticLIRGenerator().emitConvertMemoryOp(kind, op, size, address, state);
        };
    }

    protected ComplexMatchResult emitConvertMemoryOp(PlatformKind kind, AMD64Assembler.AMD64RMOp op, AMD64BaseAssembler.OperandSize size, AddressableMemoryAccess access) {
        return this.emitConvertMemoryOp(kind, op, size, access, null);
    }

    private ComplexMatchResult emitSignExtendMemory(AddressableMemoryAccess access, int fromBits, int toBits, ValueKind<?> addressKind) {
        AMD64Assembler.AMD64RMOp op;
        AMD64BaseAssembler.OperandSize size;
        AMD64Kind kind;
        block14: {
            block13: {
                assert (fromBits <= toBits && toBits <= 64);
                kind = null;
                if (fromBits == toBits) {
                    return null;
                }
                if (toBits <= 32) break block13;
                kind = AMD64Kind.QWORD;
                size = AMD64BaseAssembler.OperandSize.QWORD;
                switch (fromBits) {
                    case 8: {
                        op = AMD64Assembler.AMD64RMOp.MOVSXB;
                        break block14;
                    }
                    case 16: {
                        op = AMD64Assembler.AMD64RMOp.MOVSX;
                        break block14;
                    }
                    case 32: {
                        op = AMD64Assembler.AMD64RMOp.MOVSXD;
                        break block14;
                    }
                    default: {
                        throw GraalError.unimplemented("unsupported sign extension (" + fromBits + " bit -> " + toBits + " bit)");
                    }
                }
            }
            kind = AMD64Kind.DWORD;
            size = AMD64BaseAssembler.OperandSize.DWORD;
            switch (fromBits) {
                case 8: {
                    op = AMD64Assembler.AMD64RMOp.MOVSXB;
                    break;
                }
                case 16: {
                    op = AMD64Assembler.AMD64RMOp.MOVSX;
                    break;
                }
                case 32: {
                    return null;
                }
                default: {
                    throw GraalError.unimplemented("unsupported sign extension (" + fromBits + " bit -> " + toBits + " bit)");
                }
            }
        }
        if (kind != null && op != null) {
            return this.emitConvertMemoryOp((PlatformKind)kind, op, size, access, addressKind);
        }
        return null;
    }

    private Value emitReinterpretMemory(LIRKind to, AddressableMemoryAccess access) {
        AMD64AddressValue address = (AMD64AddressValue)this.operand(access.getAddress());
        LIRFrameState state = this.getState(access);
        return this.getArithmeticLIRGenerator().emitLoad(to, address, state, MemoryOrderMode.PLAIN, MemoryExtendKind.DEFAULT);
    }

    private boolean supports(AMD64.CPUFeature feature) {
        return ((AMD64)this.getLIRGeneratorTool().target().arch).getFeatures().contains(feature);
    }

    @MatchRule(value="(And (Not a) b)")
    public ComplexMatchResult logicalAndNot(ValueNode a, ValueNode b) {
        if (!this.supports(AMD64.CPUFeature.BMI1)) {
            return null;
        }
        return builder -> this.getArithmeticLIRGenerator().emitLogicalAndNot(this.operand(a), this.operand(b));
    }

    @MatchRule(value="(And a (Negate a))")
    public ComplexMatchResult lowestSetIsolatedBit(ValueNode a) {
        if (!this.supports(AMD64.CPUFeature.BMI1)) {
            return null;
        }
        return builder -> this.getArithmeticLIRGenerator().emitLowestSetIsolatedBit(this.operand(a));
    }

    @MatchRule(value="(Xor a (Add a b))")
    public ComplexMatchResult getMaskUpToLowestSetBit(ValueNode a, ValueNode b) {
        long bValue;
        if (!this.supports(AMD64.CPUFeature.BMI1)) {
            return null;
        }
        if (!b.isJavaConstant()) {
            return null;
        }
        JavaConstant bCst = b.asJavaConstant();
        if (bCst.getJavaKind() == JavaKind.Int) {
            bValue = bCst.asInt();
        } else if (bCst.getJavaKind() == JavaKind.Long) {
            bValue = bCst.asLong();
        } else {
            return null;
        }
        if (bValue == -1L) {
            return builder -> this.getArithmeticLIRGenerator().emitGetMaskUpToLowestSetBit(this.operand(a));
        }
        return null;
    }

    @MatchRule(value="(And a (Add a b))")
    public ComplexMatchResult resetLowestSetBit(ValueNode a, ValueNode b) {
        long bValue;
        if (!this.supports(AMD64.CPUFeature.BMI1)) {
            return null;
        }
        if (!b.isJavaConstant()) {
            return null;
        }
        JavaConstant bCst = b.asJavaConstant();
        if (bCst.getJavaKind() == JavaKind.Int) {
            bValue = bCst.asInt();
        } else if (bCst.getJavaKind() == JavaKind.Long) {
            bValue = bCst.asLong();
        } else {
            return null;
        }
        if (bValue == -1L) {
            return builder -> this.getArithmeticLIRGenerator().emitResetLowestSetBit(this.operand(a));
        }
        return null;
    }

    @MatchRules(value={@MatchRule(value="(If (IntegerTest Read=access value))"), @MatchRule(value="(If (IntegerTest FloatingRead=access value))")})
    public ComplexMatchResult integerTestBranchMemory(IfNode root, LIRLowerableAccess access, ValueNode value) {
        return this.emitIntegerTestBranchMemory(root, value, access);
    }

    @MatchRules(value={@MatchRule(value="(If (IntegerEquals=compare value Read=access))"), @MatchRule(value="(If (IntegerLessThan=compare value Read=access))"), @MatchRule(value="(If (IntegerBelow=compare value Read=access))"), @MatchRule(value="(If (IntegerEquals=compare value FloatingRead=access))"), @MatchRule(value="(If (IntegerLessThan=compare value FloatingRead=access))"), @MatchRule(value="(If (IntegerBelow=compare value FloatingRead=access))"), @MatchRule(value="(If (FloatEquals=compare value Read=access))"), @MatchRule(value="(If (FloatEquals=compare value FloatingRead=access))"), @MatchRule(value="(If (FloatLessThan=compare value Read=access))"), @MatchRule(value="(If (FloatLessThan=compare value FloatingRead=access))"), @MatchRule(value="(If (PointerEquals=compare value Read=access))"), @MatchRule(value="(If (PointerEquals=compare value FloatingRead=access))"), @MatchRule(value="(If (ObjectEquals=compare value Read=access))"), @MatchRule(value="(If (ObjectEquals=compare value FloatingRead=access))")})
    public ComplexMatchResult ifCompareMemory(IfNode root, CompareNode compare, ValueNode value, LIRLowerableAccess access) {
        return this.emitCompareBranchMemory(root, compare, value, access);
    }

    @MatchRules(value={@MatchRule(value="(If (ObjectEquals=compare value ValueCompareAndSwap=cas))"), @MatchRule(value="(If (PointerEquals=compare value ValueCompareAndSwap=cas))"), @MatchRule(value="(If (FloatEquals=compare value ValueCompareAndSwap=cas))"), @MatchRule(value="(If (IntegerEquals=compare value ValueCompareAndSwap=cas))")})
    public ComplexMatchResult ifCompareValueCas(IfNode root, CompareNode compare, ValueNode value, ValueCompareAndSwapNode cas) {
        assert (compare.condition() == CanonicalCondition.EQ);
        if (value == cas.getExpectedValue() && cas.hasExactlyOneUsage()) {
            return builder -> {
                LIRKind kind = this.getLirKind(cas);
                LabelRef trueLabel = this.getLIRBlock(root.trueSuccessor());
                LabelRef falseLabel = this.getLIRBlock(root.falseSuccessor());
                double trueLabelProbability = root.probability(root.trueSuccessor());
                Value expectedValue = this.operand(cas.getExpectedValue());
                Value newValue = this.operand(cas.getNewValue());
                AMD64AddressValue address = (AMD64AddressValue)this.operand(cas.getAddress());
                this.getLIRGeneratorTool().emitCompareAndSwapBranch(kind, address, expectedValue, newValue, Condition.EQ, trueLabel, falseLabel, trueLabelProbability, cas.getBarrierType());
                return null;
            };
        }
        return null;
    }

    @MatchRules(value={@MatchRule(value="(If (ObjectEquals=compare value LogicCompareAndSwap=cas))"), @MatchRule(value="(If (PointerEquals=compare value LogicCompareAndSwap=cas))"), @MatchRule(value="(If (FloatEquals=compare value LogicCompareAndSwap=cas))"), @MatchRule(value="(If (IntegerEquals=compare value LogicCompareAndSwap=cas))")})
    public ComplexMatchResult ifCompareLogicCas(IfNode root, CompareNode compare, ValueNode value, LogicCompareAndSwapNode cas) {
        JavaConstant constant = value.asJavaConstant();
        assert (compare.condition() == CanonicalCondition.EQ);
        if (constant != null && cas.hasExactlyOneUsage()) {
            boolean successIsTrue;
            long constantValue = constant.asLong();
            if (constantValue == 0L) {
                successIsTrue = false;
            } else if (constantValue == 1L) {
                successIsTrue = true;
            } else {
                return null;
            }
            return builder -> {
                LIRKind kind = this.getLirKind(cas);
                LabelRef trueLabel = this.getLIRBlock(root.trueSuccessor());
                LabelRef falseLabel = this.getLIRBlock(root.falseSuccessor());
                double trueLabelProbability = root.probability(root.trueSuccessor());
                Value expectedValue = this.operand(cas.getExpectedValue());
                Value newValue = this.operand(cas.getNewValue());
                AMD64AddressValue address = (AMD64AddressValue)this.operand(cas.getAddress());
                Condition condition = successIsTrue ? Condition.EQ : Condition.NE;
                this.getLIRGeneratorTool().emitCompareAndSwapBranch(kind, address, expectedValue, newValue, condition, trueLabel, falseLabel, trueLabelProbability, cas.getBarrierType());
                return null;
            };
        }
        return null;
    }

    @MatchRule(value="(If (ObjectEquals=compare value FloatingRead=access))")
    public ComplexMatchResult ifLogicCas(IfNode root, CompareNode compare, ValueNode value, LIRLowerableAccess access) {
        return this.emitCompareBranchMemory(root, compare, value, access);
    }

    @MatchRule(value="(Or (LeftShift=lshift value Constant) (UnsignedRightShift=rshift value Constant))")
    public ComplexMatchResult rotateLeftConstant(LeftShiftNode lshift, UnsignedRightShiftNode rshift) {
        JavaConstant lshiftConst = lshift.getY().asJavaConstant();
        JavaConstant rshiftConst = rshift.getY().asJavaConstant();
        if ((lshift.getShiftAmountMask() & lshiftConst.asInt() + rshiftConst.asInt()) == 0) {
            return builder -> {
                Value a = this.operand(lshift.getX());
                AMD64BaseAssembler.OperandSize size = AMD64BaseAssembler.OperandSize.get(a.getPlatformKind());
                assert (size == AMD64BaseAssembler.OperandSize.DWORD || size == AMD64BaseAssembler.OperandSize.QWORD);
                return this.getArithmeticLIRGenerator().emitShiftConst(AMD64Assembler.AMD64Shift.ROL, size, a, lshiftConst);
            };
        }
        return null;
    }

    @MatchRule(value="(Or (LeftShift value (Sub Constant=delta shiftAmount)) (UnsignedRightShift value shiftAmount))")
    public ComplexMatchResult rotateRightVariable(ValueNode value, ConstantNode delta, ValueNode shiftAmount) {
        if (delta.asJavaConstant().asLong() == 0L || delta.asJavaConstant().asLong() == 32L) {
            return builder -> this.getArithmeticLIRGenerator().emitRor(this.operand(value), this.operand(shiftAmount));
        }
        return null;
    }

    @MatchRule(value="(Or (LeftShift value shiftAmount) (UnsignedRightShift value (Sub Constant=delta shiftAmount)))")
    public ComplexMatchResult rotateLeftVariable(ValueNode value, ValueNode shiftAmount, ConstantNode delta) {
        if (delta.asJavaConstant().asLong() == 0L || delta.asJavaConstant().asLong() == 32L) {
            return builder -> this.getArithmeticLIRGenerator().emitRol(this.operand(value), this.operand(shiftAmount));
        }
        return null;
    }

    private ComplexMatchResult binaryRead(AMD64Assembler.AMD64RMOp op, AMD64BaseAssembler.OperandSize size, ValueNode value, LIRLowerableAccess access) {
        return builder -> this.getArithmeticLIRGenerator().emitBinaryMemory(op, size, this.getLIRGeneratorTool().asAllocatable(this.operand(value)), (AMD64AddressValue)this.operand(access.getAddress()), this.getState(access));
    }

    private ComplexMatchResult binaryRead(AMD64Assembler.VexRVMOp op, AMD64BaseAssembler.OperandSize size, ValueNode value, LIRLowerableAccess access) {
        assert (size == AMD64BaseAssembler.OperandSize.SS || size == AMD64BaseAssembler.OperandSize.SD);
        return builder -> this.getArithmeticLIRGenerator().emitBinaryMemory(op, size, this.getLIRGeneratorTool().asAllocatable(this.operand(value)), (AMD64AddressValue)this.operand(access.getAddress()), this.getState(access));
    }

    @MatchRules(value={@MatchRule(value="(Add value Read=access)"), @MatchRule(value="(Add value FloatingRead=access)")})
    public ComplexMatchResult addMemory(ValueNode value, LIRLowerableAccess access) {
        AMD64BaseAssembler.OperandSize size = this.getMemorySize(access);
        if (size.isXmmType()) {
            if (this.getArithmeticLIRGenerator().supportAVX()) {
                return this.binaryRead(size == AMD64BaseAssembler.OperandSize.SS ? AMD64Assembler.VexRVMOp.VADDSS : AMD64Assembler.VexRVMOp.VADDSD, size, value, access);
            }
            return this.binaryRead(AMD64Assembler.SSEOp.ADD, size, value, access);
        }
        return this.binaryRead(AMD64Assembler.AMD64BinaryArithmetic.ADD.getRMOpcode(size), size, value, access);
    }

    @MatchRules(value={@MatchRule(value="(Sub value Read=access)"), @MatchRule(value="(Sub value FloatingRead=access)")})
    public ComplexMatchResult subMemory(ValueNode value, LIRLowerableAccess access) {
        AMD64BaseAssembler.OperandSize size = this.getMemorySize(access);
        if (size.isXmmType()) {
            if (this.getArithmeticLIRGenerator().supportAVX()) {
                return this.binaryRead(size == AMD64BaseAssembler.OperandSize.SS ? AMD64Assembler.VexRVMOp.VSUBSS : AMD64Assembler.VexRVMOp.VSUBSD, size, value, access);
            }
            return this.binaryRead(AMD64Assembler.SSEOp.SUB, size, value, access);
        }
        return this.binaryRead(AMD64Assembler.AMD64BinaryArithmetic.SUB.getRMOpcode(size), size, value, access);
    }

    @MatchRules(value={@MatchRule(value="(Mul value Read=access)"), @MatchRule(value="(Mul value FloatingRead=access)")})
    public ComplexMatchResult mulMemory(ValueNode value, LIRLowerableAccess access) {
        AMD64BaseAssembler.OperandSize size = this.getMemorySize(access);
        if (size.isXmmType()) {
            if (this.getArithmeticLIRGenerator().supportAVX()) {
                return this.binaryRead(size == AMD64BaseAssembler.OperandSize.SS ? AMD64Assembler.VexRVMOp.VMULSS : AMD64Assembler.VexRVMOp.VMULSD, size, value, access);
            }
            return this.binaryRead(AMD64Assembler.SSEOp.MUL, size, value, access);
        }
        return this.binaryRead(AMD64Assembler.AMD64RMOp.IMUL, size, value, access);
    }

    @MatchRules(value={@MatchRule(value="(And value Read=access)"), @MatchRule(value="(And value FloatingRead=access)")})
    public ComplexMatchResult andMemory(ValueNode value, LIRLowerableAccess access) {
        AMD64BaseAssembler.OperandSize size = this.getMemorySize(access);
        if (size.isXmmType()) {
            return null;
        }
        return this.binaryRead(AMD64Assembler.AMD64BinaryArithmetic.AND.getRMOpcode(size), size, value, access);
    }

    @MatchRules(value={@MatchRule(value="(Or value Read=access)"), @MatchRule(value="(Or value FloatingRead=access)")})
    public ComplexMatchResult orMemory(ValueNode value, LIRLowerableAccess access) {
        AMD64BaseAssembler.OperandSize size = this.getMemorySize(access);
        if (size.isXmmType()) {
            return null;
        }
        return this.binaryRead(AMD64Assembler.AMD64BinaryArithmetic.OR.getRMOpcode(size), size, value, access);
    }

    @MatchRules(value={@MatchRule(value="(Xor value Read=access)"), @MatchRule(value="(Xor value FloatingRead=access)")})
    public ComplexMatchResult xorMemory(ValueNode value, LIRLowerableAccess access) {
        AMD64BaseAssembler.OperandSize size = this.getMemorySize(access);
        if (size.isXmmType()) {
            return null;
        }
        return this.binaryRead(AMD64Assembler.AMD64BinaryArithmetic.XOR.getRMOpcode(size), size, value, access);
    }

    private ComplexMatchResult emitMemoryConsumer(WriteNode write, AMD64Assembler.AMD64BinaryArithmetic arithmeticOp, ReadNode read, ValueNode value) {
        if (this.getMemoryKind(write).isInteger() && !write.canDeoptimize() && !write.ordersMemoryAccesses() && !read.canDeoptimize()) {
            AMD64BaseAssembler.OperandSize size = this.getMemorySize(write);
            if (write.getAddress() == read.getAddress()) {
                long valueCst;
                if (value.isJavaConstant() && NumUtil.isInt(valueCst = value.asJavaConstant().asLong())) {
                    AMD64Assembler.AMD64MOp mop = AMD64ArithmeticLIRGenerator.getMOp(arithmeticOp, size, (int)valueCst);
                    if (mop != null) {
                        return builder -> {
                            AMD64AddressValue addressValue = (AMD64AddressValue)this.operand(write.getAddress());
                            builder.append(new AMD64UnaryConsumer.MemoryOp(mop, size, addressValue));
                            return null;
                        };
                    }
                    return builder -> {
                        AMD64AddressValue addressValue = (AMD64AddressValue)this.operand(write.getAddress());
                        builder.append(new AMD64BinaryConsumer.MemoryConstOp(arithmeticOp.getMIOpcode(size, NumUtil.isByte(valueCst)), size, addressValue, (int)valueCst, this.state(write)));
                        return null;
                    };
                }
                return builder -> {
                    AMD64AddressValue addressValue = (AMD64AddressValue)this.operand(write.getAddress());
                    builder.append(new AMD64BinaryConsumer.MemoryMROp(arithmeticOp.getMROpcode(size), size, addressValue, builder.getLIRGeneratorTool().asAllocatable(this.operand(value)), this.state(write)));
                    return null;
                };
            }
        }
        return null;
    }

    @MatchRules(value={@MatchRule(value="(Write=write object (Add Read=read value))"), @MatchRule(value="(SideEffectFreeWrite=write object (Add Read=read value))")})
    public ComplexMatchResult addToMemory(WriteNode write, ReadNode read, ValueNode value) {
        return this.emitMemoryConsumer(write, AMD64Assembler.AMD64BinaryArithmetic.ADD, read, value);
    }

    @MatchRule(value="(Write=write object (Sub Read=read value))")
    public ComplexMatchResult subToMemory(WriteNode write, ReadNode read, ValueNode value) {
        return this.emitMemoryConsumer(write, AMD64Assembler.AMD64BinaryArithmetic.SUB, read, value);
    }

    @MatchRule(value="(Write=write object (Or Read=read value))")
    public ComplexMatchResult orToMemory(WriteNode write, ReadNode read, ValueNode value) {
        return this.emitMemoryConsumer(write, AMD64Assembler.AMD64BinaryArithmetic.OR, read, value);
    }

    @MatchRule(value="(Write=write object (Xor Read=read value))")
    public ComplexMatchResult xorToMemory(WriteNode write, ReadNode read, ValueNode value) {
        return this.emitMemoryConsumer(write, AMD64Assembler.AMD64BinaryArithmetic.XOR, read, value);
    }

    @MatchRule(value="(Write object Narrow=narrow)")
    public ComplexMatchResult writeNarrow(WriteNode root, NarrowNode narrow) {
        return builder -> {
            LIRKind writeKind = this.getLIRGeneratorTool().getLIRKind(root.value().stamp(NodeView.DEFAULT));
            this.getArithmeticLIRGenerator().emitStore(writeKind, this.operand(root.getAddress()), this.operand(narrow.getValue()), this.state(root), root.getMemoryOrder());
            return null;
        };
    }

    @MatchRules(value={@MatchRule(value="(SignExtend Read=access)"), @MatchRule(value="(SignExtend FloatingRead=access)")})
    public ComplexMatchResult signExtend(SignExtendNode root, LIRLowerableAccess access) {
        return this.emitSignExtendMemory(access, root.getInputBits(), root.getResultBits(), null);
    }

    @MatchRules(value={@MatchRule(value="(ZeroExtend Read=access)"), @MatchRule(value="(ZeroExtend FloatingRead=access)")})
    public ComplexMatchResult zeroExtend(ZeroExtendNode root, LIRLowerableAccess access) {
        AMD64Kind memoryKind = this.getMemoryKind(access);
        return builder -> this.getArithmeticLIRGenerator().emitZeroExtendMemory(memoryKind, root.getResultBits(), (AMD64AddressValue)this.operand(access.getAddress()), this.getState(access));
    }

    @MatchRules(value={@MatchRule(value="(Narrow Read=access)"), @MatchRule(value="(Narrow FloatingRead=access)")})
    public ComplexMatchResult narrowRead(final NarrowNode root, final LIRLowerableAccess access) {
        return new ComplexMatchResult(){

            @Override
            public Value evaluate(NodeLIRBuilder builder) {
                AMD64AddressValue address = (AMD64AddressValue)AMD64NodeMatchRules.this.operand(access.getAddress());
                LIRKind addressKind = LIRKind.combineDerived(AMD64NodeMatchRules.this.getLIRGeneratorTool().getLIRKind(root.asNode().stamp(NodeView.DEFAULT)), address.getBase(), address.getIndex());
                AMD64AddressValue newAddress = address.withKind(addressKind);
                LIRKind readKind = AMD64NodeMatchRules.this.getLIRGeneratorTool().getLIRKind(root.stamp(NodeView.DEFAULT));
                return AMD64NodeMatchRules.this.getArithmeticLIRGenerator().emitZeroExtendMemory((AMD64Kind)readKind.getPlatformKind(), root.getResultBits(), newAddress, AMD64NodeMatchRules.this.getState(access));
            }
        };
    }

    @MatchRules(value={@MatchRule(value="(SignExtend (Narrow=narrow Read=access))"), @MatchRule(value="(SignExtend (Narrow=narrow FloatingRead=access))")})
    public ComplexMatchResult signExtendNarrowRead(SignExtendNode root, NarrowNode narrow, LIRLowerableAccess access) {
        LIRKind kind = this.getLIRGeneratorTool().getLIRKind(narrow.stamp(NodeView.DEFAULT));
        return this.emitSignExtendMemory(access, narrow.getResultBits(), root.getResultBits(), kind);
    }

    @MatchRules(value={@MatchRule(value="(FloatConvert Read=access)"), @MatchRule(value="(FloatConvert FloatingRead=access)")})
    public ComplexMatchResult floatConvert(FloatConvertNode root, LIRLowerableAccess access) {
        switch (root.getFloatConvert()) {
            case D2F: {
                return this.emitConvertMemoryOp((PlatformKind)AMD64Kind.SINGLE, AMD64Assembler.SSEOp.CVTSD2SS, AMD64BaseAssembler.OperandSize.SD, access);
            }
            case D2I: {
                return this.emitConvertMemoryOp((PlatformKind)AMD64Kind.DWORD, AMD64Assembler.SSEOp.CVTTSD2SI, AMD64BaseAssembler.OperandSize.DWORD, access);
            }
            case D2L: {
                return this.emitConvertMemoryOp((PlatformKind)AMD64Kind.QWORD, AMD64Assembler.SSEOp.CVTTSD2SI, AMD64BaseAssembler.OperandSize.QWORD, access);
            }
            case F2D: {
                return this.emitConvertMemoryOp((PlatformKind)AMD64Kind.DOUBLE, AMD64Assembler.SSEOp.CVTSS2SD, AMD64BaseAssembler.OperandSize.SS, access);
            }
            case F2I: {
                return this.emitConvertMemoryOp((PlatformKind)AMD64Kind.DWORD, AMD64Assembler.SSEOp.CVTTSS2SI, AMD64BaseAssembler.OperandSize.DWORD, access);
            }
            case F2L: {
                return this.emitConvertMemoryOp((PlatformKind)AMD64Kind.QWORD, AMD64Assembler.SSEOp.CVTTSS2SI, AMD64BaseAssembler.OperandSize.QWORD, access);
            }
            case I2D: {
                return this.emitConvertMemoryOp((PlatformKind)AMD64Kind.DOUBLE, AMD64Assembler.SSEOp.CVTSI2SD, AMD64BaseAssembler.OperandSize.DWORD, access);
            }
            case I2F: {
                return this.emitConvertMemoryOp((PlatformKind)AMD64Kind.SINGLE, AMD64Assembler.SSEOp.CVTSI2SS, AMD64BaseAssembler.OperandSize.DWORD, access);
            }
            case L2D: {
                return this.emitConvertMemoryOp((PlatformKind)AMD64Kind.DOUBLE, AMD64Assembler.SSEOp.CVTSI2SD, AMD64BaseAssembler.OperandSize.QWORD, access);
            }
            case L2F: {
                return this.emitConvertMemoryOp((PlatformKind)AMD64Kind.SINGLE, AMD64Assembler.SSEOp.CVTSI2SS, AMD64BaseAssembler.OperandSize.QWORD, access);
            }
        }
        throw GraalError.shouldNotReachHere();
    }

    @MatchRules(value={@MatchRule(value="(Reinterpret Read=access)"), @MatchRule(value="(Reinterpret FloatingRead=access)")})
    public ComplexMatchResult reinterpret(ReinterpretNode root, LIRLowerableAccess access) {
        return builder -> {
            LIRKind kind = this.getLIRGeneratorTool().getLIRKind(root.stamp(NodeView.DEFAULT));
            return this.emitReinterpretMemory(kind, access);
        };
    }

    @MatchRule(value="(Write object Reinterpret=reinterpret)")
    public ComplexMatchResult writeReinterpret(WriteNode root, ReinterpretNode reinterpret) {
        return builder -> {
            LIRKind kind = this.getLIRGeneratorTool().getLIRKind(reinterpret.getValue().stamp(NodeView.DEFAULT));
            AllocatableValue value = this.getLIRGeneratorTool().asAllocatable(this.operand(reinterpret.getValue()));
            AMD64AddressValue address = (AMD64AddressValue)this.operand(root.getAddress());
            this.getArithmeticLIRGenerator().emitStore(kind, address, (Value)value, this.getState(root), root.getMemoryOrder());
            return null;
        };
    }

    @MatchRule(value="(Conditional (IntegerBelow x y) Constant=cm1 (Conditional (IntegerEquals x y) Constant=c0 Constant=c1))")
    public ComplexMatchResult normalizedIntegerCompare(ValueNode x, ValueNode y, ConstantNode cm1, ConstantNode c0, ConstantNode c1) {
        if (cm1.getStackKind() == JavaKind.Int && cm1.asJavaConstant().asInt() == -1 && c0.getStackKind() == JavaKind.Int && c0.asJavaConstant().asInt() == 0 && c1.getStackKind() == JavaKind.Int && c1.asJavaConstant().asInt() == 1) {
            return builder -> this.getArithmeticLIRGenerator().emitNormalizedUnsignedCompare(this.operand(x), this.operand(y));
        }
        return null;
    }

    @Override
    public AMD64LIRGenerator getLIRGeneratorTool() {
        return (AMD64LIRGenerator)this.gen;
    }

    protected AMD64ArithmeticLIRGenerator getArithmeticLIRGenerator() {
        return (AMD64ArithmeticLIRGenerator)this.getLIRGeneratorTool().getArithmetic();
    }
}

