/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.core.common;

import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.core.common.Stride;

public final class StrideUtil {
    public static final int N_STRIDES = 3;

    public static Stride getConstantStrideA(int directStubCallIndex) {
        return Stride.fromLog2(directStubCallIndex / 3);
    }

    public static Stride getConstantStrideB(int directStubCallIndex) {
        return Stride.fromLog2(directStubCallIndex % 3);
    }

    public static int getDirectStubCallIndex(Stride strideA, Stride strideB) {
        return StrideUtil.getDirectStubCallIndex(strideA.log2, strideB.log2);
    }

    public static int getDirectStubCallIndex(int log2StrideA, int log2StrideB) {
        assert (0 <= log2StrideA && log2StrideA < 3) : log2StrideA;
        assert (0 <= log2StrideB && log2StrideB < 3) : log2StrideB;
        return log2StrideA * 3 + log2StrideB;
    }

    public static boolean useConstantStrides(Value dynamicStride) {
        return ValueUtil.isIllegal((Value)dynamicStride);
    }
}

