/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.core.common.cfg;

import java.util.BitSet;
import org.graalvm.compiler.core.common.cfg.AbstractControlFlowGraph;
import org.graalvm.compiler.core.common.cfg.BasicBlock;

public class BasicBlockSet {
    private BitSet set;
    private final AbstractControlFlowGraph<?> cfg;
    private int count;

    protected BasicBlockSet(AbstractControlFlowGraph<?> cfg) {
        this.cfg = cfg;
    }

    public boolean get(BasicBlock<?> b) {
        if (this.set == null) {
            return false;
        }
        return this.set.get(b.getId());
    }

    public void set(BasicBlock<?> b) {
        if (!this.get(b)) {
            if (this.set == null) {
                this.set = new BitSet(this.cfg.getBlocks().length);
            }
            ++this.count;
            this.set.set(b.getId());
        }
    }

    public int count() {
        return this.count;
    }
}

