/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.core.common.util;

import java.util.BitSet;

public final class BitMap2D {
    private BitSet map;
    private final int bitsPerSlot;

    private int bitIndex(int slotIndex, int bitWithinSlotIndex) {
        return slotIndex * this.bitsPerSlot + bitWithinSlotIndex;
    }

    private boolean verifyBitWithinSlotIndex(int index) {
        assert (index < this.bitsPerSlot) : "index " + index + " is out of bounds " + this.bitsPerSlot;
        return true;
    }

    public BitMap2D(int sizeInSlots, int bitsPerSlot) {
        long nBits = (long)sizeInSlots * (long)bitsPerSlot;
        if (nBits > Integer.MAX_VALUE) {
            throw new OutOfMemoryError("Cannot allocate a BitSet for " + nBits + " bits");
        }
        this.map = new BitSet(sizeInSlots * bitsPerSlot);
        this.bitsPerSlot = bitsPerSlot;
    }

    public boolean at(int slotIndex, int bitWithinSlotIndex) {
        assert (this.verifyBitWithinSlotIndex(bitWithinSlotIndex));
        return this.map.get(this.bitIndex(slotIndex, bitWithinSlotIndex));
    }

    public void setBit(int slotIndex, int bitWithinSlotIndex) {
        assert (this.verifyBitWithinSlotIndex(bitWithinSlotIndex));
        this.map.set(this.bitIndex(slotIndex, bitWithinSlotIndex));
    }

    public void clear() {
        this.map.clear();
    }
}

