/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.core.riscv64;

import java.lang.reflect.Method;

public class RISCV64ReflectionUtil {
    public static final String archClass = "jdk.vm.ci.riscv64.RISCV64";
    public static final String featureClass = "jdk.vm.ci.riscv64.RISCV64$CPUFeature";
    public static final String flagClass = "jdk.vm.ci.riscv64.RISCV64$Flag";
    public static final String hotSpotClass = "jdk.vm.ci.hotspot.riscv64.RISCV64HotSpotRegisterConfig";

    public static Class<?> lookupClass(boolean optional, String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException ex) {
            if (optional) {
                return null;
            }
            throw new ReflectionUtilError(ex);
        }
    }

    public static Class<?> getArch(boolean optional) {
        return RISCV64ReflectionUtil.lookupClass(optional, archClass);
    }

    public static <T> T readStaticField(Class<?> declaringClass, String fieldName) {
        try {
            return (T)declaringClass.getField(fieldName).get(null);
        }
        catch (ReflectiveOperationException ex) {
            throw new ReflectionUtilError(ex);
        }
    }

    public static Method lookupMethod(Class<?> declaringClass, String methodName, Class<?> ... parameterTypes) {
        try {
            return declaringClass.getDeclaredMethod(methodName, parameterTypes);
        }
        catch (ReflectiveOperationException ex) {
            throw new ReflectionUtilError(ex);
        }
    }

    public static Object invokeMethod(Method method, Object obj, Object ... args) {
        try {
            return method.invoke(obj, args);
        }
        catch (ReflectiveOperationException ex) {
            throw new ReflectionUtilError(ex);
        }
    }

    public static final class ReflectionUtilError
    extends Error {
        private ReflectionUtilError(Throwable cause) {
            super(cause);
        }
    }
}

