/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.graph.iterators;

import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.iterators.NodePredicate;

public abstract class NodePredicates {
    private static final TautologyPredicate TAUTOLOGY = new TautologyPredicate();

    public static NodePredicate alwaysTrue() {
        return TAUTOLOGY;
    }

    public static NegativeTypePredicate isNotA(Class<? extends Node> clazz) {
        return new NegativeTypePredicate(clazz);
    }

    public static PositiveTypePredicate isA(Class<? extends Node> clazz) {
        return new PositiveTypePredicate(clazz);
    }

    static final class TautologyPredicate
    implements NodePredicate {
        TautologyPredicate() {
        }

        @Override
        public boolean apply(Node n) {
            return true;
        }

        @Override
        public NodePredicate and(NodePredicate np) {
            return np;
        }
    }

    public static final class NegativeTypePredicate
    implements NodePredicate {
        private final Class<?> type;
        private NegativeTypePredicate nor;

        NegativeTypePredicate(Class<?> type) {
            this.type = type;
        }

        public NegativeTypePredicate(PositiveTypePredicate a) {
            this.type = a.type;
            if (a.or != null) {
                this.nor = new NegativeTypePredicate(a.or);
            }
        }

        @Override
        public boolean apply(Node n) {
            return !this.type.isInstance(n) && (this.nor == null || this.nor.apply(n));
        }

        public NegativeTypePredicate nor(Class<? extends Node> clazz) {
            if (this.nor == null) {
                this.nor = new NegativeTypePredicate(clazz);
            } else {
                this.nor.nor(clazz);
            }
            return this;
        }

        public NodePredicate negate() {
            return new PositiveTypePredicate(this);
        }
    }

    public static final class PositiveTypePredicate
    implements NodePredicate {
        private final Class<?> type;
        private PositiveTypePredicate or;

        PositiveTypePredicate(Class<?> type) {
            this.type = type;
        }

        public PositiveTypePredicate(NegativeTypePredicate a) {
            this.type = a.type;
            if (a.nor != null) {
                this.or = new PositiveTypePredicate(a.nor);
            }
        }

        @Override
        public boolean apply(Node n) {
            return this.type.isInstance(n) || this.or != null && this.or.apply(n);
        }

        public PositiveTypePredicate or(Class<? extends Node> clazz) {
            if (this.or == null) {
                this.or = new PositiveTypePredicate(clazz);
            } else {
                this.or.or(clazz);
            }
            return this;
        }

        public NodePredicate negate() {
            return new NegativeTypePredicate(this);
        }
    }

    static final class AndPredicate
    implements NodePredicate {
        private final NodePredicate a;
        private final NodePredicate b;

        AndPredicate(NodePredicate a, NodePredicate b) {
            this.a = a;
            this.b = b;
        }

        @Override
        public boolean apply(Node n) {
            return this.a.apply(n) && this.b.apply(n);
        }
    }
}

