/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot;

import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaField;
import org.graalvm.compiler.core.common.memory.BarrierType;
import org.graalvm.compiler.core.common.type.AbstractObjectStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.hotspot.replacements.HotSpotReplacementsUtil;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.gc.ZBarrierSet;
import org.graalvm.word.LocationIdentity;

public class HotSpotZBarrierSet
extends ZBarrierSet {
    public HotSpotZBarrierSet(ResolvedJavaField referentField) {
        super(referentField);
    }

    @Override
    protected BarrierType barrierForLocation(BarrierType currentBarrier, LocationIdentity location, JavaKind storageKind) {
        if (location instanceof HotSpotReplacementsUtil.OopHandleLocationIdentity) {
            return BarrierType.READ;
        }
        return super.barrierForLocation(currentBarrier, location, storageKind);
    }

    @Override
    public BarrierType readBarrierType(LocationIdentity location, ValueNode address, Stamp loadStamp) {
        if (location instanceof HotSpotReplacementsUtil.OopHandleLocationIdentity) {
            assert (loadStamp instanceof AbstractObjectStamp) : loadStamp;
            return BarrierType.READ;
        }
        return super.readBarrierType(location, address, loadStamp);
    }
}

