/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot;

import java.util.Formatter;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class JVMCIVersionCheck {
    private static final Version JVMCI_MIN_VERSION = new Version(23, 0, 10);
    private static final int JAVA_MIN_RELEASE = 17;
    public static final String OPEN_LABSJDK_RELEASE_URL_PATTERN = "https://github.com/graalvm/labs-openjdk-*/releases";
    private final String javaSpecVersion;
    private final String vmVersion;
    private final Map<String, String> props;

    private void failVersionCheck(boolean exit, String reason, Object ... args) {
        Formatter errorMessage = new Formatter().format(reason, args);
        String javaHome = this.props.get("java.home");
        String vmName = this.props.get("java.vm.name");
        errorMessage.format("Set the JVMCI_VERSION_CHECK environment variable to \"ignore\" to suppress ", new Object[0]);
        errorMessage.format("this error or to \"warn\" to emit a warning and continue execution.%n", new Object[0]);
        errorMessage.format("Currently used Java home directory is %s.%n", javaHome);
        errorMessage.format("Currently used VM configuration is: %s%n", vmName);
        if (this.vmVersion.contains("-jvmci-")) {
            errorMessage.format("Download the latest Labs OpenJDK from https://github.com/graalvm/labs-openjdk-*/releases", new Object[0]);
        } else {
            errorMessage.format("Download JDK %s or later.", 17);
        }
        String value = System.getenv("JVMCI_VERSION_CHECK");
        if ("warn".equals(value)) {
            System.err.println(errorMessage.toString());
        } else {
            if ("ignore".equals(value)) {
                return;
            }
            if (exit) {
                System.err.println(errorMessage.toString());
                System.exit(-1);
            } else {
                throw new InternalError(errorMessage.toString());
            }
        }
    }

    private JVMCIVersionCheck(Map<String, String> props, String javaSpecVersion, String vmVersion) {
        this.props = props;
        this.javaSpecVersion = javaSpecVersion;
        this.vmVersion = vmVersion;
    }

    static void check(Map<String, String> props, boolean exitOnFailure, boolean quiet) {
        JVMCIVersionCheck checker = new JVMCIVersionCheck(props, props.get("java.specification.version"), props.get("java.vm.version"));
        checker.run(exitOnFailure, JVMCI_MIN_VERSION, quiet);
    }

    public static void check(Map<String, String> props, Version minVersion, String javaSpecVersion, String javaVmVersion, boolean exitOnFailure) {
        JVMCIVersionCheck checker = new JVMCIVersionCheck(props, javaSpecVersion, javaVmVersion);
        checker.run(exitOnFailure, minVersion, true);
    }

    private void run(boolean exitOnFailure, Version minVersion, boolean quiet) {
        if (this.javaSpecVersion.compareTo(Integer.toString(17)) < 0) {
            this.failVersionCheck(exitOnFailure, "Graal requires JDK 17 or later.%n", new Object[0]);
        } else {
            if (this.vmVersion.contains("SNAPSHOT")) {
                return;
            }
            if (this.vmVersion.contains("internal")) {
                return;
            }
            if (this.vmVersion.contains("-jvmci-")) {
                Version v = Version.parse(this.vmVersion);
                if (v != null) {
                    if (!quiet) {
                        System.out.println(String.format("%d,%d,%d", v.major, v.minor, v.build));
                    }
                    Version actualMinVersion = minVersion;
                    if (this.javaSpecVersion.equals("19")) {
                        actualMinVersion = new Version(23, 0, 5);
                    }
                    if (v.isLessThan(actualMinVersion)) {
                        this.failVersionCheck(exitOnFailure, "The VM does not support the minimum JVMCI API version required by Graal: %s < %s.%n", v, actualMinVersion);
                    }
                    return;
                }
                this.failVersionCheck(exitOnFailure, "The VM does not support the minimum JVMCI API version required by Graal.%nCannot read JVMCI version from java.vm.version property: %s.%n", this.vmVersion);
            }
        }
    }

    public static void main(String[] args) {
        Properties sprops = System.getProperties();
        HashMap<String, String> props = new HashMap<String, String>(sprops.size());
        for (String name : sprops.stringPropertyNames()) {
            props.put(name, sprops.getProperty(name));
        }
        JVMCIVersionCheck.check(props, true, false);
    }

    public static class Version {
        private final int major;
        private final int minor;
        private final int build;

        static Version parse(String vmVersion) {
            Matcher m = Pattern.compile(".*-jvmci-(\\d+)\\.(\\d+)-b(\\d+).*").matcher(vmVersion);
            if (m.matches()) {
                try {
                    int major = Integer.parseInt(m.group(1));
                    int minor = Integer.parseInt(m.group(2));
                    int build = Integer.parseInt(m.group(3));
                    return new Version(major, minor, build);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return null;
        }

        public Version(int major, int minor, int build) {
            this.major = major;
            this.minor = minor;
            this.build = build;
        }

        boolean isGreaterThan(Version other) {
            if (!this.isLessThan(other)) {
                return !this.equals(other);
            }
            return false;
        }

        public boolean isLessThan(Version other) {
            if (this.major < other.major) {
                return true;
            }
            if (this.major == other.major) {
                if (this.minor < other.minor) {
                    return true;
                }
                if (this.minor == other.minor && this.build < other.build) {
                    return true;
                }
            }
            return false;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Version) {
                Version that = (Version)obj;
                return this.major == that.major && this.minor == that.minor && this.build == that.build;
            }
            return false;
        }

        public int hashCode() {
            return this.major ^ this.minor ^ this.build;
        }

        public String toString() {
            return String.format("%d.%d-b%02d", this.major, this.minor, this.build);
        }
    }
}

