/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.amd64;

import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.asm.amd64.AMD64Assembler;
import org.graalvm.compiler.asm.amd64.AMD64BaseAssembler;
import org.graalvm.compiler.asm.amd64.AMD64MacroAssembler;
import org.graalvm.compiler.core.common.spi.ForeignCallLinkage;
import org.graalvm.compiler.hotspot.GraalHotSpotVMConfig;
import org.graalvm.compiler.hotspot.amd64.AMD64HotSpotZBarrieredOp;
import org.graalvm.compiler.lir.LIRFrameState;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.Variable;
import org.graalvm.compiler.lir.amd64.AMD64AddressValue;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;

public class AMD64HotSpotZReadBarrierOp
extends AMD64HotSpotZBarrieredOp {
    public static final LIRInstructionClass<AMD64HotSpotZReadBarrierOp> TYPE = LIRInstructionClass.create(AMD64HotSpotZReadBarrierOp.class);
    @LIRInstruction.State
    protected LIRFrameState state;

    public AMD64HotSpotZReadBarrierOp(Variable result, AMD64AddressValue loadAddress, LIRFrameState state, GraalHotSpotVMConfig config, ForeignCallLinkage callTarget) {
        super(TYPE, result, loadAddress, config, callTarget);
        this.state = state;
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
        if (this.state != null) {
            crb.recordImplicitException(masm.position(), this.state);
        }
        Register resultReg = ValueUtil.asRegister((Value)this.result);
        AMD64Assembler.AMD64RMOp.MOV.emit((AMD64Assembler)masm, AMD64BaseAssembler.OperandSize.QWORD, resultReg, this.loadAddress.toAddress());
        this.emitBarrier(crb, masm);
    }
}

