/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.amd64;

import java.util.EnumSet;
import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.code.CallingConvention;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.asm.Label;
import org.graalvm.compiler.asm.amd64.AMD64Address;
import org.graalvm.compiler.asm.amd64.AMD64Assembler;
import org.graalvm.compiler.asm.amd64.AMD64MacroAssembler;
import org.graalvm.compiler.asm.amd64.AVXKind;
import org.graalvm.compiler.core.common.spi.ForeignCallLinkage;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.hotspot.GraalHotSpotVMConfig;
import org.graalvm.compiler.hotspot.amd64.AMD64HotSpotZBarrieredOp;
import org.graalvm.compiler.lir.LIRFrameState;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.Variable;
import org.graalvm.compiler.lir.amd64.AMD64AddressValue;
import org.graalvm.compiler.lir.amd64.AMD64Call;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;

public class AMD64HotSpotZVectorReadBarrierOp
extends AMD64HotSpotZBarrieredOp {
    public static final LIRInstructionClass<AMD64HotSpotZVectorReadBarrierOp> TYPE = LIRInstructionClass.create(AMD64HotSpotZVectorReadBarrierOp.class);
    private final AVXKind.AVXSize size;
    private final AMD64Assembler.VexMoveOp op;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    protected AllocatableValue temp;
    @LIRInstruction.State
    protected LIRFrameState state;

    public AMD64HotSpotZVectorReadBarrierOp(AVXKind.AVXSize size, AMD64Assembler.VexMoveOp op, Variable result, AMD64AddressValue loadAddress, LIRFrameState state, GraalHotSpotVMConfig config, ForeignCallLinkage callTarget, Variable temp) {
        super(TYPE, result, loadAddress, config, callTarget);
        this.size = size;
        this.op = op;
        this.state = state;
        this.temp = temp;
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
        AMD64Assembler.VexRMOp broadcastOp;
        AVXKind.AVXSize broadcastSize;
        if (this.state != null) {
            crb.recordImplicitException(masm.position(), this.state);
        }
        Register resultReg = ValueUtil.asRegister((Value)this.result);
        this.op.emit((AMD64Assembler)masm, this.size, resultReg, this.loadAddress.toAddress());
        AMD64Address address = this.loadAddress.toAddress();
        Label entryPoint = new Label();
        Label continuation = new Label();
        Register tempReg = ValueUtil.asRegister((Value)this.temp);
        EnumSet features = masm.getFeatures();
        GraalError.guarantee(features.contains(AMD64.CPUFeature.AVX), "Unexpected vector LIR without AVX");
        if (features.contains(AMD64.CPUFeature.AVX512F)) {
            broadcastSize = features.contains(AMD64.CPUFeature.AVX512VL) ? this.size : AVXKind.AVXSize.ZMM;
            broadcastOp = AMD64Assembler.VexRMOp.VPBROADCASTQ;
        } else if (features.contains(AMD64.CPUFeature.AVX2)) {
            broadcastSize = this.size;
            broadcastOp = AMD64Assembler.VexRMOp.VPBROADCASTQ;
        } else {
            broadcastSize = AVXKind.AVXSize.YMM;
            broadcastOp = AMD64Assembler.VexRMOp.VBROADCASTSD;
        }
        broadcastOp.emit((AMD64Assembler)masm, broadcastSize, tempReg, new AMD64Address(AMD64.r15, this.config.threadAddressBadMaskOffset));
        masm.vptest(resultReg, tempReg, this.size);
        masm.jcc(AMD64Assembler.ConditionFlag.NotZero, entryPoint);
        crb.getLIR().addSlowPath(this, () -> {
            masm.bind(entryPoint);
            int count = this.size.getBytes() / 8;
            CallingConvention cc = this.callTarget.getOutgoingCallingConvention();
            AMD64Address cArg0 = (AMD64Address)crb.asAddress((Value)cc.getArgument(0));
            AMD64Address cArg1 = (AMD64Address)crb.asAddress((Value)cc.getArgument(1));
            masm.movq(cArg1, AMD64.rax);
            masm.leaq(AMD64.rax, address);
            masm.movq(cArg0, AMD64.rax);
            masm.movq(AMD64.rax, cArg1);
            masm.movslq(cArg1, count);
            AMD64Call.directCall(crb, masm, this.callTarget, null, false, null);
            masm.movq(resultReg, cArg0);
            this.op.emit((AMD64Assembler)masm, this.size, resultReg, this.loadAddress.toAddress());
            masm.jmp(continuation);
        });
        masm.bind(continuation);
    }
}

