/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.nodes;

import java.util.Arrays;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.core.common.spi.ForeignCallLinkage;
import org.graalvm.compiler.core.common.spi.ForeignCallsProvider;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.graph.NodeInputList;
import org.graalvm.compiler.hotspot.nodes.StubStartNode;
import org.graalvm.compiler.hotspot.replacements.HotSpotReplacementsUtil;
import org.graalvm.compiler.lir.Variable;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodeinfo.Verbosity;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.memory.MultiMemoryKill;
import org.graalvm.compiler.nodes.spi.LIRLowerable;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import org.graalvm.word.LocationIdentity;

@NodeInfo(nameTemplate="StubForeignCall#{p#descriptor/s}", allowedUsageTypes={InputType.Memory}, cycles=NodeCycles.CYCLES_UNKNOWN, cyclesRationale="Cannot estimate the runtime cost of a call; it's a blackhole.", size=NodeSize.SIZE_UNKNOWN, sizeRationale="Can only dynamically decide how much code is generated based on the type of a call (special, static, virtual, interface).")
public final class StubForeignCallNode
extends FixedWithNextNode
implements LIRLowerable,
MultiMemoryKill {
    public static final NodeClass<StubForeignCallNode> TYPE = NodeClass.create(StubForeignCallNode.class);
    @Node.Input
    NodeInputList<ValueNode> arguments;
    private final ForeignCallsProvider foreignCalls;
    protected final ForeignCallDescriptor descriptor;

    public StubForeignCallNode(@Node.InjectedNodeParameter ForeignCallsProvider foreignCalls, @Node.InjectedNodeParameter Stamp stamp, ForeignCallDescriptor descriptor, ValueNode ... arguments) {
        super((NodeClass<? extends FixedWithNextNode>)TYPE, stamp);
        this.foreignCalls = foreignCalls;
        this.arguments = new NodeInputList((Node)this, (Node[])arguments);
        this.descriptor = descriptor;
    }

    @Override
    public LocationIdentity[] getKilledLocationIdentities() {
        LocationIdentity[] killedLocations = this.descriptor.getKilledLocations();
        killedLocations = Arrays.copyOf(killedLocations, killedLocations.length + 1);
        killedLocations[killedLocations.length - 1] = HotSpotReplacementsUtil.PENDING_EXCEPTION_LOCATION;
        return killedLocations;
    }

    protected Value[] operands(NodeLIRBuilderTool gen) {
        Value[] operands = new Value[this.arguments.size()];
        for (int i = 0; i < operands.length; ++i) {
            operands[i] = gen.operand((Node)this.arguments.get(i));
        }
        return operands;
    }

    @Override
    public void generate(NodeLIRBuilderTool gen) {
        assert (this.graph().start() instanceof StubStartNode);
        ForeignCallLinkage linkage = this.foreignCalls.lookupForeignCall(this.descriptor);
        Value[] operands = this.operands(gen);
        Variable result = gen.getLIRGeneratorTool().emitForeignCall(linkage, null, operands);
        if (result != null) {
            gen.setResult(this, (Value)result);
        }
    }

    @Override
    public String toString(Verbosity verbosity) {
        if (verbosity == Verbosity.Name) {
            return super.toString(verbosity) + "#" + this.descriptor;
        }
        return super.toString(verbosity);
    }
}

