/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.nodes.type;

import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.core.common.spi.LIRKindTool;
import org.graalvm.compiler.core.common.type.AbstractPointerStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.debug.GraalError;

public abstract class MetaspacePointerStamp
extends AbstractPointerStamp {
    protected MetaspacePointerStamp(boolean nonNull, boolean alwaysNull) {
        super(nonNull, alwaysNull);
    }

    @Override
    public LIRKind getLIRKind(LIRKindTool tool) {
        return tool.getWordKind();
    }

    @Override
    public Stamp empty() {
        return this;
    }

    @Override
    public boolean isCompatible(Constant constant) {
        return constant.isDefaultForKind();
    }

    @Override
    public boolean hasValues() {
        return true;
    }

    @Override
    public Stamp join(Stamp other) {
        return this.defaultPointerJoin(other);
    }

    @Override
    public ResolvedJavaType javaType(MetaAccessProvider metaAccess) {
        throw GraalError.shouldNotReachHere("metaspace pointer has no Java type");
    }

    protected void appendString(StringBuilder str) {
        str.append(this.nonNull() ? "!" : "").append(this.alwaysNull() ? " NULL" : "");
    }
}

