/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.replacements;

import jdk.vm.ci.code.CodeUtil;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.hotspot.HotSpotResolvedObjectType;
import jdk.vm.ci.meta.DeoptimizationAction;
import jdk.vm.ci.meta.DeoptimizationReason;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.api.replacements.Snippet;
import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.hotspot.GraalHotSpotVMConfig;
import org.graalvm.compiler.hotspot.HotSpotBackend;
import org.graalvm.compiler.hotspot.meta.HotSpotForeignCallDescriptor;
import org.graalvm.compiler.hotspot.meta.HotSpotForeignCallsProviderImpl;
import org.graalvm.compiler.hotspot.meta.HotSpotProviders;
import org.graalvm.compiler.hotspot.meta.HotSpotRegistersProvider;
import org.graalvm.compiler.hotspot.nodes.KlassBeingInitializedCheckNode;
import org.graalvm.compiler.hotspot.nodes.type.KlassPointerStamp;
import org.graalvm.compiler.hotspot.replacements.AssertionSnippets;
import org.graalvm.compiler.hotspot.replacements.ClassGetHubNode;
import org.graalvm.compiler.hotspot.replacements.HotSpotReplacementsUtil;
import org.graalvm.compiler.hotspot.replacements.HotspotSnippetsOptions;
import org.graalvm.compiler.hotspot.word.KlassPointer;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.DeoptimizeNode;
import org.graalvm.compiler.nodes.PiArrayNode;
import org.graalvm.compiler.nodes.PiNode;
import org.graalvm.compiler.nodes.SnippetAnchorNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.debug.DynamicCounterNode;
import org.graalvm.compiler.nodes.debug.VerifyHeapNode;
import org.graalvm.compiler.nodes.extended.BranchProbabilityNode;
import org.graalvm.compiler.nodes.extended.ForeignCallNode;
import org.graalvm.compiler.nodes.java.DynamicNewArrayNode;
import org.graalvm.compiler.nodes.java.DynamicNewInstanceNode;
import org.graalvm.compiler.nodes.java.NewArrayNode;
import org.graalvm.compiler.nodes.java.NewInstanceNode;
import org.graalvm.compiler.nodes.java.NewMultiArrayNode;
import org.graalvm.compiler.nodes.java.ValidateNewInstanceClassNode;
import org.graalvm.compiler.nodes.spi.LoweringTool;
import org.graalvm.compiler.nodes.util.GraphUtil;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.replacements.AllocationSnippets;
import org.graalvm.compiler.replacements.ReplacementsUtil;
import org.graalvm.compiler.replacements.SnippetCounter;
import org.graalvm.compiler.replacements.SnippetTemplate;
import org.graalvm.compiler.replacements.nodes.CStringConstant;
import org.graalvm.compiler.word.Word;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

public class HotSpotAllocationSnippets
extends AllocationSnippets {
    public static final HotSpotForeignCallDescriptor DYNAMIC_NEW_INSTANCE = new HotSpotForeignCallDescriptor(HotSpotForeignCallDescriptor.Transition.SAFEPOINT, HotSpotForeignCallDescriptor.Reexecutability.REEXECUTABLE, HotSpotForeignCallsProviderImpl.NO_LOCATIONS, "dynamic_new_instance", Object.class, Class.class);
    public static final HotSpotForeignCallDescriptor DYNAMIC_NEW_INSTANCE_OR_NULL = new HotSpotForeignCallDescriptor(HotSpotForeignCallDescriptor.Transition.SAFEPOINT, HotSpotForeignCallDescriptor.Reexecutability.REEXECUTABLE, HotSpotForeignCallsProviderImpl.NO_LOCATIONS, "dynamic_new_instance_or_null", Object.class, Class.class);
    private final GraalHotSpotVMConfig config;
    private final Register threadRegister;

    public HotSpotAllocationSnippets(GraalHotSpotVMConfig config, HotSpotRegistersProvider registers) {
        this.config = config;
        this.threadRegister = registers.getThreadRegister();
    }

    @Snippet
    protected Object allocateInstance(KlassPointer hub, @Snippet.ConstantParameter long size, @Snippet.ConstantParameter AllocationSnippets.FillContent fillContents, @Snippet.ConstantParameter boolean emitMemoryBarrier, @Snippet.ConstantParameter HotSpotAllocationProfilingData profilingData) {
        Object result = this.allocateInstanceImpl(hub.asWord(), WordFactory.unsigned((long)size), fillContents, emitMemoryBarrier, true, profilingData);
        return PiNode.piCastToSnippetReplaceeStamp(result);
    }

    @Snippet
    public Object allocateArray(KlassPointer hub, int length, @Snippet.ConstantParameter int arrayBaseOffset, @Snippet.ConstantParameter int log2ElementSize, @Snippet.ConstantParameter AllocationSnippets.FillContent fillContents, @Snippet.ConstantParameter int fillStartOffset, @Snippet.ConstantParameter boolean emitMemoryBarrier, @Snippet.ConstantParameter boolean maybeUnroll, @Snippet.ConstantParameter boolean supportsBulkZeroing, @Snippet.ConstantParameter boolean supportsOptimizedFilling, @Snippet.ConstantParameter HotSpotAllocationProfilingData profilingData) {
        Object result = this.allocateArrayImpl(hub.asWord(), length, arrayBaseOffset, log2ElementSize, fillContents, fillStartOffset, emitMemoryBarrier, maybeUnroll, supportsBulkZeroing, supportsOptimizedFilling, profilingData);
        return PiArrayNode.piArrayCastToSnippetReplaceeStamp(result, length);
    }

    @Snippet
    public Object allocateInstanceDynamic(@Snippet.NonNullParameter Class<?> type, @Snippet.ConstantParameter AllocationSnippets.FillContent fillContents, @Snippet.ConstantParameter boolean emitMemoryBarrier, @Snippet.ConstantParameter HotSpotAllocationProfilingData profilingData) {
        KlassPointer hub = ClassGetHubNode.readClass(type);
        if (BranchProbabilityNode.probability(0.99, !hub.isNull())) {
            KlassPointer nonNullHub = ClassGetHubNode.piCastNonNull(hub, SnippetAnchorNode.anchor());
            if (BranchProbabilityNode.probability(0.999, HotSpotReplacementsUtil.isInstanceKlassFullyInitialized(nonNullHub))) {
                int layoutHelper = HotSpotReplacementsUtil.readLayoutHelper(nonNullHub);
                if (BranchProbabilityNode.probability(0.99, (layoutHelper & 1) == 0)) {
                    UnsignedWord size = WordFactory.unsigned((int)layoutHelper);
                    return this.allocateInstanceImpl(nonNullHub.asWord(), size, fillContents, emitMemoryBarrier, false, profilingData);
                }
            } else {
                DeoptimizeNode.deopt(DeoptimizationAction.None, DeoptimizationReason.RuntimeConstraint);
            }
        }
        return PiNode.piCastToSnippetReplaceeStamp(HotSpotAllocationSnippets.dynamicNewInstanceStub(type));
    }

    @Snippet
    private static Class<?> validateNewInstanceClass(Class<?> type, Class<?> classClass) {
        Class<?> nonNullType;
        if (BranchProbabilityNode.probability(0.0, type == null)) {
            DeoptimizeNode.deopt(DeoptimizationAction.None, DeoptimizationReason.RuntimeConstraint);
        }
        if (BranchProbabilityNode.probability(0.0, DynamicNewInstanceNode.throwsInstantiationExceptionInjectedProbability(0.0, nonNullType = PiNode.piCastNonNullClass(type, SnippetAnchorNode.anchor()), classClass))) {
            DeoptimizeNode.deopt(DeoptimizationAction.None, DeoptimizationReason.RuntimeConstraint);
        }
        return nonNullType;
    }

    @Snippet
    public Object allocateArrayDynamic(Class<?> elementType, Class<?> voidClass, int length, @Snippet.ConstantParameter AllocationSnippets.FillContent fillContents, @Snippet.ConstantParameter boolean emitMemoryBarrier, @Snippet.ConstantParameter JavaKind knownElementKind, @Snippet.ConstantParameter int knownLayoutHelper, @Snippet.ConstantParameter boolean supportsBulkZeroing, @Snippet.ConstantParameter boolean supportsOptimizedFilling, @Snippet.ConstantParameter HotSpotAllocationProfilingData profilingData) {
        int layoutHelper;
        KlassPointer klass;
        ReplacementsUtil.staticAssert(knownElementKind != JavaKind.Void, "unsupported knownElementKind");
        if (knownElementKind == JavaKind.Illegal) {
            if (BranchProbabilityNode.probability(0.010000000000000009, elementType == null)) {
                DeoptimizeNode.deopt(DeoptimizationAction.None, DeoptimizationReason.RuntimeConstraint);
            }
            if (BranchProbabilityNode.probability(0.010000000000000009, DynamicNewArrayNode.throwsIllegalArgumentException(elementType, voidClass))) {
                DeoptimizeNode.deopt(DeoptimizationAction.None, DeoptimizationReason.RuntimeConstraint);
            }
        }
        if (BranchProbabilityNode.probability(0.0, (klass = HotSpotReplacementsUtil.loadKlassFromObject(elementType, HotSpotReplacementsUtil.arrayKlassOffset(GraalHotSpotVMConfig.INJECTED_VMCONFIG), HotSpotReplacementsUtil.CLASS_ARRAY_KLASS_LOCATION)).isNull())) {
            DeoptimizeNode.deopt(DeoptimizationAction.None, DeoptimizationReason.RuntimeConstraint);
        }
        KlassPointer nonNullKlass = ClassGetHubNode.piCastNonNull(klass, SnippetAnchorNode.anchor());
        if (BranchProbabilityNode.probability(0.0, length < 0)) {
            DeoptimizeNode.deopt(DeoptimizationAction.None, DeoptimizationReason.RuntimeConstraint);
        }
        if (knownElementKind == JavaKind.Illegal) {
            layoutHelper = HotSpotReplacementsUtil.readLayoutHelper(nonNullKlass);
        } else {
            ReplacementsUtil.dynamicAssert(knownLayoutHelper == HotSpotReplacementsUtil.readLayoutHelper(nonNullKlass), "layout mismatch");
            layoutHelper = knownLayoutHelper;
        }
        int arrayBaseOffset = layoutHelper >> HotSpotReplacementsUtil.layoutHelperHeaderSizeShift(GraalHotSpotVMConfig.INJECTED_VMCONFIG) & HotSpotReplacementsUtil.layoutHelperHeaderSizeMask(GraalHotSpotVMConfig.INJECTED_VMCONFIG);
        int log2ElementSize = layoutHelper >> HotSpotReplacementsUtil.layoutHelperLog2ElementSizeShift(GraalHotSpotVMConfig.INJECTED_VMCONFIG) & HotSpotReplacementsUtil.layoutHelperLog2ElementSizeMask(GraalHotSpotVMConfig.INJECTED_VMCONFIG);
        Object result = this.allocateArrayImpl(nonNullKlass.asWord(), length, arrayBaseOffset, log2ElementSize, fillContents, arrayBaseOffset, emitMemoryBarrier, false, supportsBulkZeroing, supportsOptimizedFilling, profilingData);
        return PiArrayNode.piArrayCastToSnippetReplaceeStamp(result, length);
    }

    @Snippet
    protected Object newmultiarray(KlassPointer hub, @Snippet.ConstantParameter int rank, @Snippet.VarargsParameter int[] dimensions) {
        return this.newMultiArrayImpl(hub.asWord(), rank, dimensions);
    }

    @Snippet
    private void verifyHeap() {
        Word topValueContents;
        Word tlabInfo = this.getTLABInfo();
        Word topValue = this.readTlabTop(tlabInfo);
        if (!topValue.equal((Word)WordFactory.zero()) && (topValueContents = (Word)topValue.readWord(0, HotSpotReplacementsUtil.MARK_WORD_LOCATION)).equal((Word)WordFactory.zero())) {
            AssertionSnippets.vmMessageC(AssertionSnippets.ASSERTION_VM_MESSAGE_C, true, CStringConstant.cstring("overzeroing of TLAB detected"), 0L, 0L, 0L);
        }
    }

    @Snippet
    private void threadBeingInitializedCheck(KlassPointer klass) {
        byte state = HotSpotReplacementsUtil.readInstanceKlassInitState(klass);
        if (state != HotSpotReplacementsUtil.instanceKlassStateBeingInitialized(GraalHotSpotVMConfig.INJECTED_VMCONFIG)) {
            DeoptimizeNode.deopt(DeoptimizationAction.InvalidateRecompile, DeoptimizationReason.RuntimeConstraint);
        } else if (this.getThread() != HotSpotReplacementsUtil.readInstanceKlassInitThread(klass)) {
            DeoptimizeNode.deopt(DeoptimizationAction.None, DeoptimizationReason.RuntimeConstraint);
        }
    }

    @Override
    protected final int getPrefetchStyle() {
        return HotSpotReplacementsUtil.allocatePrefetchStyle(GraalHotSpotVMConfig.INJECTED_VMCONFIG);
    }

    @Override
    protected final int getPrefetchLines(boolean isArray) {
        if (isArray) {
            return HotSpotReplacementsUtil.allocatePrefetchLines(GraalHotSpotVMConfig.INJECTED_VMCONFIG);
        }
        return HotSpotReplacementsUtil.allocateInstancePrefetchLines(GraalHotSpotVMConfig.INJECTED_VMCONFIG);
    }

    @Override
    protected final int getPrefetchStepSize() {
        return HotSpotReplacementsUtil.allocatePrefetchStepSize(GraalHotSpotVMConfig.INJECTED_VMCONFIG);
    }

    @Override
    protected final int getPrefetchDistance() {
        return HotSpotReplacementsUtil.allocatePrefetchDistance(GraalHotSpotVMConfig.INJECTED_VMCONFIG);
    }

    @Override
    protected final Object callNewInstanceStub(Word hub) {
        KlassPointer klassPtr = KlassPointer.fromWord(hub);
        if (HotSpotAllocationSnippets.useNullAllocationStubs(GraalHotSpotVMConfig.INJECTED_VMCONFIG)) {
            return HotSpotAllocationSnippets.nonNullOrDeopt(HotSpotAllocationSnippets.newInstanceOrNull(HotSpotBackend.NEW_INSTANCE_OR_NULL, klassPtr));
        }
        return HotSpotAllocationSnippets.newInstance(HotSpotBackend.NEW_INSTANCE, klassPtr);
    }

    @Node.NodeIntrinsic(value=ForeignCallNode.class, injectedStampIsNonNull=true)
    private static native Object newInstance(@Node.ConstantNodeParameter ForeignCallDescriptor var0, KlassPointer var1);

    @Node.NodeIntrinsic(value=ForeignCallNode.class, injectedStampIsNonNull=false)
    private static native Object newInstanceOrNull(@Node.ConstantNodeParameter ForeignCallDescriptor var0, KlassPointer var1);

    @Fold
    static boolean useNullAllocationStubs(@Fold.InjectedParameter GraalHotSpotVMConfig config) {
        return config.areNullAllocationStubsAvailable();
    }

    @Override
    protected final Object callNewArrayStub(Word hub, int length) {
        KlassPointer klassPtr = KlassPointer.fromWord(hub);
        if (HotSpotAllocationSnippets.useNullAllocationStubs(GraalHotSpotVMConfig.INJECTED_VMCONFIG)) {
            return HotSpotAllocationSnippets.nonNullOrDeopt(HotSpotAllocationSnippets.newArrayOrNull(HotSpotBackend.NEW_ARRAY_OR_NULL, klassPtr, length));
        }
        return HotSpotAllocationSnippets.newArray(HotSpotBackend.NEW_ARRAY, klassPtr, length);
    }

    @Node.NodeIntrinsic(value=ForeignCallNode.class, injectedStampIsNonNull=true)
    private static native Object newArray(@Node.ConstantNodeParameter ForeignCallDescriptor var0, KlassPointer var1, int var2);

    @Node.NodeIntrinsic(value=ForeignCallNode.class, injectedStampIsNonNull=false)
    private static native Object newArrayOrNull(@Node.ConstantNodeParameter ForeignCallDescriptor var0, KlassPointer var1, int var2);

    private static Object nonNullOrDeopt(Object obj) {
        if (BranchProbabilityNode.probability(0.0, obj == null)) {
            DeoptimizeNode.deopt(DeoptimizationAction.None, DeoptimizationReason.RuntimeConstraint);
        }
        return obj;
    }

    public static Object dynamicNewInstanceStub(Class<?> elementType) {
        if (HotSpotAllocationSnippets.useNullAllocationStubs(GraalHotSpotVMConfig.INJECTED_VMCONFIG)) {
            return HotSpotAllocationSnippets.nonNullOrDeopt(HotSpotAllocationSnippets.dynamicNewInstanceOrNull(DYNAMIC_NEW_INSTANCE_OR_NULL, elementType));
        }
        return HotSpotAllocationSnippets.dynamicNewInstance(DYNAMIC_NEW_INSTANCE, elementType);
    }

    @Node.NodeIntrinsic(value=ForeignCallNode.class, injectedStampIsNonNull=true)
    public static native Object dynamicNewInstance(@Node.ConstantNodeParameter ForeignCallDescriptor var0, Class<?> var1);

    @Node.NodeIntrinsic(value=ForeignCallNode.class, injectedStampIsNonNull=false)
    public static native Object dynamicNewInstanceOrNull(@Node.ConstantNodeParameter ForeignCallDescriptor var0, Class<?> var1);

    @Override
    protected final Object callNewMultiArrayStub(Word hub, int rank, Word dims) {
        KlassPointer klassPointer = KlassPointer.fromWord(hub);
        if (HotSpotAllocationSnippets.useNullAllocationStubs(GraalHotSpotVMConfig.INJECTED_VMCONFIG)) {
            return HotSpotAllocationSnippets.nonNullOrDeopt(HotSpotAllocationSnippets.newMultiArrayOrNull(HotSpotBackend.NEW_MULTI_ARRAY_OR_NULL, klassPointer, rank, dims));
        }
        return HotSpotAllocationSnippets.newMultiArray(HotSpotBackend.NEW_MULTI_ARRAY, klassPointer, rank, dims);
    }

    @Node.NodeIntrinsic(value=ForeignCallNode.class, injectedStampIsNonNull=true)
    private static native Object newMultiArray(@Node.ConstantNodeParameter ForeignCallDescriptor var0, KlassPointer var1, int var2, Word var3);

    @Node.NodeIntrinsic(value=ForeignCallNode.class, injectedStampIsNonNull=false)
    private static native Object newMultiArrayOrNull(@Node.ConstantNodeParameter ForeignCallDescriptor var0, KlassPointer var1, int var2, Word var3);

    @Fold
    static int getMinimalBulkZeroingSize(@Fold.InjectedParameter OptionValues optionValues) {
        return GraalOptions.MinimalBulkZeroingSize.getValue(optionValues);
    }

    @Override
    protected final int getMinimalBulkZeroingSize() {
        return HotSpotAllocationSnippets.getMinimalBulkZeroingSize(GraalHotSpotVMConfig.INJECTED_OPTIONVALUES);
    }

    @Override
    public final void initializeObjectHeader(Word memory, Word hub, boolean isArray) {
        KlassPointer klassPtr = KlassPointer.fromWord(hub);
        Word markWord = !isArray && HotSpotReplacementsUtil.useBiasedLocking(GraalHotSpotVMConfig.INJECTED_VMCONFIG) ? klassPtr.readWord(HotSpotReplacementsUtil.prototypeMarkWordOffset(GraalHotSpotVMConfig.INJECTED_VMCONFIG), HotSpotReplacementsUtil.PROTOTYPE_MARK_WORD_LOCATION) : (Word)WordFactory.signed((long)HotSpotReplacementsUtil.defaultPrototypeMarkWord(GraalHotSpotVMConfig.INJECTED_VMCONFIG));
        HotSpotReplacementsUtil.initializeObjectHeader(memory, markWord, klassPtr);
    }

    @Override
    protected final int instanceHeaderSize() {
        return HotSpotReplacementsUtil.instanceHeaderSize(GraalHotSpotVMConfig.INJECTED_VMCONFIG);
    }

    @Override
    public final int arrayLengthOffset() {
        return HotSpotReplacementsUtil.arrayLengthOffset(GraalHotSpotVMConfig.INJECTED_VMCONFIG);
    }

    @Override
    protected final int objectAlignment() {
        return HotSpotReplacementsUtil.objectAlignment(GraalHotSpotVMConfig.INJECTED_VMCONFIG);
    }

    @Override
    public final boolean useTLAB() {
        return HotSpotReplacementsUtil.useTLAB(GraalHotSpotVMConfig.INJECTED_VMCONFIG);
    }

    @Override
    protected final boolean shouldAllocateInTLAB(UnsignedWord allocationSize, boolean isArray) {
        if (HotSpotReplacementsUtil.useG1GC(GraalHotSpotVMConfig.INJECTED_VMCONFIG)) {
            return true;
        }
        return !isArray || allocationSize.belowThan(0x1000000);
    }

    @Override
    public final Word getTLABInfo() {
        return this.getThread();
    }

    private Word getThread() {
        return HotSpotReplacementsUtil.registerAsWord(this.threadRegister);
    }

    @Override
    public final Word readTlabEnd(Word thread) {
        return HotSpotReplacementsUtil.readTlabEnd(thread);
    }

    @Override
    public final Word readTlabTop(Word thread) {
        return HotSpotReplacementsUtil.readTlabTop(thread);
    }

    @Override
    public final void writeTlabTop(Word thread, Word newTop) {
        HotSpotReplacementsUtil.writeTlabTop(thread, newTop);
    }

    @Override
    protected final Object verifyOop(Object obj) {
        return HotSpotReplacementsUtil.verifyOop(obj);
    }

    @Override
    protected final void profileAllocation(AllocationSnippets.AllocationProfilingData profilingData, UnsignedWord size) {
        if (HotSpotAllocationSnippets.doProfile(GraalHotSpotVMConfig.INJECTED_OPTIONVALUES)) {
            String name = HotSpotAllocationSnippets.createName(GraalHotSpotVMConfig.INJECTED_OPTIONVALUES, profilingData);
            boolean context = HotSpotAllocationSnippets.withContext(GraalHotSpotVMConfig.INJECTED_OPTIONVALUES);
            DynamicCounterNode.counter("number of bytes allocated", name, size.rawValue(), context);
            DynamicCounterNode.counter("number of allocations", name, 1L, context);
        }
    }

    @Fold
    static boolean doProfile(@Fold.InjectedParameter OptionValues options) {
        return HotspotSnippetsOptions.ProfileAllocations.getValue(options);
    }

    @Fold
    static String createName(@Fold.InjectedParameter OptionValues options, AllocationSnippets.AllocationProfilingData profilingData) {
        HotSpotAllocationProfilingData hotspotAllocationProfilingData = (HotSpotAllocationProfilingData)profilingData;
        switch ((ProfileContext)((Object)HotspotSnippetsOptions.ProfileAllocationsContext.getValue(options))) {
            case AllocatingMethod: {
                return "";
            }
            case InstanceOrArray: {
                return hotspotAllocationProfilingData.path;
            }
            case AllocatedType: 
            case AllocatedTypesInMethod: {
                return hotspotAllocationProfilingData.typeContext;
            }
            case Total: {
                return "bytes";
            }
        }
        throw GraalError.shouldNotReachHere();
    }

    @Fold
    static boolean withContext(@Fold.InjectedParameter OptionValues options) {
        ProfileContext context = (ProfileContext)((Object)HotspotSnippetsOptions.ProfileAllocationsContext.getValue(options));
        return context == ProfileContext.AllocatingMethod || context == ProfileContext.AllocatedTypesInMethod;
    }

    static HotSpotResolvedObjectType lookupArrayClass(MetaAccessProvider metaAccessProvider, JavaKind kind) {
        return (HotSpotResolvedObjectType)metaAccessProvider.lookupJavaType(kind == JavaKind.Object ? Object.class : kind.toJavaClass()).getArrayClass();
    }

    private static class HotSpotAllocationProfilingData
    extends AllocationSnippets.AllocationProfilingData {
        String path;
        String typeContext;

        HotSpotAllocationProfilingData(AllocationSnippets.AllocationSnippetCounters snippetCounters, String path, String typeContext) {
            super(snippetCounters);
            this.path = path;
            this.typeContext = typeContext;
        }
    }

    static enum ProfileContext {
        AllocatingMethod,
        InstanceOrArray,
        AllocatedType,
        AllocatedTypesInMethod,
        Total;

    }

    public static class Templates
    extends SnippetTemplate.AbstractTemplates {
        private final GraalHotSpotVMConfig config;
        private final AllocationSnippets.AllocationSnippetCounters snippetCounters;
        private HotSpotAllocationProfilingData profilingData;
        private final SnippetTemplate.SnippetInfo allocateInstance;
        private final SnippetTemplate.SnippetInfo allocateArray;
        private final SnippetTemplate.SnippetInfo allocateArrayDynamic;
        private final SnippetTemplate.SnippetInfo allocateInstanceDynamic;
        private final SnippetTemplate.SnippetInfo validateNewInstanceClass;
        private final SnippetTemplate.SnippetInfo newmultiarray;
        private final SnippetTemplate.SnippetInfo verifyHeap;
        private final SnippetTemplate.SnippetInfo threadBeingInitializedCheck;

        public Templates(HotSpotAllocationSnippets receiver, OptionValues options, SnippetCounter.Group.Factory groupFactory, HotSpotProviders providers, GraalHotSpotVMConfig config) {
            super(options, providers);
            this.config = config;
            this.snippetCounters = new AllocationSnippets.AllocationSnippetCounters(groupFactory);
            this.allocateInstance = this.snippet((Providers)providers, HotSpotAllocationSnippets.class, "allocateInstance", null, receiver, HotSpotReplacementsUtil.MARK_WORD_LOCATION, HotSpotReplacementsUtil.HUB_WRITE_LOCATION, HotSpotReplacementsUtil.TLAB_TOP_LOCATION, HotSpotReplacementsUtil.TLAB_END_LOCATION, HotSpotReplacementsUtil.PROTOTYPE_MARK_WORD_LOCATION);
            this.allocateArray = this.snippet((Providers)providers, HotSpotAllocationSnippets.class, "allocateArray", null, receiver, HotSpotReplacementsUtil.MARK_WORD_LOCATION, HotSpotReplacementsUtil.HUB_WRITE_LOCATION, HotSpotReplacementsUtil.TLAB_TOP_LOCATION, HotSpotReplacementsUtil.TLAB_END_LOCATION);
            this.allocateArrayDynamic = this.snippet((Providers)providers, HotSpotAllocationSnippets.class, "allocateArrayDynamic", null, receiver, HotSpotReplacementsUtil.MARK_WORD_LOCATION, HotSpotReplacementsUtil.HUB_WRITE_LOCATION, HotSpotReplacementsUtil.TLAB_TOP_LOCATION, HotSpotReplacementsUtil.TLAB_END_LOCATION);
            this.allocateInstanceDynamic = this.snippet((Providers)providers, HotSpotAllocationSnippets.class, "allocateInstanceDynamic", null, receiver, HotSpotReplacementsUtil.MARK_WORD_LOCATION, HotSpotReplacementsUtil.HUB_WRITE_LOCATION, HotSpotReplacementsUtil.TLAB_TOP_LOCATION, HotSpotReplacementsUtil.TLAB_END_LOCATION, HotSpotReplacementsUtil.PROTOTYPE_MARK_WORD_LOCATION, HotSpotReplacementsUtil.CLASS_INIT_STATE_LOCATION);
            this.validateNewInstanceClass = this.snippet((Providers)providers, HotSpotAllocationSnippets.class, "validateNewInstanceClass", HotSpotReplacementsUtil.MARK_WORD_LOCATION, HotSpotReplacementsUtil.HUB_WRITE_LOCATION, HotSpotReplacementsUtil.TLAB_TOP_LOCATION, HotSpotReplacementsUtil.TLAB_END_LOCATION, HotSpotReplacementsUtil.PROTOTYPE_MARK_WORD_LOCATION, HotSpotReplacementsUtil.CLASS_INIT_STATE_LOCATION);
            this.newmultiarray = this.snippet((Providers)providers, HotSpotAllocationSnippets.class, "newmultiarray", null, receiver, HotSpotReplacementsUtil.TLAB_TOP_LOCATION, HotSpotReplacementsUtil.TLAB_END_LOCATION);
            this.verifyHeap = this.snippet((Providers)providers, HotSpotAllocationSnippets.class, "verifyHeap", null, receiver, new LocationIdentity[0]);
            this.threadBeingInitializedCheck = this.snippet((Providers)providers, HotSpotAllocationSnippets.class, "threadBeingInitializedCheck", null, receiver, HotSpotReplacementsUtil.CLASS_INIT_STATE_LOCATION, HotSpotReplacementsUtil.CLASS_INIT_THREAD_LOCATION);
        }

        private HotSpotAllocationProfilingData getProfilingData(OptionValues localOptions, String path, ResolvedJavaType type) {
            if (HotspotSnippetsOptions.ProfileAllocations.getValue(localOptions).booleanValue()) {
                String typeContext = type == null ? null : type.toJavaName(false);
                return new HotSpotAllocationProfilingData(this.snippetCounters, path, typeContext);
            }
            if (this.profilingData == null) {
                this.profilingData = new HotSpotAllocationProfilingData(this.snippetCounters, null, null);
            }
            return this.profilingData;
        }

        public void lower(NewInstanceNode node, LoweringTool tool) {
            StructuredGraph graph = node.graph();
            HotSpotResolvedObjectType type = (HotSpotResolvedObjectType)node.instanceClass();
            assert (!type.isArray());
            ConstantNode hub = ConstantNode.forConstant(KlassPointerStamp.klassNonNull(), type.klass(), tool.getMetaAccess(), graph);
            long size = Templates.instanceSize(type);
            OptionValues localOptions = graph.getOptions();
            SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(this.allocateInstance, graph.getGuardsStage(), tool.getLoweringStage());
            args.add("hub", hub);
            args.addConst("size", size);
            args.addConst("fillContents", (Object)AllocationSnippets.FillContent.fromBoolean(node.fillContents()));
            args.addConst("emitMemoryBarrier", node.emitMemoryBarrier());
            args.addConst("profilingData", this.getProfilingData(localOptions, "instance", (ResolvedJavaType)type));
            SnippetTemplate template = this.template(tool, node, args);
            graph.getDebug().log("Lowering allocateInstance in %s: node=%s, template=%s, arguments=%s", graph, (Object)node, (Object)template, (Object)args);
            template.instantiate(tool.getMetaAccess(), node, SnippetTemplate.DEFAULT_REPLACER, args);
        }

        public void lower(NewArrayNode node, LoweringTool tool) {
            StructuredGraph graph = node.graph();
            ResolvedJavaType elementType = node.elementType();
            HotSpotResolvedObjectType arrayType = (HotSpotResolvedObjectType)elementType.getArrayClass();
            JavaKind elementKind = elementType.getJavaKind();
            ConstantNode hub = ConstantNode.forConstant(KlassPointerStamp.klassNonNull(), arrayType.klass(), tool.getMetaAccess(), graph);
            int arrayBaseOffset = tool.getMetaAccess().getArrayBaseOffset(elementKind);
            int log2ElementSize = CodeUtil.log2((int)tool.getMetaAccess().getArrayIndexScale(elementKind));
            OptionValues localOptions = graph.getOptions();
            SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(this.allocateArray, graph.getGuardsStage(), tool.getLoweringStage());
            args.add("hub", hub);
            ValueNode length = node.length();
            args.add("length", length.isAlive() ? length : graph.addOrUniqueWithInputs(length));
            args.addConst("arrayBaseOffset", arrayBaseOffset);
            args.addConst("log2ElementSize", log2ElementSize);
            args.addConst("fillContents", (Object)AllocationSnippets.FillContent.fromBoolean(node.fillContents()));
            args.addConst("fillStartOffset", arrayBaseOffset);
            args.addConst("emitMemoryBarrier", node.emitMemoryBarrier());
            args.addConst("maybeUnroll", length.isConstant());
            args.addConst("supportsBulkZeroing", tool.getLowerer().supportsBulkZeroing());
            args.addConst("supportsOptimizedFilling", tool.getLowerer().supportsOptimizedFilling(localOptions));
            args.addConst("profilingData", this.getProfilingData(localOptions, "array", (ResolvedJavaType)arrayType));
            SnippetTemplate template = this.template(tool, node, args);
            graph.getDebug().log("Lowering allocateArray in %s: node=%s, template=%s, arguments=%s", graph, (Object)node, (Object)template, (Object)args);
            template.instantiate(tool.getMetaAccess(), node, SnippetTemplate.DEFAULT_REPLACER, args);
        }

        public void lower(NewMultiArrayNode node, LoweringTool tool) {
            StructuredGraph graph = node.graph();
            int rank = node.dimensionCount();
            ValueNode[] dims = new ValueNode[rank];
            for (int i = 0; i < node.dimensionCount(); ++i) {
                dims[i] = node.dimension(i);
            }
            HotSpotResolvedObjectType type = (HotSpotResolvedObjectType)node.type();
            ConstantNode hub = ConstantNode.forConstant(KlassPointerStamp.klassNonNull(), type.klass(), tool.getMetaAccess(), graph);
            SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(this.newmultiarray, graph.getGuardsStage(), tool.getLoweringStage());
            args.add("hub", hub);
            args.addConst("rank", rank);
            args.addVarargs("dimensions", Integer.TYPE, StampFactory.forKind(JavaKind.Int), dims);
            this.template(tool, node, args).instantiate(tool.getMetaAccess(), node, SnippetTemplate.DEFAULT_REPLACER, args);
        }

        public void lower(DynamicNewInstanceNode node, LoweringTool tool) {
            OptionValues localOptions = node.graph().getOptions();
            SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(this.allocateInstanceDynamic, node.graph().getGuardsStage(), tool.getLoweringStage());
            args.add("type", node.getInstanceType());
            args.addConst("fillContents", (Object)AllocationSnippets.FillContent.fromBoolean(node.fillContents()));
            args.addConst("emitMemoryBarrier", node.emitMemoryBarrier());
            args.addConst("profilingData", this.getProfilingData(localOptions, "", null));
            this.template(tool, node, args).instantiate(tool.getMetaAccess(), node, SnippetTemplate.DEFAULT_REPLACER, args);
        }

        public void lower(ValidateNewInstanceClassNode node, LoweringTool tool) {
            StructuredGraph graph = node.graph();
            SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(this.validateNewInstanceClass, graph.getGuardsStage(), tool.getLoweringStage());
            args.add("type", node.getInstanceType());
            args.add("classClass", node.getClassClass());
            this.template(tool, node, args).instantiate(tool.getMetaAccess(), node, SnippetTemplate.DEFAULT_REPLACER, args);
        }

        public void lower(DynamicNewArrayNode node, LoweringTool tool) {
            StructuredGraph graph = node.graph();
            OptionValues localOptions = graph.getOptions();
            ValueNode length = node.length();
            ValueNode voidClass = node.getVoidClass();
            assert (voidClass != null);
            SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(this.allocateArrayDynamic, graph.getGuardsStage(), tool.getLoweringStage());
            args.add("elementType", node.getElementType());
            args.add("voidClass", voidClass);
            args.add("length", length.isAlive() ? length : graph.addOrUniqueWithInputs(length));
            args.addConst("fillContents", (Object)AllocationSnippets.FillContent.fromBoolean(node.fillContents()));
            args.addConst("emitMemoryBarrier", node.emitMemoryBarrier());
            args.addConst("knownElementKind", node.getKnownElementKind() == null ? JavaKind.Illegal : node.getKnownElementKind());
            if (node.getKnownElementKind() != null) {
                args.addConst("knownLayoutHelper", Templates.lookupArrayClass(tool, node.getKnownElementKind()).layoutHelper());
            } else {
                args.addConst("knownLayoutHelper", 0);
            }
            args.addConst("supportsBulkZeroing", tool.getLowerer().supportsBulkZeroing());
            args.addConst("supportsOptimizedFilling", tool.getLowerer().supportsOptimizedFilling(localOptions));
            args.addConst("profilingData", this.getProfilingData(localOptions, "dynamic type", null));
            this.template(tool, node, args).instantiate(tool.getMetaAccess(), node, SnippetTemplate.DEFAULT_REPLACER, args);
        }

        public void lower(VerifyHeapNode node, LoweringTool tool) {
            if (this.config.cAssertions) {
                SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(this.verifyHeap, node.graph().getGuardsStage(), tool.getLoweringStage());
                this.template(tool, node, args).instantiate(tool.getMetaAccess(), node, SnippetTemplate.DEFAULT_REPLACER, args);
            } else {
                GraphUtil.removeFixedWithUnusedInputs(node);
            }
        }

        public void lower(KlassBeingInitializedCheckNode node, LoweringTool tool) {
            SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(this.threadBeingInitializedCheck, node.graph().getGuardsStage(), tool.getLoweringStage());
            args.add("klass", node.getKlass());
            this.template(tool, node, args).instantiate(tool.getMetaAccess(), node, SnippetTemplate.DEFAULT_REPLACER, args);
        }

        private static HotSpotResolvedObjectType lookupArrayClass(LoweringTool tool, JavaKind kind) {
            return HotSpotAllocationSnippets.lookupArrayClass(tool.getMetaAccess(), kind);
        }

        private static long instanceSize(HotSpotResolvedObjectType type) {
            long size = type.instanceSize();
            assert (size >= 0L);
            return size;
        }
    }
}

