/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.replacements;

import org.graalvm.compiler.hotspot.GraalHotSpotVMConfig;
import org.graalvm.compiler.hotspot.meta.HotSpotProviders;
import org.graalvm.compiler.hotspot.replacements.HotSpotReplacementsUtil;
import org.graalvm.compiler.nodes.gc.SerialArrayRangeWriteBarrier;
import org.graalvm.compiler.nodes.gc.SerialWriteBarrier;
import org.graalvm.compiler.nodes.spi.LoweringTool;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.replacements.ReplacementsUtil;
import org.graalvm.compiler.replacements.SnippetCounter;
import org.graalvm.compiler.replacements.SnippetTemplate;
import org.graalvm.compiler.replacements.gc.SerialWriteBarrierSnippets;
import org.graalvm.compiler.replacements.gc.WriteBarrierSnippets;
import org.graalvm.compiler.word.Word;
import org.graalvm.word.WordFactory;

public class HotSpotSerialWriteBarrierSnippets
extends SerialWriteBarrierSnippets {
    @Override
    public Word cardTableAddress() {
        return (Word)WordFactory.unsigned((long)HotSpotReplacementsUtil.cardTableStart(GraalHotSpotVMConfig.INJECTED_VMCONFIG));
    }

    @Override
    public int cardTableShift() {
        return HotSpotReplacementsUtil.cardTableShift(GraalHotSpotVMConfig.INJECTED_VMCONFIG);
    }

    @Override
    public boolean verifyBarrier() {
        return ReplacementsUtil.REPLACEMENTS_ASSERTIONS_ENABLED || HotSpotReplacementsUtil.verifyBeforeOrAfterGC(GraalHotSpotVMConfig.INJECTED_VMCONFIG);
    }

    @Override
    protected byte dirtyCardValue() {
        return HotSpotReplacementsUtil.dirtyCardValue(GraalHotSpotVMConfig.INJECTED_VMCONFIG);
    }

    public static class Templates
    extends SnippetTemplate.AbstractTemplates {
        private final SnippetTemplate.SnippetInfo serialImpreciseWriteBarrier;
        private final SnippetTemplate.SnippetInfo serialPreciseWriteBarrier;
        private final SnippetTemplate.SnippetInfo serialArrayRangeWriteBarrier;
        private final SerialWriteBarrierSnippets.SerialWriteBarrierLowerer lowerer;

        public Templates(OptionValues options, SnippetCounter.Group.Factory factory, HotSpotProviders providers) {
            super(options, providers);
            this.lowerer = new SerialWriteBarrierSnippets.SerialWriteBarrierLowerer(factory);
            HotSpotSerialWriteBarrierSnippets receiver = new HotSpotSerialWriteBarrierSnippets();
            this.serialImpreciseWriteBarrier = this.snippet((Providers)providers, SerialWriteBarrierSnippets.class, "serialImpreciseWriteBarrier", null, receiver, WriteBarrierSnippets.GC_CARD_LOCATION);
            this.serialPreciseWriteBarrier = this.snippet((Providers)providers, SerialWriteBarrierSnippets.class, "serialPreciseWriteBarrier", null, receiver, WriteBarrierSnippets.GC_CARD_LOCATION);
            this.serialArrayRangeWriteBarrier = this.snippet((Providers)providers, SerialWriteBarrierSnippets.class, "serialArrayRangeWriteBarrier", null, receiver, WriteBarrierSnippets.GC_CARD_LOCATION);
        }

        public void lower(SerialWriteBarrier barrier, LoweringTool tool) {
            this.lowerer.lower(this, this.serialPreciseWriteBarrier, this.serialImpreciseWriteBarrier, barrier, tool);
        }

        public void lower(SerialArrayRangeWriteBarrier barrier, LoweringTool tool) {
            this.lowerer.lower(this, this.serialArrayRangeWriteBarrier, barrier, tool);
        }
    }
}

