/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.stubs;

import jdk.vm.ci.code.Register;
import org.graalvm.compiler.api.replacements.Snippet;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.hotspot.HotSpotForeignCallLinkage;
import org.graalvm.compiler.hotspot.meta.HotSpotProviders;
import org.graalvm.compiler.hotspot.stubs.CreateExceptionStub;
import org.graalvm.compiler.options.OptionValues;

public class NullPointerExceptionStub
extends CreateExceptionStub {
    public NullPointerExceptionStub(OptionValues options, HotSpotProviders providers, HotSpotForeignCallLinkage linkage) {
        super("createNullPointerException", options, providers, linkage);
    }

    @Override
    protected Object getConstantParameterValue(int index, String name) {
        GraalError.guarantee(index == 0, "unknown parameter %s at index %d", (Object)name, (Object)index);
        return this.providers.getRegisters().getThreadRegister();
    }

    @Snippet
    private static Object createNullPointerException(@Snippet.ConstantParameter Register threadRegister) {
        return NullPointerExceptionStub.createException(threadRegister, NullPointerException.class);
    }
}

