/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir;

import java.util.Arrays;
import java.util.EnumSet;
import jdk.vm.ci.code.BytecodeFrame;
import jdk.vm.ci.code.BytecodePosition;
import jdk.vm.ci.code.DebugInfo;
import jdk.vm.ci.code.StackLockValue;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.code.VirtualObject;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.JavaValue;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.lir.InstructionValueConsumer;
import org.graalvm.compiler.lir.InstructionValueProcedure;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRValueUtil;
import org.graalvm.compiler.lir.LabelRef;
import org.graalvm.compiler.lir.util.IndexedValueMap;

public class LIRFrameState {
    public static final LIRFrameState NO_CALLEE_SAVE_INFO = new LIRFrameState(null, null, null, false);
    public final BytecodeFrame topFrame;
    private final VirtualObject[] virtualObjects;
    public final LabelRef exceptionEdge;
    protected DebugInfo debugInfo;
    private IndexedValueMap liveBasePointers;
    public final boolean validForDeoptimization;
    protected static final EnumSet<LIRInstruction.OperandFlag> STATE_FLAGS = EnumSet.of(LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.STACK);

    public LIRFrameState(BytecodeFrame topFrame, VirtualObject[] virtualObjects, LabelRef exceptionEdge, boolean validForDeoptimization) {
        this.topFrame = topFrame;
        this.virtualObjects = virtualObjects;
        this.exceptionEdge = exceptionEdge;
        this.validForDeoptimization = validForDeoptimization;
    }

    public boolean hasDebugInfo() {
        return this.debugInfo != null;
    }

    public DebugInfo debugInfo() {
        assert (this.debugInfo != null) : "debug info not allocated yet";
        return this.debugInfo;
    }

    public void forEachState(LIRInstruction inst, InstructionValueProcedure proc) {
        for (BytecodeFrame cur = this.topFrame; cur != null; cur = cur.caller()) {
            this.processValues(inst, cur.values, proc);
        }
        if (this.virtualObjects != null) {
            for (VirtualObject obj : this.virtualObjects) {
                this.processValues(inst, obj.getValues(), proc);
            }
        }
        if (this.liveBasePointers != null) {
            this.liveBasePointers.forEach(inst, LIRInstruction.OperandMode.ALIVE, STATE_FLAGS, proc);
        }
    }

    public void visitEachState(LIRInstruction inst, InstructionValueConsumer proc) {
        for (BytecodeFrame cur = this.topFrame; cur != null; cur = cur.caller()) {
            this.visitValues(inst, cur.values, proc);
        }
        if (this.virtualObjects != null) {
            for (VirtualObject obj : this.virtualObjects) {
                this.visitValues(inst, obj.getValues(), proc);
            }
        }
        if (this.liveBasePointers != null) {
            this.liveBasePointers.visitEach(inst, LIRInstruction.OperandMode.ALIVE, STATE_FLAGS, proc);
        }
    }

    protected void processValues(LIRInstruction inst, JavaValue[] values, InstructionValueProcedure proc) {
        for (int i = 0; i < values.length; ++i) {
            JavaValue value = values[i];
            if (ValueUtil.isIllegalJavaValue((JavaValue)value)) continue;
            if (value instanceof AllocatableValue) {
                AllocatableValue allocatable = (AllocatableValue)value;
                Value result = proc.doValue(inst, (Value)allocatable, LIRInstruction.OperandMode.ALIVE, STATE_FLAGS);
                if (allocatable.identityEquals(result)) continue;
                values[i] = (JavaValue)result;
                continue;
            }
            if (value instanceof StackLockValue) {
                AllocatableValue slot;
                StackLockValue monitor = (StackLockValue)value;
                JavaValue owner = monitor.getOwner();
                if (owner instanceof AllocatableValue) {
                    monitor.setOwner((JavaValue)proc.doValue(inst, (Value)((AllocatableValue)owner), LIRInstruction.OperandMode.ALIVE, STATE_FLAGS));
                }
                if (!LIRValueUtil.isVirtualStackSlot((Value)(slot = monitor.getSlot()))) continue;
                monitor.setSlot(ValueUtil.asAllocatableValue((Value)proc.doValue(inst, (Value)slot, LIRInstruction.OperandMode.ALIVE, STATE_FLAGS)));
                continue;
            }
            assert (this.unprocessed(value));
        }
    }

    protected void visitValues(LIRInstruction inst, JavaValue[] values, InstructionValueConsumer proc) {
        for (int i = 0; i < values.length; ++i) {
            JavaValue value = values[i];
            if (ValueUtil.isIllegalJavaValue((JavaValue)value)) continue;
            if (value instanceof AllocatableValue) {
                proc.visitValue(inst, (Value)((AllocatableValue)value), LIRInstruction.OperandMode.ALIVE, STATE_FLAGS);
                continue;
            }
            if (value instanceof StackLockValue) {
                AllocatableValue slot;
                StackLockValue monitor = (StackLockValue)value;
                JavaValue owner = monitor.getOwner();
                if (owner instanceof AllocatableValue) {
                    proc.visitValue(inst, (Value)((AllocatableValue)owner), LIRInstruction.OperandMode.ALIVE, STATE_FLAGS);
                }
                if (!LIRValueUtil.isVirtualStackSlot((Value)(slot = monitor.getSlot()))) continue;
                proc.visitValue(inst, (Value)slot, LIRInstruction.OperandMode.ALIVE, STATE_FLAGS);
                continue;
            }
            assert (this.unprocessed(value));
        }
    }

    private boolean unprocessed(JavaValue value) {
        if (ValueUtil.isIllegalJavaValue((JavaValue)value)) {
            return true;
        }
        if (ValueUtil.isConstantJavaValue((JavaValue)value)) {
            return true;
        }
        if (ValueUtil.isVirtualObject((JavaValue)value)) {
            assert (Arrays.asList(this.virtualObjects).contains(value));
            return true;
        }
        return false;
    }

    public void initDebugInfo() {
        this.debugInfo = new DebugInfo((BytecodePosition)this.topFrame, this.virtualObjects);
    }

    public IndexedValueMap getLiveBasePointers() {
        return this.liveBasePointers;
    }

    public void setLiveBasePointers(IndexedValueMap liveBasePointers) {
        this.liveBasePointers = liveBasePointers;
    }

    public String toString() {
        return this.debugInfo != null ? this.debugInfo.toString() : (this.topFrame != null ? this.topFrame.toString() : "<empty>");
    }
}

