/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.aarch64;

import jdk.vm.ci.aarch64.AArch64;
import jdk.vm.ci.aarch64.AArch64Kind;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.asm.Label;
import org.graalvm.compiler.asm.aarch64.AArch64Address;
import org.graalvm.compiler.asm.aarch64.AArch64Assembler;
import org.graalvm.compiler.asm.aarch64.AArch64MacroAssembler;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.StubPort;
import org.graalvm.compiler.lir.StubPorts;
import org.graalvm.compiler.lir.aarch64.AArch64LIRInstruction;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;
import org.graalvm.compiler.lir.gen.LIRGeneratorTool;

@StubPorts(value={@StubPort(path="src/hotspot/cpu/aarch64/stubGenerator_aarch64.cpp", lineStart=4648, lineEnd=4667, commit="afda8fbf0bcea18cbe741e9c693789ebe0c6c4c5", sha1="4000b30c24bfc830549474ba410a18b3d3892915"), @StubPort(path="src/hotspot/cpu/aarch64/macroAssembler_aarch64.cpp", lineStart=3517, lineEnd=3553, commit="fbc036e7454720b589d99a8cae30369a10471528", sha1="a182dc046945490e566e6498c79677484c717a9c")})
public final class AArch64BigIntegerMulAddOp
extends AArch64LIRInstruction {
    public static final LIRInstructionClass<AArch64BigIntegerMulAddOp> TYPE = LIRInstructionClass.create(AArch64BigIntegerMulAddOp.class);
    @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
    private Value resultValue;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
    private Value outValue;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
    private Value inValue;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
    private Value offsetValue;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
    private Value lenValue;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
    private Value kValue;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    private Value outValueTemp;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    private Value inValueTemp;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    private Value offsetValueTemp;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    private Value lenValueTemp;

    public AArch64BigIntegerMulAddOp(LIRGeneratorTool tool, Value outValue, Value inValue, Value offsetValue, Value lenValue, Value kValue, Value resultValue) {
        super((LIRInstructionClass<? extends AArch64LIRInstruction>)TYPE);
        this.outValue = outValue;
        this.inValue = inValue;
        this.offsetValue = offsetValue;
        this.lenValue = lenValue;
        this.kValue = kValue;
        this.resultValue = resultValue;
        this.outValueTemp = tool.newVariable(outValue.getValueKind());
        this.inValueTemp = tool.newVariable(inValue.getValueKind());
        this.offsetValueTemp = tool.newVariable(offsetValue.getValueKind());
        this.lenValueTemp = tool.newVariable(lenValue.getValueKind());
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
        GraalError.guarantee(this.outValue.getPlatformKind().equals(AArch64Kind.QWORD), "Invalid outValue kind: %s", (Object)this.outValue);
        GraalError.guarantee(this.inValue.getPlatformKind().equals(AArch64Kind.QWORD), "Invalid inValue kind: %s", (Object)this.inValue);
        GraalError.guarantee(this.offsetValue.getPlatformKind().equals(AArch64Kind.DWORD), "Invalid offsetValue kind: %s", (Object)this.offsetValue);
        GraalError.guarantee(this.lenValue.getPlatformKind().equals(AArch64Kind.DWORD), "Invalid lenValue kind: %s", (Object)this.lenValue);
        GraalError.guarantee(this.kValue.getPlatformKind().equals(AArch64Kind.DWORD), "Invalid kValue kind: %s", (Object)this.kValue);
        Register out = ValueUtil.asRegister((Value)this.outValueTemp);
        Register in = ValueUtil.asRegister((Value)this.inValueTemp);
        Register offset = ValueUtil.asRegister((Value)this.offsetValueTemp);
        Register len = ValueUtil.asRegister((Value)this.lenValueTemp);
        Register k = ValueUtil.asRegister((Value)this.kValue);
        masm.mov(64, out, ValueUtil.asRegister((Value)this.outValue));
        masm.mov(64, in, ValueUtil.asRegister((Value)this.inValue));
        masm.mov(32, offset, ValueUtil.asRegister((Value)this.offsetValue));
        masm.mov(32, len, ValueUtil.asRegister((Value)this.lenValue));
        try (AArch64MacroAssembler.ScratchRegister sr1 = masm.getScratchRegister();
             AArch64MacroAssembler.ScratchRegister sr2 = masm.getScratchRegister();){
            Register rscratch1 = sr1.getRegister();
            Register rscratch2 = sr2.getRegister();
            Label labelLoop = new Label();
            Label labelEnd = new Label();
            masm.cmp(64, len, AArch64.zr);
            masm.csel(64, out, AArch64.zr, out, AArch64Assembler.ConditionFlag.EQ);
            masm.branchConditionally(AArch64Assembler.ConditionFlag.EQ, labelEnd);
            masm.add(64, in, in, len, AArch64Assembler.ShiftType.LSL, 2);
            masm.add(64, offset, out, offset, AArch64Assembler.ShiftType.LSL, 2);
            masm.mov(64, out, AArch64.zr);
            masm.bind(labelLoop);
            masm.ldr(32, rscratch1, AArch64Address.createImmediateAddress(32, AArch64Address.AddressingMode.IMMEDIATE_PRE_INDEXED, in, -4));
            masm.madd(64, rscratch1, rscratch1, k, out);
            masm.ldr(32, rscratch2, AArch64Address.createImmediateAddress(32, AArch64Address.AddressingMode.IMMEDIATE_PRE_INDEXED, offset, -4));
            masm.add(64, rscratch1, rscratch1, rscratch2);
            masm.str(32, rscratch1, AArch64Address.createBaseRegisterOnlyAddress(32, offset));
            masm.lsr(64, out, rscratch1, 32L);
            masm.subs(64, len, len, 1);
            masm.branchConditionally(AArch64Assembler.ConditionFlag.NE, labelLoop);
            masm.bind(labelEnd);
            masm.mov(32, ValueUtil.asRegister((Value)this.resultValue), out);
        }
    }
}

