/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.aarch64;

import jdk.vm.ci.aarch64.AArch64;
import jdk.vm.ci.aarch64.AArch64Kind;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.asm.Label;
import org.graalvm.compiler.asm.aarch64.AArch64ASIMDAssembler;
import org.graalvm.compiler.asm.aarch64.AArch64Address;
import org.graalvm.compiler.asm.aarch64.AArch64Assembler;
import org.graalvm.compiler.asm.aarch64.AArch64MacroAssembler;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.StubPort;
import org.graalvm.compiler.lir.aarch64.AArch64LIRInstruction;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;
import org.graalvm.compiler.lir.gen.LIRGeneratorTool;

@StubPort(path="src/hotspot/cpu/aarch64/stubGenerator_aarch64.cpp", lineStart=2735, lineEnd=2837, commit="afda8fbf0bcea18cbe741e9c693789ebe0c6c4c5", sha1="a42450cd58995c057fe3c5edb2a63d68a154d735")
public final class AArch64CipherBlockChainingAESEncryptOp
extends AArch64LIRInstruction {
    public static final LIRInstructionClass<AArch64CipherBlockChainingAESEncryptOp> TYPE = LIRInstructionClass.create(AArch64CipherBlockChainingAESEncryptOp.class);
    private final int lengthOffset;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
    protected Value fromValue;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
    protected Value toValue;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
    protected Value keyValue;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
    protected Value rvecValue;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
    protected Value lenValue;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    protected Value fromTempValue;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    protected Value toTempValue;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    protected Value keyTempValue;
    @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
    protected Value resultValue;
    @LIRInstruction.Temp
    protected Value[] simdTemps;

    public AArch64CipherBlockChainingAESEncryptOp(LIRGeneratorTool tool, AllocatableValue fromValue, AllocatableValue toValue, AllocatableValue keyValue, AllocatableValue rvecValue, AllocatableValue lenValue, AllocatableValue resultValue, int lengthOffset) {
        super((LIRInstructionClass<? extends AArch64LIRInstruction>)TYPE);
        this.fromValue = fromValue;
        this.toValue = toValue;
        this.keyValue = keyValue;
        this.rvecValue = rvecValue;
        this.lenValue = lenValue;
        this.resultValue = resultValue;
        this.fromTempValue = tool.newVariable(fromValue.getValueKind());
        this.toTempValue = tool.newVariable(toValue.getValueKind());
        this.keyTempValue = tool.newVariable(keyValue.getValueKind());
        this.lengthOffset = lengthOffset;
        this.simdTemps = new Value[]{AArch64.v0.asValue(), AArch64.v1.asValue(), AArch64.v17.asValue(), AArch64.v18.asValue(), AArch64.v19.asValue(), AArch64.v20.asValue(), AArch64.v21.asValue(), AArch64.v22.asValue(), AArch64.v23.asValue(), AArch64.v24.asValue(), AArch64.v25.asValue(), AArch64.v26.asValue(), AArch64.v27.asValue(), AArch64.v28.asValue(), AArch64.v29.asValue(), AArch64.v30.asValue(), AArch64.v31.asValue()};
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
        GraalError.guarantee(this.fromValue.getPlatformKind().equals(AArch64Kind.QWORD), "Invalid fromValue kind: %s", (Object)this.fromValue);
        GraalError.guarantee(this.toValue.getPlatformKind().equals(AArch64Kind.QWORD), "Invalid toValue kind: %s", (Object)this.toValue);
        GraalError.guarantee(this.keyValue.getPlatformKind().equals(AArch64Kind.QWORD), "Invalid keyValue kind: %s", (Object)this.keyValue);
        GraalError.guarantee(this.rvecValue.getPlatformKind().equals(AArch64Kind.QWORD), "Invalid rvecValue kind: %s", (Object)this.rvecValue);
        GraalError.guarantee(this.lenValue.getPlatformKind().equals(AArch64Kind.DWORD), "Invalid lenValue kind: %s", (Object)this.lenValue);
        GraalError.guarantee(this.resultValue.getPlatformKind().equals(AArch64Kind.DWORD), "Invalid resultValue kind: %s", (Object)this.resultValue);
        try (AArch64MacroAssembler.ScratchRegister sr1 = masm.getScratchRegister();
             AArch64MacroAssembler.ScratchRegister sr2 = masm.getScratchRegister();){
            Label labelLoadkeys44 = new Label();
            Label labelLoadkeys52 = new Label();
            Label labelAesLoop = new Label();
            Label labelRounds44 = new Label();
            Label labelRounds52 = new Label();
            Register from = ValueUtil.asRegister((Value)this.fromTempValue);
            Register to = ValueUtil.asRegister((Value)this.toTempValue);
            Register key = ValueUtil.asRegister((Value)this.keyTempValue);
            Register rvec = ValueUtil.asRegister((Value)this.rvecValue);
            Register keylen = sr1.getRegister();
            Register lenReg = sr2.getRegister();
            masm.mov(64, from, ValueUtil.asRegister((Value)this.fromValue));
            masm.mov(64, to, ValueUtil.asRegister((Value)this.toValue));
            masm.mov(64, key, ValueUtil.asRegister((Value)this.keyValue));
            masm.mov(32, lenReg, ValueUtil.asRegister((Value)this.lenValue));
            masm.ldr(32, keylen, AArch64Address.createImmediateAddress(32, AArch64Address.AddressingMode.IMMEDIATE_SIGNED_UNSCALED, key, this.lengthOffset));
            masm.fldr(128, AArch64.v0, AArch64Address.createBaseRegisterOnlyAddress(128, rvec));
            masm.compare(32, keylen, 52);
            masm.branchConditionally(AArch64Assembler.ConditionFlag.LO, labelLoadkeys44);
            masm.branchConditionally(AArch64Assembler.ConditionFlag.EQ, labelLoadkeys52);
            masm.neon.ld1MultipleVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, AArch64.v17, AArch64.v18, AArch64Address.createStructureImmediatePostIndexAddress(AArch64ASIMDAssembler.ASIMDInstruction.LD1_MULTIPLE_2R, AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, key, 32));
            masm.neon.rev32VV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, AArch64.v17, AArch64.v17);
            masm.neon.rev32VV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, AArch64.v18, AArch64.v18);
            masm.bind(labelLoadkeys52);
            masm.neon.ld1MultipleVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, AArch64.v19, AArch64.v20, AArch64Address.createStructureImmediatePostIndexAddress(AArch64ASIMDAssembler.ASIMDInstruction.LD1_MULTIPLE_2R, AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, key, 32));
            masm.neon.rev32VV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, AArch64.v19, AArch64.v19);
            masm.neon.rev32VV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, AArch64.v20, AArch64.v20);
            masm.bind(labelLoadkeys44);
            masm.neon.ld1MultipleVVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, AArch64.v21, AArch64.v22, AArch64.v23, AArch64.v24, AArch64Address.createStructureImmediatePostIndexAddress(AArch64ASIMDAssembler.ASIMDInstruction.LD1_MULTIPLE_4R, AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, key, 64));
            masm.neon.rev32VV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, AArch64.v21, AArch64.v21);
            masm.neon.rev32VV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, AArch64.v22, AArch64.v22);
            masm.neon.rev32VV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, AArch64.v23, AArch64.v23);
            masm.neon.rev32VV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, AArch64.v24, AArch64.v24);
            masm.neon.ld1MultipleVVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, AArch64.v25, AArch64.v26, AArch64.v27, AArch64.v28, AArch64Address.createStructureImmediatePostIndexAddress(AArch64ASIMDAssembler.ASIMDInstruction.LD1_MULTIPLE_4R, AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, key, 64));
            masm.neon.rev32VV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, AArch64.v25, AArch64.v25);
            masm.neon.rev32VV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, AArch64.v26, AArch64.v26);
            masm.neon.rev32VV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, AArch64.v27, AArch64.v27);
            masm.neon.rev32VV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, AArch64.v28, AArch64.v28);
            masm.neon.ld1MultipleVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, AArch64.v29, AArch64.v30, AArch64.v31, AArch64Address.createBaseRegisterOnlyAddress(128, key));
            masm.neon.rev32VV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, AArch64.v29, AArch64.v29);
            masm.neon.rev32VV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, AArch64.v30, AArch64.v30);
            masm.neon.rev32VV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, AArch64.v31, AArch64.v31);
            masm.bind(labelAesLoop);
            masm.fldr(128, AArch64.v1, AArch64Address.createImmediateAddress(128, AArch64Address.AddressingMode.IMMEDIATE_POST_INDEXED, from, 16));
            masm.neon.eorVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64.v0, AArch64.v0, AArch64.v1);
            masm.branchConditionally(AArch64Assembler.ConditionFlag.LO, labelRounds44);
            masm.branchConditionally(AArch64Assembler.ConditionFlag.EQ, labelRounds52);
            masm.neon.aese(AArch64.v0, AArch64.v17);
            masm.neon.aesmc(AArch64.v0, AArch64.v0);
            masm.neon.aese(AArch64.v0, AArch64.v18);
            masm.neon.aesmc(AArch64.v0, AArch64.v0);
            masm.bind(labelRounds52);
            masm.neon.aese(AArch64.v0, AArch64.v19);
            masm.neon.aesmc(AArch64.v0, AArch64.v0);
            masm.neon.aese(AArch64.v0, AArch64.v20);
            masm.neon.aesmc(AArch64.v0, AArch64.v0);
            masm.bind(labelRounds44);
            masm.neon.aese(AArch64.v0, AArch64.v21);
            masm.neon.aesmc(AArch64.v0, AArch64.v0);
            masm.neon.aese(AArch64.v0, AArch64.v22);
            masm.neon.aesmc(AArch64.v0, AArch64.v0);
            masm.neon.aese(AArch64.v0, AArch64.v23);
            masm.neon.aesmc(AArch64.v0, AArch64.v0);
            masm.neon.aese(AArch64.v0, AArch64.v24);
            masm.neon.aesmc(AArch64.v0, AArch64.v0);
            masm.neon.aese(AArch64.v0, AArch64.v25);
            masm.neon.aesmc(AArch64.v0, AArch64.v0);
            masm.neon.aese(AArch64.v0, AArch64.v26);
            masm.neon.aesmc(AArch64.v0, AArch64.v0);
            masm.neon.aese(AArch64.v0, AArch64.v27);
            masm.neon.aesmc(AArch64.v0, AArch64.v0);
            masm.neon.aese(AArch64.v0, AArch64.v28);
            masm.neon.aesmc(AArch64.v0, AArch64.v0);
            masm.neon.aese(AArch64.v0, AArch64.v29);
            masm.neon.aesmc(AArch64.v0, AArch64.v0);
            masm.neon.aese(AArch64.v0, AArch64.v30);
            masm.neon.eorVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64.v0, AArch64.v0, AArch64.v31);
            masm.fstr(128, AArch64.v0, AArch64Address.createImmediateAddress(128, AArch64Address.AddressingMode.IMMEDIATE_POST_INDEXED, to, 16));
            masm.sub(32, lenReg, lenReg, 16);
            masm.cbnz(32, lenReg, labelAesLoop);
            masm.fstr(128, AArch64.v0, AArch64Address.createBaseRegisterOnlyAddress(128, rvec));
            masm.mov(32, ValueUtil.asRegister((Value)this.resultValue), ValueUtil.asRegister((Value)this.lenValue));
        }
    }
}

